/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.BufferEncoder;
import com.garmin.fit.Decode;
import com.garmin.fit.Fit;
import com.garmin.fit.FitDecoder;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.csv.CSVDataMesgFieldCounter;
import com.garmin.fit.csv.CSVReader;
import com.garmin.fit.csv.MesgCSVWriter;
import com.garmin.fit.csv.MesgDataCSVWriter;
import com.garmin.fit.csv.MesgFilter;
import com.garmin.fit.plugins.ActivityFileValidationPlugin;
import com.garmin.fit.plugins.ActivityFileValidationResult;
import com.garmin.fit.util.StreamHelpers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class CSVTool {
    public boolean runningFromConsole = false;
    private final int DATA_OR_DEFINITION_SEARCH_COUNT = 2;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ByteArrayOutputStream dataWriterByteArrayOutputStream = null;
    private MesgDataCSVWriter dataMesgWriter = null;
    private MesgCSVWriter mesgWriter;
    private MesgFilter mesgFilter;
    private CSVDataMesgFieldCounter csvDataMesgFieldCounter;
    private int numUnknownFields = 0;
    private int numUnknownMesgs = 0;
    private final Decode decode = new Decode();
    private HashSet<String> mesgDefinitionsToOutput = new HashSet();
    private HashSet<String> dataMessagesToOutput = new HashSet();
    private boolean bytesAsHex = false;
    private boolean dateTimeAsISO8601 = false;
    private boolean semicirclesAsDegrees = false;
    private boolean verificationTests = false;
    private boolean checkIntegrity = false;
    private boolean showInvalidValues = false;
    private boolean showInvalidsAsEmpty = false;
    private boolean hideUnknownData = false;
    private boolean generateDataFile = false;
    private boolean enumsAsStrings = false;
    private boolean preserveGaps = false;
    private boolean removeExpandedFields = false;
    private boolean excludeMesgList = false;
    private Fit.ProtocolVersion protocolVersion = Fit.ProtocolVersion.V2_0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String outputFileName;
        CSVTool csvTool;
        block41: {
            csvTool = new CSVTool();
            csvTool.runningFromConsole = true;
            String inputFileName = null;
            outputFileName = null;
            boolean fitToCsv = false;
            boolean csvToFit = false;
            int nextArgumentDefinition = 0;
            int nextArgumentData = 0;
            System.out.printf("FIT CSV Tool - Protocol %d.%d Profile %d.%d %s\n\n", Fit.PROTOCOL_VERSION_MAJOR, Fit.PROTOCOL_VERSION_MINOR, 21, 141, "Release");
            for (int arg = 0; arg < args.length; ++arg) {
                block40: {
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block50: {
                                            block51: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block43: {
                                                                            block42: {
                                                                                if (!args[arg].equals("-b")) break block42;
                                                                                if (args.length - arg < 3) {
                                                                                    CSVTool.printUsage();
                                                                                    return;
                                                                                }
                                                                                fitToCsv = true;
                                                                                inputFileName = args[arg + 1];
                                                                                outputFileName = args[arg + 2];
                                                                                arg += 2;
                                                                                break block40;
                                                                            }
                                                                            if (!args[arg].equals("-c")) break block43;
                                                                            if (args.length - arg < 3) {
                                                                                CSVTool.printUsage();
                                                                                return;
                                                                            }
                                                                            csvToFit = true;
                                                                            inputFileName = args[arg + 1];
                                                                            outputFileName = args[arg + 2];
                                                                            arg += 2;
                                                                            break block40;
                                                                        }
                                                                        if (!args[arg].equals("-t")) break block44;
                                                                        csvTool.enableVerificationTests(true);
                                                                        break block40;
                                                                    }
                                                                    if (!args[arg].equals("-d")) break block45;
                                                                    csvTool.enableFitSdkDebugging(true);
                                                                    csvTool.enableVerificationTests(true);
                                                                    break block40;
                                                                }
                                                                if (!args[arg].equals("-i")) break block46;
                                                                csvTool.enableCheckIntegrity(true);
                                                                break block40;
                                                            }
                                                            if (!args[arg].equals("-ex")) break block47;
                                                            csvTool.setExcludeMesgList(true);
                                                            break block40;
                                                        }
                                                        if (!args[arg].equals("--defn")) break block48;
                                                        nextArgumentDefinition = csvTool.DATA_OR_DEFINITION_SEARCH_COUNT;
                                                        break block40;
                                                    }
                                                    if (!args[arg].equals("--data")) break block49;
                                                    nextArgumentData = csvTool.DATA_OR_DEFINITION_SEARCH_COUNT;
                                                    csvTool.enableGenerateDataFile(true);
                                                    break block40;
                                                }
                                                if (args[arg].charAt(0) == '-') break block50;
                                                if (nextArgumentDefinition <= 0) break block51;
                                                csvTool.setMesgDefinitionFilter(new HashSet<String>(Arrays.asList(args[arg].toLowerCase().split(","))));
                                                break block40;
                                            }
                                            if (nextArgumentData > 0) {
                                                csvTool.setDataMessagesFilter(new HashSet<String>(Arrays.asList(args[arg].toLowerCase().split(","))));
                                                break block40;
                                            } else {
                                                inputFileName = args[arg];
                                                if (inputFileName.endsWith(".fit")) {
                                                    fitToCsv = true;
                                                    outputFileName = inputFileName.substring(0, inputFileName.length() - 4) + ".csv";
                                                    break block40;
                                                } else {
                                                    if (!inputFileName.endsWith(".csv")) {
                                                        System.out.println("Invalid file provided " + inputFileName + " is not a .fit or .csv file");
                                                        CSVTool.printUsage();
                                                        return;
                                                    }
                                                    csvToFit = true;
                                                    outputFileName = inputFileName.substring(0, inputFileName.length() - 4) + ".fit";
                                                }
                                            }
                                            break block40;
                                        }
                                        if (!args[arg].equals("-s")) break block52;
                                        csvTool.enableShowInvalidValues(true);
                                        break block40;
                                    }
                                    if (!args[arg].equals("-se")) break block53;
                                    csvTool.enableShowInvalidValues(true);
                                    csvTool.enableShowInvalidsAsEmpty(true);
                                    break block40;
                                }
                                if (!args[arg].equals("-u")) break block54;
                                csvTool.enableHideUnknownData(true);
                                break block40;
                            }
                            if (!args[arg].equals("-x")) break block55;
                            csvTool.enableBytesAsHex(true);
                            break block40;
                        }
                        if (!args[arg].startsWith("-p")) break block56;
                        if (args[arg].endsWith("1")) {
                            csvTool.setProtocolVersion(Fit.ProtocolVersion.V1_0);
                            break block40;
                        } else if (args[arg].endsWith("2")) {
                            csvTool.setProtocolVersion(Fit.ProtocolVersion.V2_0);
                            break block40;
                        } else {
                            System.out.println("Unknown Protocol Version.");
                        }
                        break block40;
                    }
                    if (args[arg].equals("-e")) {
                        csvTool.enableEnumsAsStrings(true);
                    } else if (args[arg].equals("-re")) {
                        csvTool.enableRemoveExpandedFields(true);
                    } else if (args[arg].equals("-deg")) {
                        csvTool.enableSemicirclesAsDegrees(true);
                    } else if (args[arg].equals("-iso8601")) {
                        csvTool.enableDateTimeAsISO8601(true);
                    } else if (args[arg].equals("-g")) {
                        csvTool.enablePreserveGaps(true);
                    }
                }
                if (nextArgumentDefinition > 0 && --nextArgumentDefinition == 0 && csvTool.mesgDefinitionsToOutput.isEmpty()) {
                    System.out.println("No mesg definitions defined for --defn option.  Use 'none' if no definitions are desired.");
                    return;
                }
                if (nextArgumentData <= 0 || --nextArgumentData != 0 || !csvTool.dataMessagesToOutput.isEmpty()) continue;
                System.out.println("No data messages defined for --data option.");
                return;
            }
            if (inputFileName == null || inputFileName.isEmpty()) {
                System.out.println("No input file was provided!");
                CSVTool.printUsage();
                return;
            }
            File file = new File(inputFileName);
            if (!file.exists()) {
                System.out.println("File does not exist: " + inputFileName);
                return;
            }
            if (fitToCsv) {
                if (outputFileName.length() >= 4 && outputFileName.substring(outputFileName.length() - 4, outputFileName.length()).compareTo(".csv") == 0) {
                    outputFileName = outputFileName.substring(0, outputFileName.length() - 4);
                }
                System.out.printf("Decoding FIT binary file %s to %s*.csv files.\n", inputFileName, outputFileName);
                try {
                    ByteArrayInputStream byteArrayInputStream = StreamHelpers.byteStreamFromFile(inputFileName);
                    csvTool.convertFitToCsv(byteArrayInputStream);
                }
                catch (OutOfMemoryError e) {
                    System.out.printf("\n\nThere is insufficient memory available to process the file. Please increase the available memory by using the -Xmx<size> option when running the FIT CSV Tool.\ni.e. java -Xmx1G -jar FitCsvTool.jar %s\n", inputFileName);
                }
                catch (Exception e) {
                    System.out.printf("Error: A problem occurred while decoding the file. The decoded CSV file may be truncated %s*.csv files.\n", outputFileName);
                }
                try {
                    ByteArrayOutputStream csvByteArrayOutputStream = csvTool.getByteArrayOutputStream();
                    if (csvByteArrayOutputStream.toString().equals("")) {
                        if (csvTool.getDataMessagesFilter().size() == 0 && csvTool.getMesgDefinitionsFilter().size() == 0) {
                            System.out.println("Warning: No messages or message definitions found.");
                            return;
                        }
                        System.out.println("Warning: No filtered messages or filtered message definitions found.");
                        return;
                    }
                    StreamHelpers.writeByteStreamToFile(csvByteArrayOutputStream, outputFileName + ".csv", true);
                    if (csvTool.isGenerateDataFileEnabled()) {
                        ByteArrayOutputStream dataCsvStream = csvTool.getDataWriterByteArrayOutputStream();
                        StreamHelpers.writeByteStreamToFile(dataCsvStream, outputFileName + "_data.csv", false);
                    }
                    if (!csvTool.isHideUnknownDataEnabled()) return;
                    System.out.printf("Hid %d unknown field(s) and %d unknown message(s).\n", csvTool.getNumUnknownFields(), csvTool.getNumUnknownMesgs());
                    return;
                }
                catch (Exception e) {
                    System.out.println("Error: A problem occurred while writing the output CSV files.");
                    return;
                }
            }
            if (!csvToFit) {
                CSVTool.printUsage();
                return;
            }
            if (outputFileName.length() >= 4 && outputFileName.substring(outputFileName.length() - 4, outputFileName.length()).compareTo(".fit") == 0) {
                outputFileName = outputFileName.substring(0, outputFileName.length() - 4);
            }
            System.out.printf("Encoding %s into FIT binary file %s.fit.\n", inputFileName, outputFileName);
            try {
                ByteArrayInputStream byteArrayInputStream = StreamHelpers.byteStreamFromFile(inputFileName);
                csvTool.convertCsvToFit(byteArrayInputStream);
            }
            catch (Exception e) {
                System.out.printf("Error: A problem occurred while encoding the file. The encoded FIT file %s.fit may be a truncated.\n", outputFileName);
                if (e.getMessage() == null) break block41;
                System.out.println(e.getMessage());
            }
        }
        try {
            ByteArrayOutputStream fitByteArrayOutputStream = csvTool.getByteArrayOutputStream();
            StreamHelpers.writeByteStreamToFile(fitByteArrayOutputStream, outputFileName + ".fit", false);
            return;
        }
        catch (Exception e) {
            System.out.println("Error: A problem occurred while writing the output FIT file.");
            return;
        }
    }

    public ByteArrayOutputStream convertFitToCsv(ByteArrayInputStream byteArrayInputStream) throws Exception {
        if (this.checkIntegrity) {
            if (!this.decode.checkFileIntegrity(byteArrayInputStream)) {
                if (!this.decode.getInvalidFileDataSize()) {
                    throw new FitRuntimeException("FIT file integrity failure.");
                }
                this.println("FIT file integrity failure. Invalid file size in header.");
                this.println("Trying to continue...");
            }
            byteArrayInputStream.reset();
        }
        if (this.verificationTests) {
            this.runVerificationTests(byteArrayInputStream);
        }
        try {
            this.setupCsvWriter();
            if (this.generateDataFile) {
                this.setupDataWriter();
            }
            if (this.showInvalidValues) {
                this.decode.showInvalidValues();
            }
            this.mesgFilter = new MesgFilter();
            this.csvDataMesgFieldCounter = new CSVDataMesgFieldCounter();
            if (this.excludeMesgList) {
                this.mesgFilter.setMesgDefinitionsToIgnore(this.mesgDefinitionsToOutput);
                this.mesgFilter.setDataMessagesToIgnore(this.dataMessagesToOutput);
            } else {
                this.mesgFilter.setMesgDefinitionsToOutput(this.mesgDefinitionsToOutput);
                this.mesgFilter.setDataMessagesToOutput(this.dataMessagesToOutput);
            }
            this.registerListenersForCsvWriter();
            this.registerListenersForDataWriter();
            while (this.decode.bytesAvailable(byteArrayInputStream)) {
                try {
                    this.decode.read(byteArrayInputStream);
                    this.decode.nextFile();
                }
                catch (FitRuntimeException e) {
                    if (this.decode.getInvalidFileDataSize()) {
                        this.decode.nextFile();
                        continue;
                    }
                    throw e;
                }
            }
            if (this.dataMesgWriter != null) {
                this.dataMesgWriter.setMaxNumFields(this.csvDataMesgFieldCounter.getMaxNumFields());
            }
            this.csvDataMesgFieldCounter.flushMesgs();
        }
        catch (IOException e) {
            if (this.isFitSdkDebugEnabled()) {
                e.printStackTrace(System.out);
            }
            throw e;
        }
        finally {
            this.numUnknownFields = this.mesgWriter.getNumUnknownFields();
            this.numUnknownMesgs = this.mesgWriter.getNumUnknownMesgs();
            this.cleanupCsvWriter();
            this.cleanupDataWriter();
        }
        return this.byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream convertCsvToFit(ByteArrayInputStream byteArrayInputStream) throws Exception {
        BufferEncoder encoder = new BufferEncoder(this.protocolVersion);
        try {
            if (!CSVReader.read(byteArrayInputStream, encoder, encoder, this.protocolVersion)) {
                throw new FitRuntimeException("FIT encoding error.");
            }
        }
        finally {
            byte[] fitFileBytes = encoder.close();
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.byteArrayOutputStream.write(fitFileBytes);
        }
        return this.byteArrayOutputStream;
    }

    private void setupCsvWriter() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.mesgWriter = new MesgCSVWriter(this.byteArrayOutputStream);
        if (this.bytesAsHex) {
            this.mesgWriter.enableBytesAsHex(true);
        }
        if (this.dateTimeAsISO8601) {
            this.mesgWriter.enableDateTimeAsISO8601(true);
        }
        if (this.showInvalidsAsEmpty) {
            this.mesgWriter.enableShowInvalidsAsEmpty(true);
        }
        if (this.hideUnknownData) {
            this.mesgWriter.enableHideUnknownData(true);
        }
        if (this.enumsAsStrings) {
            this.mesgWriter.enableEnumsAsStrings(true);
        }
        if (this.removeExpandedFields) {
            this.mesgWriter.enableRemoveExpandedFields(true);
        }
        if (this.semicirclesAsDegrees) {
            this.mesgWriter.enableSemicirclesAsDegrees(true);
        }
    }

    private void setupDataWriter() {
        this.dataWriterByteArrayOutputStream = new ByteArrayOutputStream();
        this.dataMesgWriter = new MesgDataCSVWriter(this.dataWriterByteArrayOutputStream);
        if (this.bytesAsHex) {
            this.dataMesgWriter.enableBytesAsHex(true);
        }
        if (this.dateTimeAsISO8601) {
            this.dataMesgWriter.enableDateTimeAsISO8601(true);
        }
        if (this.showInvalidsAsEmpty) {
            this.dataMesgWriter.enableShowInvalidsAsEmpty(true);
        }
        if (this.hideUnknownData) {
            this.dataMesgWriter.enableHideUnknownData(true);
        }
        if (this.enumsAsStrings) {
            this.dataMesgWriter.enableEnumsAsStrings(true);
        }
        if (this.removeExpandedFields) {
            this.dataMesgWriter.enableRemoveExpandedFields(true);
        }
        if (this.semicirclesAsDegrees) {
            this.dataMesgWriter.enableSemicirclesAsDegrees(true);
        }
        if (this.preserveGaps) {
            this.dataMesgWriter.enablePreserveGaps(true);
        }
    }

    private void registerListenersForCsvWriter() {
        this.mesgFilter.addListener(this.mesgWriter);
        this.mesgFilter.addListener(this.mesgWriter);
        this.decode.addListener(this.mesgFilter);
        this.decode.addListener(this.mesgFilter);
    }

    private void registerListenersForDataWriter() {
        if (this.dataMesgWriter != null && this.csvDataMesgFieldCounter != null) {
            this.mesgFilter.addListener(this.csvDataMesgFieldCounter);
            this.csvDataMesgFieldCounter.addListener(this.dataMesgWriter);
        }
    }

    private void cleanupCsvWriter() {
        this.mesgWriter.close();
    }

    private void cleanupDataWriter() {
        if (this.dataMesgWriter != null) {
            this.dataMesgWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runVerificationTests(ByteArrayInputStream byteArrayInputStream) {
        block11: {
            ActivityFileValidationPlugin plugin;
            block10: {
                System.out.println("Running FIT verification tests...");
                plugin = new ActivityFileValidationPlugin();
                try {
                    FitDecoder fitDecoder = new FitDecoder();
                    fitDecoder.decode(byteArrayInputStream, plugin);
                    if (plugin.getResults().size() != 0) break block10;
                }
                catch (FitRuntimeException e) {
                    System.out.println("FitRuntimeException decoding file: " + e.getMessage());
                    break block11;
                }
                catch (Exception e2) {
                    System.out.println("Exception decoding file: " + e2.getMessage());
                    break block11;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (plugin.getResults().size() == 0) {
                        plugin.repeatValidation();
                    }
                    System.out.println("Message Count: " + plugin.getMesgCount());
                    for (ActivityFileValidationResult result : plugin.getResults()) {
                        System.out.println(result);
                        if (result.getDescription() == null) continue;
                        System.out.println("\t" + result.getDescription());
                    }
                    byteArrayInputStream.reset();
                }
                plugin.repeatValidation();
            }
            System.out.println("Message Count: " + plugin.getMesgCount());
            for (ActivityFileValidationResult result : plugin.getResults()) {
                System.out.println(result);
                if (result.getDescription() == null) continue;
                System.out.println("\t" + result.getDescription());
            }
            byteArrayInputStream.reset();
        }
    }

    private void println(String string) {
        if (this.runningFromConsole) {
            System.out.println(string);
        }
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    public ByteArrayOutputStream getDataWriterByteArrayOutputStream() {
        return this.dataWriterByteArrayOutputStream;
    }

    public void setProtocolVersion(Fit.ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Fit.ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setMesgDefinitionFilter(HashSet<String> mesgDefinitionsToOutput) {
        this.mesgDefinitionsToOutput = mesgDefinitionsToOutput;
    }

    public HashSet<String> getMesgDefinitionsFilter() {
        return this.mesgDefinitionsToOutput;
    }

    public void setDataMessagesFilter(HashSet<String> dataMessagesToOutput) {
        this.dataMessagesToOutput = dataMessagesToOutput;
    }

    public HashSet<String> getDataMessagesFilter() {
        return this.dataMessagesToOutput;
    }

    public int getNumUnknownFields() {
        return this.numUnknownFields;
    }

    public int getNumUnknownMesgs() {
        return this.numUnknownMesgs;
    }

    public void enableHideUnknownData(boolean enable) {
        this.hideUnknownData = enable;
    }

    public boolean isHideUnknownDataEnabled() {
        return this.hideUnknownData;
    }

    public void enableGenerateDataFile(boolean enable) {
        this.generateDataFile = enable;
    }

    public boolean isGenerateDataFileEnabled() {
        return this.generateDataFile;
    }

    public void enableVerificationTests(boolean enable) {
        this.verificationTests = enable;
    }

    public boolean isVerificationTestsEnabled() {
        return this.verificationTests;
    }

    public void enableBytesAsHex(boolean enable) {
        this.bytesAsHex = enable;
    }

    public boolean isBytesAsHexEnabled() {
        return this.bytesAsHex;
    }

    public void enableDateTimeAsISO8601(boolean enable) {
        this.dateTimeAsISO8601 = enable;
    }

    public boolean isDateTimeAsISO8601Enabled() {
        return this.dateTimeAsISO8601;
    }

    public void enableSemicirclesAsDegrees(boolean enable) {
        this.semicirclesAsDegrees = enable;
    }

    public boolean isSemicirclesAsDegreesEnabled() {
        return this.semicirclesAsDegrees;
    }

    public void enableCheckIntegrity(boolean enable) {
        this.checkIntegrity = enable;
    }

    public boolean isCheckIntegrityEnabled() {
        return this.checkIntegrity;
    }

    public void enableShowInvalidValues(boolean enable) {
        this.showInvalidValues = enable;
    }

    public boolean isShowInvalidValuesEnabled() {
        return this.showInvalidValues;
    }

    public void enableShowInvalidsAsEmpty(boolean enable) {
        this.showInvalidsAsEmpty = enable;
        if (this.showInvalidsAsEmpty) {
            this.showInvalidValues = true;
        }
    }

    public boolean isShowInvalidsAsEmptyEnabled() {
        return this.showInvalidsAsEmpty;
    }

    public void enableEnumsAsStrings(boolean enable) {
        this.enumsAsStrings = enable;
    }

    public boolean isEnumsAsStringsEnabled() {
        return this.enumsAsStrings;
    }

    public void enablePreserveGaps(boolean enable) {
        this.preserveGaps = enable;
    }

    public boolean isPreserveGapsEnabled() {
        return this.preserveGaps;
    }

    public void enableRemoveExpandedFields(boolean enable) {
        this.removeExpandedFields = enable;
    }

    public boolean isRemoveExpandedFieldsEnabled() {
        return this.removeExpandedFields;
    }

    public void setExcludeMesgList(boolean excludeMesgList) {
        this.excludeMesgList = excludeMesgList;
    }

    public boolean isExcludeMesgListEnabled() {
        return this.excludeMesgList;
    }

    public void enableFitSdkDebugging(boolean enable) {
        Fit.debug = enable;
    }

    public boolean isFitSdkDebugEnabled() {
        return Fit.debug;
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar FitCSVTool.jar <options> <file>");
        System.out.println("      -b <FIT FILE> <CSV FILE>  FIT binary to CSV.");
        System.out.println("      -c <CSV FILE> <FIT FILE>  CSV to FIT binary.");
        System.out.println("      -t Enable file verification tests.");
        System.out.println("      -d Enable debug output.");
        System.out.println("      -i Check integrity of FIT file before decoding.");
        System.out.println("      -s Show invalid fields in the CSV file.");
        System.out.println("      -se Show invalid fields in the CSV file as empty cells.");
        System.out.println("      -u Hide unknown data and report statistics on how much is hidden.");
        System.out.println("      -x Print byte values as hexadecimal.");
        System.out.println("      -deg Print semicircle values as degrees.");
        System.out.println("      -iso8601 Print date-time values as ISO 8601 formatted strings.");
        System.out.println("      -ex Changes the behaviour of the --defn and --data options to");
        System.out.println("          filter out the messages listed. The default behaviour without");
        System.out.println("          this flag is to exclude all messages except those listed");
        System.out.println("          after the --defn and the --data options.");
        System.out.println("      -pN Encode file using Protocol Version <N>. Default: 2");
        System.out.println("      -e Print enum values as their corresponding String labels when");
        System.out.println("          possible. Note: CSV files generated with this option will not");
        System.out.println("          be able to be converted back into .FIT files.");
        System.out.println("      -re Remove expanded fields from CSV output. This removes fields");
        System.out.println("          that have been generated through component expansion and");
        System.out.println("          which do not exist in the source .FIT file");
        System.out.println("      --defn <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          definitions output to CSV. Use 'none' for no definitions");
        System.out.println("          When this option is used only the message definitions");
        System.out.println("          in the comma separated list will be written to the CSV.");
        System.out.println("          eg. --defn file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
        System.out.println("      --data <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          data output to CSV. When this option is used only the data");
        System.out.println("          in the comma separated list will be written to the csv.");
        System.out.println("          eg. --data file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
        System.out.println("      -g Preserve gaps caused by data dropouts. ");
        System.out.println("          Note: This option is only compatible with the --data option");
    }
}

