/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;

public class CSVWriter {
    private final OutputStream outputStream;
    private ByteArrayOutputStream intermediateOutputStream;
    private BufferedWriter intermediateWriter;
    private final ArrayList<String> headers = new ArrayList();
    private final ArrayList<String> values = new ArrayList();
    private int maxNumberValues = 0;

    public CSVWriter(ByteArrayOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public ArrayList<String> getHeaders() {
        return this.headers;
    }

    public void close() {
        try {
            if (this.intermediateWriter != null) {
                this.intermediateWriter.close();
                this.intermediateWriter = null;
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));
                for (String header : this.headers) {
                    writer.write(header + ",");
                }
                writer.write("\n");
                byte[] intermediateContents = this.intermediateOutputStream.toByteArray();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(intermediateContents), StandardCharsets.UTF_8));
                while (reader.ready()) {
                    writer.write(reader.readLine() + "\n");
                }
                reader.close();
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        Collections.fill(this.values, "");
    }

    public void set(String header, Object value) {
        if (header == null) {
            header = "null";
        }
        if (value == null) {
            value = "null";
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            if (this.headers.get(i).compareTo(header) != 0) continue;
            this.values.set(i, value.toString());
            return;
        }
        this.headers.add(header);
        this.values.add(value.toString());
    }

    public void writeln() {
        try {
            if (this.intermediateWriter == null) {
                this.intermediateOutputStream = new ByteArrayOutputStream();
                this.intermediateWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.intermediateOutputStream, StandardCharsets.UTF_8));
            }
            for (String value : this.values) {
                this.intermediateWriter.write(value + ",");
            }
            if (this.values.size() < this.maxNumberValues) {
                for (int i = 0; i < this.maxNumberValues - this.values.size(); ++i) {
                    this.intermediateWriter.write(",");
                }
            }
            this.intermediateWriter.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMaxNumberValues(int numberValues) {
        this.maxNumberValues = numberValues;
    }
}

