/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.MesgCSVWriterBase;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;

public class MesgCSVWriter
extends MesgCSVWriterBase
implements MesgListener,
MesgDefinitionListener {
    private int numUnknownMesgs = 0;
    private int numUnknownFields = 0;
    private boolean dataInCsv;

    public MesgCSVWriter(ByteArrayOutputStream byteArrayOutputStream) {
        super(byteArrayOutputStream);
    }

    @Override
    public void close() {
        this.csv.close();
    }

    public int getNumUnknownMesgs() {
        return this.numUnknownMesgs;
    }

    public int getNumUnknownFields() {
        return this.numUnknownFields;
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDef) {
        ArrayList<FieldDefinition> fields = mesgDef.getFields();
        Mesg mesg = Factory.createMesg(mesgDef.getNum());
        if (this.hideUnknownData && mesg.getName().equals("unknown")) {
            return;
        }
        this.csv.clear();
        this.csv.set("Type", "Definition");
        this.csv.set("Local Number", mesgDef.getLocalNum());
        this.csv.set("Message", mesg.getName());
        int headerNum = 0;
        for (FieldDefinition fieldDefinition : fields) {
            Field field = Factory.createField(mesgDef.getNum(), fieldDefinition.getNum());
            if (this.hideUnknownData && field.getName().equals("unknown")) {
                ++this.numUnknownFields;
                continue;
            }
            this.csv.set("Field " + ++headerNum, field.getName());
            this.csv.set("Value " + headerNum, fieldDefinition.getSize() / Fit.baseTypeSizes[fieldDefinition.getType() & 0x1F]);
            this.csv.set("Units " + headerNum, "");
        }
        for (DeveloperFieldDefinition developerFieldDefinition : mesgDef.getDeveloperFields()) {
            if (this.hideUnknownData && !developerFieldDefinition.isDefined()) {
                ++this.numUnknownFields;
                continue;
            }
            ++headerNum;
            if (!developerFieldDefinition.isDefined()) {
                this.csv.set("Field " + headerNum, "undefined-dev-data");
            } else {
                this.csv.set("Field " + headerNum, developerFieldDefinition.getFieldName());
            }
            this.csv.set("Value " + headerNum, developerFieldDefinition.getSize() / Fit.baseTypeSizes[developerFieldDefinition.getType() & 0x1F]);
            this.csv.set("Units " + headerNum, "");
        }
        this.csv.writeln();
        this.dataInCsv = true;
    }

    @Override
    public void onMesg(Mesg mesg) {
        Collection<Field> fields = mesg.getFields();
        if (mesg.getName().equals("unknown") && this.hideUnknownData) {
            ++this.numUnknownMesgs;
            return;
        }
        this.csv.clear();
        this.csv.set("Type", "Data");
        this.csv.set("Local Number", mesg.getLocalNum());
        this.csv.set("Message", mesg.getName());
        if (this.removeExpandedFields) {
            mesg.removeExpandedFields();
        }
        int headerNum = 0;
        for (Field field : fields) {
            int subFieldIndex = mesg.getActiveSubFieldIndex(field.getNum());
            if (field.getName().equals("unknown") && this.hideUnknownData) continue;
            this.csv.set("Field " + ++headerNum, field.getName(subFieldIndex));
            String value = null;
            if (null == value) {
                value = this.getValueString(field, subFieldIndex);
            }
            this.csv.set("Value " + headerNum, value);
            this.csv.set("Units " + headerNum, this.formatUnits(field.getUnits(), field.getProfileType().name()));
        }
        for (DeveloperField developerField : mesg.getDeveloperFields()) {
            if (!developerField.isDefined() && this.hideUnknownData) continue;
            this.csv.set("Field " + ++headerNum, developerField.getName());
            String value = this.getValueString(developerField, 65535);
            this.csv.set("Value " + headerNum, value);
            this.csv.set("Units " + headerNum, this.formatUnits(developerField.getUnits()));
        }
        this.csv.writeln();
        this.dataInCsv = true;
    }

    public boolean csvHasData() {
        return this.dataInCsv;
    }
}

