/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.Fit;
import com.garmin.fit.Profile;
import com.garmin.fit.csv.CSVWriter;
import com.garmin.fit.util.DateTimeConverter;
import com.garmin.fit.util.SemicirclesConverter;
import java.io.ByteArrayOutputStream;

public class MesgCSVWriterBase {
    protected CSVWriter csv;
    protected boolean bytesAsHex = false;
    protected boolean dateTimeAsISO8601 = false;
    protected boolean enumsAsStrings = false;
    protected boolean hideUnknownData = false;
    protected boolean showInvalidsAsEmpty = false;
    protected boolean removeExpandedFields = false;
    protected boolean preserveGaps = false;
    protected boolean semicirclesAsDegrees = false;

    public MesgCSVWriterBase(ByteArrayOutputStream byteArrayOutputStream) {
        this.csv = new CSVWriter(byteArrayOutputStream);
    }

    public void close() {
        this.csv.close();
    }

    public void enableHideUnknownData(boolean enable) {
        this.hideUnknownData = enable;
    }

    public boolean isHideUnknownDataEnabled() {
        return this.hideUnknownData;
    }

    public void enableBytesAsHex(boolean enable) {
        this.bytesAsHex = enable;
    }

    public boolean isBytesAsHexEnabled() {
        return this.bytesAsHex;
    }

    public void enableDateTimeAsISO8601(boolean enable) {
        this.dateTimeAsISO8601 = enable;
    }

    public boolean isDateTimeAsISO8601Enabled() {
        return this.dateTimeAsISO8601;
    }

    public void enableSemicirclesAsDegrees(boolean enable) {
        this.semicirclesAsDegrees = enable;
    }

    public boolean isSemicirclesAsDegreesEnabled() {
        return this.semicirclesAsDegrees;
    }

    public void enableShowInvalidsAsEmpty(boolean enable) {
        this.showInvalidsAsEmpty = enable;
    }

    public boolean isShowInvalidsAsEmptyEnabled() {
        return this.showInvalidsAsEmpty;
    }

    public void enableEnumsAsStrings(boolean enable) {
        this.enumsAsStrings = enable;
    }

    public boolean isEnumsAsStringsEnabled() {
        return this.enumsAsStrings;
    }

    public void enablePreserveGaps(boolean enable) {
        this.preserveGaps = enable;
    }

    public boolean isPreserveGapsEnabled() {
        return this.preserveGaps;
    }

    public void enableRemoveExpandedFields(boolean enable) {
        this.removeExpandedFields = enable;
    }

    public boolean isRemoveExpandedFieldsEnabled() {
        return this.removeExpandedFields;
    }

    protected String getValueString(FieldBase fieldBase, int subFieldIndex) {
        Profile.Type profileType;
        Object value = fieldBase.getValue(0, subFieldIndex);
        StringBuilder outStringBuilder = new StringBuilder();
        try {
            Field field = (Field)fieldBase;
            profileType = field.getProfileType();
        }
        catch (ClassCastException e) {
            profileType = Profile.Type.ENUM;
        }
        for (int fieldElement = 0; fieldElement < fieldBase.getNumValues(); ++fieldElement) {
            if (value == null || this.showInvalidsAsEmpty && value.equals(Fit.baseTypeInvalidMap.get(fieldBase.getType(subFieldIndex)))) continue;
            value = fieldBase.getValue(fieldElement, subFieldIndex);
            if (this.bytesAsHex && fieldBase.getType(subFieldIndex) == 13) {
                outStringBuilder.append(String.format("0x%02x", value));
            } else if (this.semicirclesAsDegrees && fieldBase.getUnits().equals("semicircles")) {
                double degrees = SemicirclesConverter.semicirclesToDegrees(Integer.parseInt(value.toString()));
                outStringBuilder.append(String.format("%.8f", degrees));
            } else if (this.dateTimeAsISO8601 && profileType.name().equalsIgnoreCase("DATE_TIME")) {
                outStringBuilder.append(DateTimeConverter.fitTimestampToISO8601((Long)value));
            } else if (this.enumsAsStrings && profileType.ordinal() > Profile.Type.BOOL.ordinal()) {
                outStringBuilder.append(Profile.enumValueName(profileType, ((Number)value).longValue()));
            } else {
                outStringBuilder.append(value.toString());
            }
            if (fieldElement == fieldBase.getNumValues() - 1) continue;
            outStringBuilder.append('|');
        }
        String out = outStringBuilder.toString();
        out = out.replaceAll("\"", "\"\"");
        out = "\"" + out + "\"";
        return out;
    }

    protected String formatUnits(String units) {
        return this.formatUnits(units, null);
    }

    protected String formatUnits(String units, String profileType) {
        if (this.semicirclesAsDegrees && units.equalsIgnoreCase("semicircles")) {
            return "degrees";
        }
        if (this.dateTimeAsISO8601 && profileType != null && profileType.equalsIgnoreCase("DATE_TIME")) {
            return "";
        }
        return units;
    }
}

