/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.MesgCSVWriterBase;
import java.io.ByteArrayOutputStream;

public class MesgDataCSVWriter
extends MesgCSVWriterBase
implements MesgListener {
    public MesgDataCSVWriter(ByteArrayOutputStream byteArrayOutputStream) {
        super(byteArrayOutputStream);
    }

    @Override
    public void onMesg(Mesg mesg) {
        if (mesg.getName().equals("unknown") && this.hideUnknownData) {
            return;
        }
        if (this.removeExpandedFields) {
            mesg.removeExpandedFields();
        }
        if (this.preserveGaps) {
            this.clearMesgFields(mesg);
        }
        for (Field field : mesg.getFields()) {
            if (this.hideUnknownData && field.getName().equals("unknown")) continue;
            int subFieldIndex = mesg.getActiveSubFieldIndex(field.getNum());
            String value = null;
            if (null == value) {
                value = this.getValueString(field, subFieldIndex);
            }
            String headerString = mesg.getName() + "." + field.getName(subFieldIndex);
            String units = this.formatUnits(field.getUnits(subFieldIndex), field.getProfileType().name());
            if (!units.isEmpty()) {
                headerString = headerString + "[" + units + "]";
            }
            this.csv.set(headerString, value);
        }
        for (DeveloperField developerField : mesg.getDeveloperFields()) {
            if (!developerField.isDefined() && this.hideUnknownData) continue;
            String value = this.getValueString(developerField, 65535);
            String headerString = mesg.getName() + ".developer." + developerField.getDeveloperDataIndex() + "." + developerField.getName();
            String units = this.formatUnits(developerField.getUnits());
            if (units != null && !units.isEmpty()) {
                headerString = headerString + "[" + units + "]";
            }
            this.csv.set(headerString, value);
        }
        this.csv.writeln();
    }

    public void setMaxNumFields(int numFields) {
        this.csv.setMaxNumberValues(numFields);
    }

    public void clearMesgFields(Mesg mesg) {
        String mesgName = mesg.getName();
        for (String header : this.csv.getHeaders()) {
            String headerName = header.substring(0, header.indexOf("."));
            if (!headerName.equals(mesgName)) continue;
            this.csv.set(header, "");
        }
    }
}

