/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Factory;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import java.util.ArrayList;
import java.util.HashSet;

public class MesgFilter
implements MesgListener,
MesgDefinitionListener,
MesgSource {
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();
    private HashSet<String> mesgDefinitionsToOutput;
    private HashSet<String> mesgDefinitionsToIgnore;
    private HashSet<String> mesgToOutput;
    private HashSet<String> mesgToIgnore;
    private boolean outputMesgDefinitions = true;
    private boolean outputMesg = true;

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void setMesgDefinitionsToOutput(HashSet<String> inputMesgDefinitionsToOutput) {
        if (this.mesgDefinitionsToIgnore != null) {
            throw new UnsupportedOperationException("Setting both an include filter and an exclude filter not supported.");
        }
        this.mesgDefinitionsToOutput = inputMesgDefinitionsToOutput;
        if (this.mesgDefinitionsToOutput.contains("none")) {
            this.outputMesgDefinitions = false;
        }
    }

    public void setMesgDefinitionsToIgnore(HashSet<String> inputMesgDefinitionsToIgnore) {
        if (this.mesgDefinitionsToOutput != null) {
            throw new UnsupportedOperationException("Setting both an include filter and an exclude filter not supported.");
        }
        this.mesgDefinitionsToIgnore = inputMesgDefinitionsToIgnore;
        if (this.mesgDefinitionsToIgnore.contains("none")) {
            this.outputMesgDefinitions = false;
        }
    }

    public void setDataMessagesToOutput(HashSet<String> inputMesgToOutput) {
        this.mesgToOutput = inputMesgToOutput;
        if (this.mesgToOutput.contains("none")) {
            this.outputMesg = false;
        }
    }

    public void setDataMessagesToIgnore(HashSet<String> inputMesgToIgnore) {
        this.mesgToIgnore = inputMesgToIgnore;
        if (this.mesgToIgnore.contains("none")) {
            this.outputMesg = false;
        }
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDef) {
        boolean outputDefinition = true;
        Mesg mesg = Factory.createMesg(mesgDef.getNum());
        if (!this.outputMesgDefinitions) {
            outputDefinition = false;
        } else if (this.mesgDefinitionsToOutput != null && !this.mesgDefinitionsToOutput.isEmpty()) {
            outputDefinition = this.mesgDefinitionsToOutput.contains(mesg.getName());
        } else if (this.mesgDefinitionsToIgnore != null && !this.mesgDefinitionsToIgnore.isEmpty()) {
            outputDefinition = !this.mesgDefinitionsToIgnore.contains(mesg.getName());
        }
        if (outputDefinition) {
            for (MesgDefinitionListener mesgListener : this.mesgDefListeners) {
                mesgListener.onMesgDefinition(mesgDef);
            }
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        boolean outputMessage = true;
        if (!this.outputMesg) {
            outputMessage = false;
        } else if (this.mesgToOutput != null && !this.mesgToOutput.isEmpty()) {
            outputMessage = this.mesgToOutput.contains(mesg.getName());
        } else if (this.mesgToIgnore != null && !this.mesgToIgnore.isEmpty()) {
            outputMessage = !this.mesgToIgnore.contains(mesg.getName());
        }
        if (outputMessage) {
            for (MesgListener mesgListener : this.mesgListeners) {
                mesgListener.onMesg(mesg);
            }
        }
    }
}

