/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.plugins;

import com.garmin.fit.ActivityMesg;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceInfoMesg;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FitListener;
import com.garmin.fit.FitMessages;
import com.garmin.fit.LapMesg;
import com.garmin.fit.Manufacturer;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcastPlugin;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.plugins.ActivityFileValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ActivityFileValidationPlugin
implements MesgBroadcastPlugin {
    private static final int MIN_TIMEZONE_OFFSET_IN_SECONDS = -43200;
    private static final int MAX_TIMEZONE_OFFSET_IN_SECONDS = 50400;
    private final FitListener fitListener = new FitListener();
    private final ArrayList<ActivityFileValidationResult> results = new ArrayList();
    private int mesgCount = 0;

    @Override
    public void onIncomingMesg(Mesg mesg) {
        this.fitListener.onMesg(mesg);
        ++this.mesgCount;
    }

    @Override
    public void onBroadcast(List<Mesg> mesgs) {
        FitMessages fitMessages = this.fitListener.getFitMessages();
        this.results.clear();
        this.results.add(this.checkFileIdMesgExists(fitMessages.getFileIdMesgs()));
        if (fitMessages.getFileIdMesgs().size() > 0) {
            this.results.add(this.checkFileIdMesgIsFirst(mesgs));
            this.results.add(this.checkFileIdMesgType(fitMessages.getFileIdMesgs().get(0)));
            this.results.add(this.checkFileIdMesgManufacturerId(fitMessages.getFileIdMesgs().get(0)));
            this.results.add(this.checkFileIdMesgTimeCreated(fitMessages.getFileIdMesgs().get(0)));
        }
        this.results.add(this.checkActivityMesgExists(fitMessages.getActivityMesgs()));
        if (fitMessages.getActivityMesgs().size() > 0) {
            this.results.add(this.checkActivityMesgTimestamp(fitMessages.getActivityMesgs().get(0)));
            this.results.add(this.checkActivityMesgLocalTimeStamp(fitMessages.getActivityMesgs().get(0)));
            this.results.add(this.checkActivityMesgTotalTimerTime(fitMessages.getActivityMesgs().get(0), fitMessages.getSessionMesgs()));
            this.results.add(this.checkActivityMesgSessionCount(fitMessages.getActivityMesgs().get(0), fitMessages.getSessionMesgs().size()));
        }
        this.results.add(this.checkSessionMesgsExists(fitMessages.getSessionMesgs().size()));
        this.results.add(this.checkSessionMesgTimestamp(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgStartTime(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgTotalTimerTimeAndTotalElapsedTime(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgFirstLapIndexAndNumLapsAreSequentialAndAbut(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgTotalTimerTime(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgTotalElapsedTime(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgSport(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgSubSport(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgsAreSequentialAndAbut(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgValidMesgIndexes(fitMessages.getSessionMesgs()));
        this.results.add(this.checkLapMesgsExists(fitMessages.getLapMesgs().size()));
        this.results.add(this.checkLapMesgValidMesgIndexes(fitMessages.getLapMesgs()));
        this.results.add(this.checkLapMesgValidStartTimeAndEndTime(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkLapMesgsAreSequentialAndAbut(fitMessages.getLapMesgs()));
        this.results.add(this.checkRecordMesgTimestampsAgainstSessionMesgTimes(fitMessages.getSessionMesgs(), fitMessages.getRecordMesgs()));
        this.results.add(this.checkRecordMesgsAreChronological(fitMessages.getRecordMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidTimestamp(fitMessages.getDeviceInfoMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidDeviceIndex(fitMessages.getDeviceInfoMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidManufacturerIdExists(fitMessages.getDeviceInfoMesgs()));
    }

    public void repeatValidation() {
        this.onBroadcast(new ArrayList<Mesg>());
    }

    public int getMesgCount() {
        return this.mesgCount;
    }

    public List<ActivityFileValidationResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    ActivityFileValidationResult checkFileIdMesgExists(List<FileIdMesg> fileIdMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("FileId Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesgs.size() > 0) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return result;
    }

    ActivityFileValidationResult checkFileIdMesgIsFirst(List<Mesg> mesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("FileId Message Is First", ActivityFileValidationResult.Level.REQUIRED);
        for (Mesg mesg : mesgs) {
            if (mesg.getName().equals("pad")) continue;
            if (mesg.getName().equals("file_id")) {
                result.setStatus(ActivityFileValidationResult.Status.PASSED);
                break;
            }
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            break;
        }
        return result;
    }

    ActivityFileValidationResult checkFileIdMesgType(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("FileId Message Type Is Activity", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getType() == File.ACTIVITY) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Expected Type: Activity, actual Type: " + (Object)((Object)fileIdMesg.getType()) + ".");
        }
        return result;
    }

    ActivityFileValidationResult checkFileIdMesgManufacturerId(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("FileId Message Manufacturer Id Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getManufacturer() == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Manufacturer Id is null.");
            return result;
        }
        if (Manufacturer.getStringFromValue(fileIdMesg.getManufacturer()).equals("")) {
            result.setStatus(ActivityFileValidationResult.Status.WARNING);
            result.setDescription("Unknown Manufacturer Id " + fileIdMesg.getManufacturer() + ".");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkFileIdMesgTimeCreated(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("FileId Message Time Created Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getTimeCreated() == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Time Created is null.");
        } else {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        }
        return result;
    }

    ActivityFileValidationResult checkActivityMesgExists(List<ActivityMesg> activityMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Activity Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (activityMesgs.size() > 0) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return result;
    }

    ActivityFileValidationResult checkActivityMesgTimestamp(ActivityMesg activityMesg) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Activity Message Timestamp Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (activityMesg.getTimestamp() == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Timestamp is null.");
        } else {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        }
        return result;
    }

    ActivityFileValidationResult checkActivityMesgLocalTimeStamp(ActivityMesg activityMesg) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Activity Message Local Timestamp is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (activityMesg.getLocalTimestamp() == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Local Timestamp is null.");
            return result;
        }
        Long localTimestamp = activityMesg.getLocalTimestamp();
        Long timestamp = activityMesg.getTimestamp().getTimestamp();
        long timezoneOffset = localTimestamp - timestamp;
        if (timezoneOffset >= -43200L && timezoneOffset <= 50400L) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Local Timestamp is not within the tolerated range of [-12,14] hours.");
        }
        return result;
    }

    ActivityFileValidationResult checkActivityMesgTotalTimerTime(ActivityMesg activityMesg, List<SessionMesg> sessionMesgs) {
        return this.checkValidFieldSums(activityMesg, sessionMesgs, "Activity", "Session", "total_timer_time");
    }

    ActivityFileValidationResult checkActivityMesgSessionCount(ActivityMesg activityMesg, int numSessions) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Activity Message Session Count Is Equal To Actual Session Count", ActivityFileValidationResult.Level.OPTIONAL);
        if (activityMesg.getNumSessions() == null) {
            result.setStatus(ActivityFileValidationResult.Status.WARNING);
            result.setDescription("Num Sessions is null.");
            return result;
        }
        if (activityMesg.getNumSessions() != numSessions) {
            result.setStatus(ActivityFileValidationResult.Status.WARNING);
            result.setDescription("Num Sessions does not match the actual number of Sessions messages found in the file.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgsExists(int sessionMesgsSize) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgsSize > 0) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return result;
    }

    ActivityFileValidationResult checkSessionMesgTimestamp(List<SessionMesg> sessionMesgs) {
        return this.checkMesgValidTimestamp(sessionMesgs, "Session");
    }

    ActivityFileValidationResult checkSessionMesgStartTime(List<SessionMesg> sessionMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Start Time Is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullTimestamp = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTimestamp() == null);
        boolean hasNullStartTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getStartTime() == null);
        boolean hasNullTotalElapsedTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (hasNullTimestamp || hasNullStartTime || hasNullTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null Start Time, Timestamp and/or a null Total Elapsed Time.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgTotalTimerTimeAndTotalElapsedTime(List<SessionMesg> sessionMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Total Timer Time and Total Elapsed Time are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullTimerTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalTimerTime() == null);
        boolean hasNullTotalElapsedTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (hasNullTimerTime || hasNullTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null Start Time and/or a null Timestamp.");
            return result;
        }
        for (SessionMesg sessionMesg2 : sessionMesgs) {
            if (!(sessionMesg2.getTotalElapsedTime().floatValue() < sessionMesg2.getTotalTimerTime().floatValue())) continue;
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Session message Total Timer Time " + sessionMesg2.getTotalTimerTime() + " >  Total Elapsed Time" + sessionMesg2.getTotalElapsedTime() + ".");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgFirstLapIndexAndNumLapsAreSequentialAndAbut(List<SessionMesg> sessionMesgs, List<LapMesg> lapMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message First Lap Index and Num Laps are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0 || lapMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            result.setDescription("No Session messages exist and/or no Lap messages exist.");
            return result;
        }
        boolean hasNullFirstLapIndex = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean hasNullNumLaps = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (hasNullFirstLapIndex || hasNullNumLaps) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return result;
        }
        int expectedFirstLapIndex = 0;
        for (SessionMesg sessionMesg2 : sessionMesgs) {
            if (sessionMesg2.getFirstLapIndex() != expectedFirstLapIndex) {
                result.setStatus(ActivityFileValidationResult.Status.FAILED);
                result.setDescription("One or more Session messages contains an invlaid First Lap Index value.");
                return result;
            }
            expectedFirstLapIndex += sessionMesg2.getNumLaps().intValue();
        }
        if (expectedFirstLapIndex != lapMesgs.size()) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Sum of Session messages Num Laps values is not equal to total number of Lap messages found in the file.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgTotalTimerTime(List<SessionMesg> sessionMesgs, List<LapMesg> lapMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Total Timer Time Is Equal To Sum of Lap Messages Total Timer Time", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0 || lapMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            result.setDescription("No Session messages exist and/or no Lap messages exist.");
            return result;
        }
        boolean hasNullSessionTotalTimerTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalTimerTime() == null);
        if (hasNullSessionTotalTimerTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            return result;
        }
        boolean hasNullFirstLapIndex = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean hasNullNumLaps = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (hasNullFirstLapIndex || hasNullNumLaps) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return result;
        }
        for (SessionMesg session : sessionMesgs) {
            List laps;
            result = this.checkValidFieldSums(session, laps = lapMesgs.stream().skip(session.getFirstLapIndex().intValue()).limit(session.getNumLaps().intValue()).collect(Collectors.toList()), "Session", "Lap", "total_timer_time");
            if (result.getStatus() != ActivityFileValidationResult.Status.FAILED) continue;
            return result;
        }
        return result;
    }

    ActivityFileValidationResult checkSessionMesgTotalElapsedTime(List<SessionMesg> sessionMesgs, List<LapMesg> lapMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Total Elapsed Time Is Equal To Sum of Lap Messages Total Elapsed Time", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0 || lapMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            result.setDescription("No Session messages exist and/or no Lap messages exist.");
            return result;
        }
        boolean hasNullSessionTotalElapsedTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (hasNullSessionTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            return result;
        }
        boolean hasNullFirstLapIndex = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean hasNullNumLaps = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (hasNullFirstLapIndex || hasNullNumLaps) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return result;
        }
        for (SessionMesg session : sessionMesgs) {
            List laps;
            result = this.checkValidFieldSums(session, laps = lapMesgs.stream().skip(session.getFirstLapIndex().intValue()).limit(session.getNumLaps().intValue()).collect(Collectors.toList()), "Session", "Lap", "total_elapsed_time");
            if (result.getStatus() != ActivityFileValidationResult.Status.FAILED) continue;
            return result;
        }
        return result;
    }

    ActivityFileValidationResult checkSessionMesgSport(List<SessionMesg> sessionMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Sport Exists", ActivityFileValidationResult.Level.REQUIRED);
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(sessionMesgs, "sport");
        if (status == ActivityFileValidationResult.Status.FAILED) {
            result.setDescription("One or more Session messages contain a null Sport value.");
        }
        result.setStatus(status);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgSubSport(List<SessionMesg> sessionMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Session Message Sub Sport Exists", ActivityFileValidationResult.Level.OPTIONAL);
        ActivityFileValidationResult.Status status = this.checkSubSportValuesAreValid(sessionMesgs);
        if (status == ActivityFileValidationResult.Status.WARNING) {
            result.setDescription("One or more Session messages contain a null Sub Sport value. Set Sub Sport value to 'generic' if unknown.");
        }
        result.setStatus(status);
        return result;
    }

    ActivityFileValidationResult checkSessionMesgsAreSequentialAndAbut(List<SessionMesg> sessionMesgs) {
        return this.checkMesgsAreSequentialAndAbut(sessionMesgs, "Session");
    }

    ActivityFileValidationResult checkSessionMesgValidMesgIndexes(List<SessionMesg> sessionMesgs) {
        return this.checkValidMesgIndexes(sessionMesgs, "Session");
    }

    ActivityFileValidationResult checkLapMesgValidMesgIndexes(List<LapMesg> lapMesgs) {
        return this.checkValidMesgIndexes(lapMesgs, "Lap");
    }

    ActivityFileValidationResult checkLapMesgsExists(int lapMesgsSize) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Lap Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (lapMesgsSize > 0) {
            result.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return result;
    }

    ActivityFileValidationResult checkLapMesgValidStartTimeAndEndTime(List<SessionMesg> sessionMesgs, List<LapMesg> lapMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Lap Message Start Time and Timestamp are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0 || lapMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullStartTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getStartTime() == null);
        boolean hasNullTimestamp = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTimestamp() == null);
        boolean hasNullTotalElapsedTime = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (hasNullStartTime || hasNullTimestamp || hasNullTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null Start Time, Timestamp and/or null Total Elapsed Time.");
            return result;
        }
        boolean hasNullFirstLapIndex = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean hasNullNumLaps = sessionMesgs.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (hasNullFirstLapIndex || hasNullNumLaps) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session messages contain a null First Lap Index value and/or a null Num Lap value.");
            return result;
        }
        boolean hasNullLapMesgStartTime = lapMesgs.stream().anyMatch(lapMesg -> lapMesg.getStartTime() == null);
        boolean hasNullLapMesgTimeStamp = lapMesgs.stream().anyMatch(lapMesg -> lapMesg.getTimestamp() == null);
        boolean hasNullLapMesTotalElapsedTime = lapMesgs.stream().anyMatch(lapMesg -> lapMesg.getTotalElapsedTime() == null);
        if (hasNullLapMesgStartTime || hasNullLapMesgTimeStamp || hasNullLapMesTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Lap messages contain a null Start Time, Total Elapsed Time and/or a null Timestamp.");
            return result;
        }
        for (SessionMesg session : sessionMesgs) {
            List laps = lapMesgs.stream().skip(session.getFirstLapIndex().intValue()).limit(session.getNumLaps().intValue()).collect(Collectors.toList());
            for (LapMesg lap : laps) {
                boolean isEndTimeAfter;
                boolean isStartTimeBefore = lap.getStartTime().before(session.getStartTime());
                boolean bl = isEndTimeAfter = this.calculateEndTime(lap) - this.calculateEndTime(session) > 1L;
                if (!isStartTimeBefore && !isEndTimeAfter) continue;
                result.setStatus(ActivityFileValidationResult.Status.FAILED);
                result.setDescription("One or more Lap messages contain an incorrect Start Time and/or an incorrect 'End Time' relative to the Session message.");
                return result;
            }
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkLapMesgsAreSequentialAndAbut(List<LapMesg> lapMesgs) {
        return this.checkMesgsAreSequentialAndAbut(lapMesgs, "Lap");
    }

    ActivityFileValidationResult checkRecordMesgTimestampsAgainstSessionMesgTimes(List<SessionMesg> sessionMesgs, List<RecordMesg> recordMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Record Message Timestamps Fall Within Session Message Times", ActivityFileValidationResult.Level.REQUIRED);
        if (sessionMesgs.size() == 0 || recordMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        DateTime firstSessionMesgStartTime = sessionMesgs.get(0).getStartTime();
        Long lastSessionMesgEndTime = this.calculateEndTime(sessionMesgs.get(sessionMesgs.size() - 1));
        if (firstSessionMesgStartTime == null || lastSessionMesgEndTime == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Session Messages contain a null Start Time and/or a null 'End Time'.");
            return result;
        }
        DateTime firstRecordMesgTimestamp = recordMesgs.get(0).getTimestamp();
        DateTime lastRecordMesgTimestamp = recordMesgs.get(recordMesgs.size() - 1).getTimestamp();
        if (firstRecordMesgTimestamp == null || lastRecordMesgTimestamp == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Record messages contain a null Timestamp.");
            return result;
        }
        if (firstRecordMesgTimestamp.getTimestamp() - firstSessionMesgStartTime.getTimestamp() < -1L) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Record message Timestamps is earlier than Session Start Time.");
            return result;
        }
        if (lastRecordMesgTimestamp.getTimestamp() - lastSessionMesgEndTime > 1L) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Record message Timestamps is later than Session 'End Time'.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkRecordMesgsAreChronological(List<RecordMesg> recordMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Record Messages Are in Chronological Ascending Order", ActivityFileValidationResult.Level.REQUIRED);
        if (recordMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullTimestamp = recordMesgs.stream().anyMatch(recordMesg -> recordMesg.getTimestamp() == null);
        if (hasNullTimestamp) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Record messages contain a null Timestamp.");
            return result;
        }
        DateTime previousTimestamp = recordMesgs.get(0).getTimestamp();
        for (RecordMesg recordMesg2 : recordMesgs) {
            if (previousTimestamp.after(recordMesg2.getTimestamp())) {
                result.setStatus(ActivityFileValidationResult.Status.FAILED);
                result.setDescription("One or more Record messages are not sequential.");
                return result;
            }
            previousTimestamp = recordMesg2.getTimestamp();
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidTimestamp(List<DeviceInfoMesg> deviceInfoMesgs) {
        return this.checkMesgValidTimestamp(deviceInfoMesgs, "Device Info");
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidDeviceIndex(List<DeviceInfoMesg> deviceInfoMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Device Info Message Device Index is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (deviceInfoMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullDeviceIndex = deviceInfoMesgs.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getDeviceIndex() == null);
        if (hasNullDeviceIndex) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more Device Info messages contain a null Device Index value.");
            return result;
        }
        boolean hasCreator = deviceInfoMesgs.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getDeviceIndex().equals((short)0));
        if (!hasCreator) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("At least one Device Info message Device Index field needs to be set to Creator.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidManufacturerIdExists(List<DeviceInfoMesg> deviceInfoMesgs) {
        ActivityFileValidationResult result = new ActivityFileValidationResult("Device Info Message Manufacturer Id is Valid", ActivityFileValidationResult.Level.OPTIONAL);
        if (deviceInfoMesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullManufacturer = deviceInfoMesgs.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getManufacturer() == null);
        if (hasNullManufacturer) {
            result.setStatus(ActivityFileValidationResult.Status.WARNING);
            result.setDescription("One or more Device Info messages contain a null Manufacturer Id.");
            return result;
        }
        boolean hasInvalidManufacturer = deviceInfoMesgs.stream().anyMatch(deviceInfoMesg -> Manufacturer.getStringFromValue(deviceInfoMesg.getManufacturer()).equals(""));
        if (hasInvalidManufacturer) {
            result.setStatus(ActivityFileValidationResult.Status.WARNING);
            result.setDescription("One or more Device Info messages contain an unknown Manufacturer Id.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    @SafeVarargs
    final boolean isEmpty(List<? extends Mesg> ... lists) {
        return Arrays.stream(lists).anyMatch(l -> l.size() == 0);
    }

    ActivityFileValidationResult checkValidMesgIndexes(List<? extends Mesg> mesgs, String mesgName) {
        ActivityFileValidationResult result = new ActivityFileValidationResult(mesgName + " Message Valid Message Index", ActivityFileValidationResult.Level.REQUIRED);
        if (mesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        for (int i = 0; i < mesgs.size(); ++i) {
            Integer messageIndex = mesgs.get(i).getFieldIntegerValue(254, 0, 65535);
            if (messageIndex == null) {
                result.setStatus(ActivityFileValidationResult.Status.FAILED);
                result.setDescription("One or more " + mesgName + " messages contain a null Message Index value.");
                return result;
            }
            if (messageIndex == i) continue;
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("Message Indexes are not sequential.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkMesgValidTimestamp(List<? extends Mesg> mesgs, String name) {
        ActivityFileValidationResult result = new ActivityFileValidationResult(name + " Message Timestamps are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (mesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        boolean hasNullTimestamp = mesgs.stream().anyMatch(mesg -> mesg.getFieldLongValue("timestamp") == null);
        if (hasNullTimestamp) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more " + name + " messages contain a null Timestamp.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkValidFieldSums(Mesg mesg, List<? extends Mesg> mesgs, String mesgName, String mesgListName, String fieldName) {
        ActivityFileValidationResult result = new ActivityFileValidationResult(mesgName + " Message " + fieldName + " is Equal to the Sum of " + mesgListName + " Messages " + fieldName + " Values", ActivityFileValidationResult.Level.REQUIRED);
        if (mesgs.size() == 0) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return result;
        }
        if (mesg.getFieldFloatValue(fieldName) == null) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription(mesgName + " Message contains a null " + fieldName);
            return result;
        }
        boolean hasNullValue = mesgs.stream().anyMatch(m -> m.getFieldFloatValue(fieldName) == null);
        if (hasNullValue) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription(mesgListName + "Message contains a null " + fieldName + " value.");
            return result;
        }
        double sumOfFieldValues = mesgs.stream().mapToDouble(mesgList -> mesgList.getFieldFloatValue(fieldName).floatValue()).sum();
        if (Math.abs((double)mesg.getFieldFloatValue(fieldName).floatValue() - sumOfFieldValues) > 1.0) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription(mesgName + " message " + fieldName + " does not equal the sum of " + mesgListName + " messages " + fieldName + " values.");
            return result;
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    ActivityFileValidationResult checkMesgsAreSequentialAndAbut(List<? extends Mesg> mesgs, String mesgName) {
        ActivityFileValidationResult result = new ActivityFileValidationResult(mesgName + " Message Are Sequential and Abut", ActivityFileValidationResult.Level.REQUIRED);
        if (mesgs.size() <= 1) {
            result.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            result.setDescription("Check requires two or more " + mesgName + " messages, found " + mesgs.size() + ".");
            return result;
        }
        boolean hasNullStartTime = mesgs.stream().anyMatch(mesg -> mesg.getFieldLongValue("start_time") == null);
        boolean hasNullTotalElapsedTime = mesgs.stream().anyMatch(mesg -> mesg.getFieldLongValue("total_elapsed_time") == null);
        if (hasNullStartTime || hasNullTotalElapsedTime) {
            result.setStatus(ActivityFileValidationResult.Status.FAILED);
            result.setDescription("One or more " + mesgName + " messages contain a null Start Time and/or a null Total Elapsed Time.");
            return result;
        }
        long previousEndTime = this.calculateEndTime(mesgs.get(0));
        for (Mesg mesg2 : mesgs.subList(1, mesgs.size())) {
            long startTime = mesg2.getFieldLongValue("start_time");
            if (Math.abs(startTime - previousEndTime) > 2L) {
                result.setStatus(ActivityFileValidationResult.Status.FAILED);
                result.setDescription(mesgName + " messages are not sequential, or do not abut.");
                return result;
            }
            previousEndTime = this.calculateEndTime(mesg2);
        }
        result.setStatus(ActivityFileValidationResult.Status.PASSED);
        return result;
    }

    boolean anyMatchNull(List<? extends Mesg> mesgs, String fieldName) {
        return mesgs.stream().anyMatch(mesg -> mesg.getFieldValue(fieldName) == null);
    }

    boolean allMatchNull(List<? extends Mesg> mesgs, String fieldName) {
        return mesgs.stream().allMatch(mesg -> mesg.getFieldValue(fieldName) == null);
    }

    ActivityFileValidationResult.Status checkFieldValuesAreValid(List<? extends Mesg> mesgs, String fieldName) {
        if (mesgs.size() == 0) {
            return ActivityFileValidationResult.Status.SKIPPED;
        }
        return this.anyMatchNull(mesgs, fieldName) ? ActivityFileValidationResult.Status.FAILED : ActivityFileValidationResult.Status.PASSED;
    }

    ActivityFileValidationResult.Status checkSportValuesAreValid(List<? extends Mesg> mesgs) {
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(mesgs, "sport");
        return status == ActivityFileValidationResult.Status.FAILED ? ActivityFileValidationResult.Status.WARNING : status;
    }

    ActivityFileValidationResult.Status checkSubSportValuesAreValid(List<? extends Mesg> mesgs) {
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(mesgs, "sub_sport");
        return status == ActivityFileValidationResult.Status.FAILED ? ActivityFileValidationResult.Status.WARNING : status;
    }

    Long calculateEndTime(Mesg mesg) {
        long totalElapsedTime;
        long startTime;
        try {
            startTime = mesg.getFieldLongValue("start_time");
            totalElapsedTime = mesg.getFieldLongValue("total_elapsed_time");
        }
        catch (NullPointerException e) {
            return null;
        }
        return startTime + totalElapsedTime;
    }
}

