/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.plugins;

import com.garmin.fit.DateTime;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.HrMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcastPlugin;
import com.garmin.fit.RecordMesg;
import java.util.ArrayList;
import java.util.List;

public class HrToRecordMesgBroadcastPlugin
implements MesgBroadcastPlugin {
    private final HeartRateList heartrates = new HeartRateList();
    private boolean isActivityFile = false;

    @Override
    public void onIncomingMesg(Mesg mesg) {
        switch (mesg.getNum()) {
            case 0: {
                FileIdMesg fileIdMesg = new FileIdMesg(mesg);
                if (fileIdMesg.getType() != File.ACTIVITY) break;
                this.isActivityFile = true;
                break;
            }
            case 132: {
                this.heartrates.addHrMesssage(new HrMesg(mesg));
                break;
            }
        }
    }

    @Override
    public void onBroadcast(List<Mesg> mesgs) {
        if (this.isActivityFile && this.heartrates.size() > 0) {
            int heartrateIndex = 0;
            DateTime recordRangeStartTime = null;
            block0: for (int mesgCounter = 0; mesgCounter < mesgs.size(); ++mesgCounter) {
                Mesg mesg = mesgs.get(mesgCounter);
                if (mesg.getNum() != 20) continue;
                long hrSum = 0L;
                long hrSumCount = 0L;
                RecordMesg recordMesg = new RecordMesg(mesg);
                DateTime recordRangeEndTime = new DateTime(recordMesg.getTimestamp());
                if (recordRangeStartTime == null) {
                    recordRangeStartTime = new DateTime(recordMesg.getTimestamp().getTimestamp());
                }
                if (recordRangeStartTime.compareTo(recordRangeEndTime) == 0) {
                    recordRangeStartTime.add(-1L);
                    heartrateIndex = heartrateIndex >= 1 ? heartrateIndex - 1 : 0;
                }
                boolean findingInRangeHrMesgs = true;
                while (findingInRangeHrMesgs && heartrateIndex < this.heartrates.size()) {
                    HeartRate heartrate = (HeartRate)this.heartrates.get(heartrateIndex);
                    if (heartrate.timestamp.compareTo(recordRangeStartTime) > 0 && heartrate.timestamp.compareTo(recordRangeEndTime) <= 0) {
                        hrSum += (long)heartrate.value;
                        ++hrSumCount;
                    } else if (heartrate.timestamp.compareTo(recordRangeEndTime) > 0) {
                        findingInRangeHrMesgs = false;
                        if (hrSumCount > 0L) {
                            short avgHR = (short)Math.round((float)hrSum / (float)hrSumCount);
                            recordMesg.setHeartRate(avgHR);
                            mesgs.set(mesgCounter, recordMesg);
                        }
                        hrSum = 0L;
                        hrSumCount = 0L;
                        recordRangeStartTime = new DateTime(recordRangeEndTime);
                        continue block0;
                    }
                    ++heartrateIndex;
                }
            }
        }
    }

    private class HeartRateList
    extends ArrayList<HeartRate> {
        private final long GAP_INCREMENT_MILLISECONDS = 250L;
        private final float GAP_INCREMENT_SECONDS = 0.25f;
        private final long GAP_MAX_MILLISECONDS = 5000L;
        private final long GAP_MAX_STEPS = 20L;
        private Float anchorEventTimestamp = Float.valueOf(0.0f);
        private DateTime anchorTimestamp = null;

        HeartRateList() {
        }

        public void addHrMesssage(HrMesg hrMesg) {
            if (hrMesg == null) {
                throw new FitRuntimeException("FIT HrToRecordMesgBroadcastPlugin Error: HR mesg must not be null");
            }
            if (hrMesg.getTimestamp() != null) {
                this.anchorTimestamp = new DateTime(hrMesg.getTimestamp());
                if (hrMesg.getFractionalTimestamp() != null) {
                    this.anchorTimestamp.add(hrMesg.getFractionalTimestamp().floatValue());
                }
                if (hrMesg.getNumEventTimestamp() == 1) {
                    this.anchorEventTimestamp = hrMesg.getEventTimestamp(0);
                } else {
                    throw new FitRuntimeException("FIT HrToRecordMesgBroadcastPlugin Error: Anchor HR mesg must have 1 event_timestamp");
                }
            }
            if (this.anchorTimestamp == null) {
                throw new FitRuntimeException("FIT HrToRecordMesgBroadcastPlugin Error: No anchor timestamp received in a HR mesg before diff HR mesgs");
            }
            if (hrMesg.getNumEventTimestamp() != hrMesg.getNumFilteredBpm()) {
                throw new FitRuntimeException("FIT HrToRecordMesgBroadcastPlugin Error: HR mesg with mismatching event timestamp and filtered bpm");
            }
            for (int i = 0; i < hrMesg.getNumEventTimestamp(); ++i) {
                Float eventTimestamp = hrMesg.getEventTimestamp(i);
                if (eventTimestamp.floatValue() < this.anchorEventTimestamp.floatValue()) {
                    if (this.anchorEventTimestamp.floatValue() - eventTimestamp.floatValue() > 2097152.0f) {
                        eventTimestamp = Float.valueOf(eventTimestamp.floatValue() + 4194304.0f);
                    } else {
                        throw new FitRuntimeException("FIT HrToRecordMesgBroadcastPlugin Error: Anchor event_timestamp is greater than subsequent event_timestamp. This does not allow for correct delta calculation.");
                    }
                }
                HeartRate currentHr = new HeartRate(this.anchorTimestamp, hrMesg.getFilteredBpm(i));
                currentHr.timestamp.add(eventTimestamp.floatValue() - this.anchorEventTimestamp.floatValue());
                if (!this.isEmpty()) {
                    HeartRate previousHR = (HeartRate)this.get(this.size() - 1);
                    long gapInMilliseconds = Math.abs(currentHr.timestamp.getDate().getTime() - previousHR.timestamp.getDate().getTime());
                    for (long step = 1L; gapInMilliseconds > 250L && step <= 20L; gapInMilliseconds -= 250L, ++step) {
                        HeartRate gapHR = new HeartRate(previousHR);
                        gapHR.timestamp.add(0.25f * (float)step);
                        this.add(gapHR);
                    }
                }
                this.add(currentHr);
            }
        }
    }

    private static class HeartRate {
        public DateTime timestamp;
        public short value;

        HeartRate(HeartRate other) {
            this.timestamp = new DateTime(other.timestamp);
            this.value = other.value;
        }

        HeartRate(DateTime dateTime, short value) {
            this.timestamp = new DateTime(dateTime);
            this.value = value;
        }
    }
}

