/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.plugins;

import com.garmin.fit.AccelerometerDataMesg;
import com.garmin.fit.Factory;
import com.garmin.fit.GyroscopeDataMesg;
import com.garmin.fit.MagnetometerDataMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcastPlugin;
import com.garmin.fit.ThreeDSensorCalibrationMesg;
import java.util.List;

public class ThreeDSensorAdjustmentPlugin
implements MesgBroadcastPlugin {
    private final int X_AXIS_OFFSET = 0;
    private final int Y_AXIS_OFFSET = 1;
    private final int Z_AXIS_OFFSET = 2;
    private final int NUM_AXIS = 3;
    boolean haveGyroCal = false;
    boolean haveAccelCal = false;
    boolean haveMagCal = false;
    CalibrationParameters gyroCalParams = new CalibrationParameters();
    CalibrationParameters accelCalParams = new CalibrationParameters();
    CalibrationParameters magCalParams = new CalibrationParameters();

    @Override
    public void onIncomingMesg(Mesg mesg) {
        block0 : switch (mesg.getNum()) {
            case 167: {
                ThreeDSensorCalibrationMesg calMesg = new ThreeDSensorCalibrationMesg(mesg);
                switch (calMesg.getSensorType()) {
                    case ACCELEROMETER: {
                        this.accelCalParams.LoadParams(calMesg);
                        this.haveAccelCal = true;
                        break block0;
                    }
                    case GYROSCOPE: {
                        this.gyroCalParams.LoadParams(calMesg);
                        this.haveGyroCal = true;
                        break block0;
                    }
                    case COMPASS: {
                        this.magCalParams.LoadParams(calMesg);
                        this.haveMagCal = true;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onBroadcast(List<Mesg> mesgs) {
        int[] rawXYZ = new int[3];
        block5: for (Mesg mesg : mesgs) {
            switch (mesg.getNum()) {
                case 165: {
                    float[] calibratedXYZ;
                    int i;
                    if (!this.haveAccelCal) break;
                    AccelerometerDataMesg accelData = new AccelerometerDataMesg(mesg);
                    int count = accelData.getNumAccelX();
                    for (i = 0; i < count; ++i) {
                        rawXYZ[0] = accelData.getAccelX(i);
                        rawXYZ[1] = accelData.getAccelY(i);
                        rawXYZ[2] = accelData.getAccelZ(i);
                        calibratedXYZ = this.adjustSensorData(rawXYZ, this.accelCalParams);
                        this.processCalibrationFactor(mesg, new String[]{"calibrated_accel_x", "calibrated_accel_y", "calibrated_accel_z"}, calibratedXYZ, "accelerometer_data");
                    }
                    continue block5;
                }
                case 164: {
                    float[] calibratedXYZ;
                    int i;
                    if (!this.haveGyroCal) break;
                    GyroscopeDataMesg gyroData = new GyroscopeDataMesg(mesg);
                    int count = gyroData.getNumGyroX();
                    for (i = 0; i < count; ++i) {
                        rawXYZ[0] = gyroData.getGyroX(i);
                        rawXYZ[1] = gyroData.getGyroY(i);
                        rawXYZ[2] = gyroData.getGyroZ(i);
                        calibratedXYZ = this.adjustSensorData(rawXYZ, this.gyroCalParams);
                        this.processCalibrationFactor(mesg, new String[]{"calibrated_gyro_x", "calibrated_gyro_y", "calibrated_gyro_z"}, calibratedXYZ, "gyroscope_data");
                    }
                    continue block5;
                }
                case 208: {
                    float[] calibratedXYZ;
                    int i;
                    if (!this.haveMagCal) break;
                    MagnetometerDataMesg magData = new MagnetometerDataMesg(mesg);
                    int count = magData.getNumMagX();
                    for (i = 0; i < count; ++i) {
                        rawXYZ[0] = magData.getMagX(i);
                        rawXYZ[1] = magData.getMagY(i);
                        rawXYZ[2] = magData.getMagZ(i);
                        calibratedXYZ = this.adjustSensorData(rawXYZ, this.magCalParams);
                        this.processCalibrationFactor(mesg, new String[]{"calibrated_mag_x", "calibrated_mag_y", "calibrated_mag_z"}, calibratedXYZ, "magnetometer_data");
                    }
                    continue block5;
                }
            }
        }
    }

    private void processCalibrationFactor(Mesg mesg, String[] fieldsXYZ, float[] calibratedXYZ, String mesgName) {
        if (fieldsXYZ.length != 3 || calibratedXYZ.length != 3) {
            return;
        }
        if (mesg.getField(fieldsXYZ[0]) == null) {
            mesg.addField(Factory.createField(mesgName, fieldsXYZ[0]));
        }
        if (mesg.getField(fieldsXYZ[1]) == null) {
            mesg.addField(Factory.createField(mesgName, fieldsXYZ[1]));
        }
        if (mesg.getField(fieldsXYZ[2]) == null) {
            mesg.addField(Factory.createField(mesgName, fieldsXYZ[2]));
        }
        mesg.getField(fieldsXYZ[0]).addValue(Float.valueOf(calibratedXYZ[0]));
        mesg.getField(fieldsXYZ[1]).addValue(Float.valueOf(calibratedXYZ[1]));
        mesg.getField(fieldsXYZ[2]).addValue(Float.valueOf(calibratedXYZ[2]));
    }

    private float[] adjustSensorData(int[] rawData, CalibrationParameters calParams) {
        float[] calibratedValues = new float[rawData.length];
        float[] rotatedValues = new float[rawData.length];
        int i = 0;
        while (i < rawData.length) {
            calibratedValues[i] = rawData[i];
            int n = i;
            calibratedValues[n] = calibratedValues[n] - (float)calParams.levelShift;
            int n2 = i;
            calibratedValues[n2] = calibratedValues[n2] - (float)calParams.channelOffset[i];
            int n3 = i;
            calibratedValues[n3] = calibratedValues[n3] * (float)calParams.calFactor;
            int n4 = i++;
            calibratedValues[n4] = calibratedValues[n4] / (float)calParams.calDivisor;
        }
        rotatedValues[0] = calParams.rotationMatrix[0][0] * calibratedValues[0] + calParams.rotationMatrix[0][1] * calibratedValues[1] + calParams.rotationMatrix[0][2] * calibratedValues[2];
        rotatedValues[1] = calParams.rotationMatrix[1][0] * calibratedValues[0] + calParams.rotationMatrix[1][1] * calibratedValues[1] + calParams.rotationMatrix[1][2] * calibratedValues[2];
        rotatedValues[2] = calParams.rotationMatrix[2][0] * calibratedValues[0] + calParams.rotationMatrix[2][1] * calibratedValues[1] + calParams.rotationMatrix[2][2] * calibratedValues[2];
        return rotatedValues;
    }

    private class CalibrationParameters {
        long calFactor;
        long calDivisor;
        long[] channelOffset = new long[3];
        long levelShift;
        float[][] rotationMatrix = new float[3][3];

        private CalibrationParameters() {
        }

        public void LoadParams(ThreeDSensorCalibrationMesg calMesg) {
            this.calFactor = calMesg.getCalibrationFactor();
            this.calDivisor = calMesg.getCalibrationDivisor();
            this.levelShift = calMesg.getLevelShift();
            this.channelOffset[0] = calMesg.getOffsetCal(0).intValue();
            this.channelOffset[1] = calMesg.getOffsetCal(1).intValue();
            this.channelOffset[2] = calMesg.getOffsetCal(2).intValue();
            this.rotationMatrix[0][0] = calMesg.getOrientationMatrix(0).floatValue();
            this.rotationMatrix[0][1] = calMesg.getOrientationMatrix(1).floatValue();
            this.rotationMatrix[0][2] = calMesg.getOrientationMatrix(2).floatValue();
            this.rotationMatrix[1][0] = calMesg.getOrientationMatrix(3).floatValue();
            this.rotationMatrix[1][1] = calMesg.getOrientationMatrix(4).floatValue();
            this.rotationMatrix[1][2] = calMesg.getOrientationMatrix(5).floatValue();
            this.rotationMatrix[2][0] = calMesg.getOrientationMatrix(6).floatValue();
            this.rotationMatrix[2][1] = calMesg.getOrientationMatrix(7).floatValue();
            this.rotationMatrix[2][2] = calMesg.getOrientationMatrix(8).floatValue();
        }
    }
}

