/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.repair;

import com.garmin.fit.ActivityMesg;
import com.garmin.fit.BufferedMesgListener;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceInfoMesg;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FitListener;
import com.garmin.fit.FitMessages;
import com.garmin.fit.LapMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.Sport;
import com.garmin.fit.SportMesg;
import com.garmin.fit.SubSport;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class ActivityRepairFilter
implements BufferedMesgListener,
MesgSource {
    private final FitListener fitListener = new FitListener();
    private final ArrayList<MesgListener> mesgListeners = new ArrayList();
    private final ArrayList<Mesg> filteredRecordMesgs = new ArrayList();
    private long serialNumber = 123456789L;
    private RecordMesg previousMesg = null;
    private boolean continueFilteringRecordMesgs = true;
    private boolean continueCheckingForFileIdMesg = true;
    private FileIdMesg fileIdMesgFromFile = null;

    @Override
    public void onMesg(Mesg mesg) {
        mesg.removeExpandedFields();
        this.fitListener.onMesg(mesg);
        if (mesg.getNum() == 20) {
            this.filterIncomingRecordMessages();
        }
        this.checkForFileIdMesg(mesg);
    }

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public boolean canRepairFile() {
        return this.filteredRecordMesgs.size() != 0;
    }

    @Override
    public void flushMesgs() {
        if (this.filteredRecordMesgs.size() == 0) {
            return;
        }
        FitMessages fitMessages = this.fitListener.getFitMessages();
        RecordMesg start = (RecordMesg)this.filteredRecordMesgs.get(0);
        RecordMesg end = (RecordMesg)this.filteredRecordMesgs.get(this.filteredRecordMesgs.size() - 1);
        DateTime startTime = start.getTimestamp();
        FileIdMesg fileIdMesg = this.createFileIdMesg(startTime);
        DeviceInfoMesg deviceInfoMesg = this.createDeviceIdMesg(fitMessages.getDeviceInfoMesgs(), startTime);
        LapMesg lapMesg = this.createLapMesg(start, end);
        SessionMesg sessionMesg = this.createSessionMesg(start, end, fitMessages);
        ActivityMesg activityMesg = this.createActivityMesg(start, end);
        this.flushMesg(fileIdMesg);
        this.flushMesg(deviceInfoMesg);
        this.flushMesgs(fitMessages.getDeveloperDataIdMesgs());
        this.flushMesgs(fitMessages.getFieldDescriptionMesgs());
        this.flushMesgs(this.filteredRecordMesgs);
        this.flushMesg(lapMesg);
        this.flushMesg(sessionMesg);
        this.flushMesg(activityMesg);
    }

    private void checkForFileIdMesg(Mesg mesg) {
        if (!this.continueCheckingForFileIdMesg) {
            return;
        }
        if (mesg.getNum() == 105) {
            return;
        }
        if (mesg.getNum() == 0) {
            this.fileIdMesgFromFile = new FileIdMesg(mesg);
        }
        this.continueCheckingForFileIdMesg = false;
    }

    private void filterIncomingRecordMessages() {
        if (!this.continueFilteringRecordMesgs) {
            return;
        }
        List<RecordMesg> recordMesgs = this.fitListener.getFitMessages().getRecordMesgs();
        RecordMesg currentMesg = recordMesgs.get(recordMesgs.size() - 1);
        if (!this.hasValidTimestamp(currentMesg)) {
            return;
        }
        if (this.filteredRecordMesgs.size() == 0) {
            this.filteredRecordMesgs.add(currentMesg);
            this.previousMesg = currentMesg;
            return;
        }
        if (!this.isSequential(this.previousMesg, currentMesg)) {
            return;
        }
        if (!this.isReasonableSpan(this.previousMesg, currentMesg)) {
            this.continueFilteringRecordMesgs = false;
            return;
        }
        this.filteredRecordMesgs.add(currentMesg);
        this.previousMesg = currentMesg;
    }

    private FileIdMesg createFileIdMesg(DateTime timeCreated) {
        FileIdMesg fileIdMesg = this.fileIdMesgFromFile;
        if (fileIdMesg == null) {
            fileIdMesg = new FileIdMesg();
            fileIdMesg.setType(File.ACTIVITY);
            fileIdMesg.setProduct(0);
            fileIdMesg.setSerialNumber(this.serialNumber);
        }
        if (fileIdMesg.getManufacturer() == null) {
            fileIdMesg.setManufacturer(255);
        }
        if (fileIdMesg.getTimeCreated() == null) {
            fileIdMesg.setTimeCreated(new DateTime(timeCreated));
        }
        return fileIdMesg;
    }

    private DeviceInfoMesg createDeviceIdMesg(List<DeviceInfoMesg> deviceInfoMesgs, DateTime startTime) {
        DeviceInfoMesg deviceInfoMesg = deviceInfoMesgs.stream().filter(mesg -> mesg.getDeviceIndex() != null).filter(mesg -> mesg.getDeviceIndex() == 0).findFirst().orElse(null);
        if (deviceInfoMesg == null) {
            deviceInfoMesg = new DeviceInfoMesg();
            deviceInfoMesg.setDeviceIndex((short)0);
            deviceInfoMesg.setManufacturer(255);
            deviceInfoMesg.setProduct(0);
            deviceInfoMesg.setProductName("File Activity Repair");
            deviceInfoMesg.setSerialNumber(this.serialNumber);
            deviceInfoMesg.setSoftwareVersion(Float.valueOf(1.0f));
            deviceInfoMesg.setTimestamp(new DateTime(startTime));
        }
        if (deviceInfoMesg.getTimestamp() == null) {
            deviceInfoMesg.setTimestamp(new DateTime(startTime));
        }
        return deviceInfoMesg;
    }

    private LapMesg createLapMesg(RecordMesg start, RecordMesg end) {
        LapMesg lapMesg = new LapMesg();
        lapMesg.setMessageIndex(0);
        lapMesg.setStartTime(start.getTimestamp());
        lapMesg.setTimestamp(end.getTimestamp());
        lapMesg.setTotalElapsedTime(Float.valueOf(end.getTimestamp().getTimestamp() - start.getTimestamp().getTimestamp()));
        lapMesg.setTotalTimerTime(Float.valueOf(end.getTimestamp().getTimestamp() - start.getTimestamp().getTimestamp()));
        if (end.getDistance() != null) {
            lapMesg.setTotalDistance(end.getDistance());
        }
        return lapMesg;
    }

    SessionMesg createSessionMesg(RecordMesg start, RecordMesg end, FitMessages fitMessages) {
        SessionMesg sessionMesg = new SessionMesg();
        sessionMesg.setMessageIndex(0);
        sessionMesg.setStartTime(start.getTimestamp());
        sessionMesg.setTimestamp(end.getTimestamp());
        sessionMesg.setTotalElapsedTime(Float.valueOf(end.getTimestamp().getTimestamp() - start.getTimestamp().getTimestamp()));
        sessionMesg.setTotalTimerTime(Float.valueOf(end.getTimestamp().getTimestamp() - start.getTimestamp().getTimestamp()));
        sessionMesg.setFirstLapIndex(0);
        sessionMesg.setNumLaps(1);
        SportMesg sportMesg = fitMessages.getSportMesgs().stream().filter(mesg -> mesg.getSport() != null).filter(mesg -> mesg.getSubSport() != null).findFirst().orElse(null);
        if (sportMesg != null) {
            sessionMesg.setSport(sportMesg.getSport());
            sessionMesg.setSubSport(sportMesg.getSubSport());
            return sessionMesg;
        }
        LapMesg lapMesg = fitMessages.getLapMesgs().stream().filter(mesg -> mesg.getSport() != null).filter(mesg -> mesg.getSubSport() != null).findFirst().orElse(null);
        if (lapMesg != null) {
            sessionMesg.setSport(lapMesg.getSport());
            sessionMesg.setSubSport(lapMesg.getSubSport());
            return sessionMesg;
        }
        sessionMesg.setSport(Sport.GENERIC);
        sessionMesg.setSubSport(SubSport.GENERIC);
        return sessionMesg;
    }

    private ActivityMesg createActivityMesg(RecordMesg start, RecordMesg end) {
        ActivityMesg activityMesg = new ActivityMesg();
        activityMesg.setTimestamp(end.getTimestamp());
        activityMesg.setNumSessions(1);
        int timezoneOffset = ZonedDateTime.now().getOffset().getTotalSeconds();
        activityMesg.setLocalTimestamp(end.getTimestamp().getTimestamp() + (long)timezoneOffset);
        activityMesg.setTotalTimerTime(Float.valueOf(end.getTimestamp().getTimestamp() - start.getTimestamp().getTimestamp()));
        return activityMesg;
    }

    private boolean hasValidTimestamp(Mesg mesg) {
        Long timestamp = mesg.getFieldLongValue(253);
        return timestamp != null && timestamp >= 0x10000000L;
    }

    private boolean isSequential(RecordMesg previousRecordMesg, RecordMesg recordMesg) {
        return previousRecordMesg.getTimestamp().getTimestamp() <= recordMesg.getTimestamp().getTimestamp();
    }

    private boolean isReasonableSpan(RecordMesg previousRecordMesg, RecordMesg recordMesg) {
        int TWO_DAYS_IN_SECONDS = 172800;
        return recordMesg.getTimestamp().getTimestamp() < previousRecordMesg.getTimestamp().getTimestamp() + 172800L;
    }

    private void flushMesg(Mesg mesg) {
        this.mesgListeners.forEach(mesgListener -> mesgListener.onMesg(mesg));
    }

    private void flushMesgs(List<? extends Mesg> mesgs) {
        mesgs.forEach(mesg -> this.flushMesg((Mesg)mesg));
    }
}

