/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.repair;

import com.garmin.fit.Decode;
import com.garmin.fit.FileEncoder;
import com.garmin.fit.Fit;
import com.garmin.fit.repair.ActivityRepairFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ActivityRepairTool {
    private final String inputFilePath;
    private final String outputFilePath;
    private FileEncoder fileEncoder = new FileEncoder();
    private FileInputStream inputFileStream = null;

    private ActivityRepairTool() {
        this.inputFilePath = null;
        this.outputFilePath = null;
    }

    public ActivityRepairTool(String inputFilePath) {
        this.inputFilePath = inputFilePath;
        this.outputFilePath = this.createOutputFilePath();
    }

    public static void main(String[] args) throws IOException {
        if (!ActivityRepairTool.validateCommandlineArgs(args)) {
            ActivityRepairTool.printUsage();
            return;
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            System.out.println("Input file does not exist: " + args[0]);
            return;
        }
        if (!file.getName().toLowerCase().endsWith(".fit")) {
            System.out.println("Input file is not a .fit file: " + args[0]);
            return;
        }
        ActivityRepairTool activityRepairTool = new ActivityRepairTool(args[0]);
        activityRepairTool.repair();
    }

    private static boolean validateCommandlineArgs(String[] args) {
        return args.length == 1;
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar ActivityRepairTool.jar <filename>");
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repair() {
        ActivityRepairFilter activityRepairFilter = new ActivityRepairFilter();
        try {
            this.inputFileStream = new FileInputStream(this.inputFilePath);
            Decode decoder = new Decode();
            decoder.addListener(activityRepairFilter);
            decoder.read(this.inputFileStream);
        }
        catch (Exception e) {
            System.out.println("Error while decoding file. Attempting to repair file...");
        }
        finally {
            this.closeInputStream();
        }
        if (!activityRepairFilter.canRepairFile()) {
            System.out.println("File can not be repaired.");
            return;
        }
        try {
            File outputFile = new File(this.outputFilePath);
            outputFile.delete();
            this.fileEncoder = new FileEncoder(outputFile, Fit.ProtocolVersion.V2_0);
            activityRepairFilter.addListener(this.fileEncoder);
            activityRepairFilter.flushMesgs();
        }
        catch (Exception e) {
            System.out.println("Error in repair.\n");
        }
        finally {
            this.closeFileEncoder();
            System.out.println("Repair complete. Repaired .fit file can be found at: " + this.outputFilePath);
        }
    }

    private String createOutputFilePath() {
        return this.inputFilePath.substring(0, this.inputFilePath.length() - 4) + "_repaired.fit";
    }

    private void closeInputStream() {
        try {
            this.inputFileStream.close();
        }
        catch (IOException e) {
            System.err.println("Error closing Input File Stream.");
        }
    }

    private void closeFileEncoder() {
        try {
            if (this.fileEncoder != null) {
                this.fileEncoder.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error closing File Encoder.");
        }
    }
}

