/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.util;

import com.garmin.fit.Fit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamHelpers {
    public static ByteArrayInputStream byteStreamFromFile(String fileName) throws IOException {
        FileInputStream inputStream = new FileInputStream(fileName);
        return StreamHelpers.byteStreamFromInputStream(inputStream);
    }

    public static ByteArrayInputStream byteStreamFromInputStream(InputStream inputStream) throws IOException {
        int bufLen = inputStream.available();
        if (bufLen > 0) {
            int readLen;
            byte[] buf = new byte[bufLen];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((readLen = inputStream.read(buf, 0, bufLen)) != -1) {
                outputStream.write(buf, 0, readLen);
            }
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        return null;
    }

    public static void writeByteStreamToFile(ByteArrayOutputStream csvStream, String outputFileName, Boolean writeUTF8ByteOrderMark) throws Exception {
        FileOutputStream csvFile = new FileOutputStream(outputFileName);
        if (writeUTF8ByteOrderMark.booleanValue()) {
            csvFile.write(Fit.UTF8_BOM_BYTES);
        }
        csvStream.writeTo(csvFile);
    }
}

