/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.CSMspwd;
import com.gbasedbt.asf.IfxASFException;
import com.gbasedbt.asf.IfxDataOutputStream;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import java.io.BufferedOutputStream;
import java.io.IOException;

public class CSMBufferedOutputStream
extends BufferedOutputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final short BLOCK_SIZE = 8;
    static final short SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataOutputStream IfxOs = null;
    private byte[] buffer;
    private int bufferDataLen;
    private String ClientLocale = null;
    private Trace traceObj;

    public CSMBufferedOutputStream(IfxDataOutputStream ifxDataOutputStream, CSMspwd cSMspwd) {
        super(ifxDataOutputStream);
        this.CSMspwd = cSMspwd;
        this.IfxOs = ifxDataOutputStream;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    public CSMBufferedOutputStream(IfxDataOutputStream ifxDataOutputStream, int n2, CSMspwd cSMspwd) {
        super(ifxDataOutputStream, n2);
        this.CSMspwd = cSMspwd;
        this.IfxOs = ifxDataOutputStream;
        this.buffer = new byte[4098];
        this.bufferDataLen = 0;
    }

    @Override
    public final void flush() throws IOException {
        if (this.bufferDataLen > 0) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
        }
        this.IfxOs.flush();
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 >= 4098) {
            this.encryptWrite(this.buffer, 0, this.bufferDataLen);
            this.bufferDataLen = 0;
            this.encryptWrite(byArray, n2, n3);
        } else {
            int n4 = this.bufferDataLen + n3;
            if (n4 > 4098) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferDataLen);
                System.arraycopy(byArray, n2, byArray2, this.bufferDataLen, n3);
                this.encryptWrite(byArray2, 0, n4);
                this.bufferDataLen = 0;
            } else {
                System.arraycopy(byArray, n2, this.buffer, this.bufferDataLen, n3);
                if (n4 == 4098) {
                    this.encryptWrite(this.buffer, 0, n4);
                    this.bufferDataLen = 0;
                } else {
                    this.bufferDataLen = n4;
                }
            }
        }
    }

    private void encryptWrite(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        int n4;
        this.IfxOs.writeShort((short)3);
        int n5 = n3 % 8;
        if (n5 > 0) {
            n4 = n3 + (8 - n5);
            byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            for (int i2 = n3; i2 < n4; ++i2) {
                byArray2[i2] = 0;
            }
        } else {
            n4 = n3;
            byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        byte[] byArray3 = new byte[n4];
        try {
            this.CSMspwd.processOutMessage(byArray2, byArray3);
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
        short s2 = (short)(n4 + 2);
        this.IfxOs.writeShort(s2);
        this.IfxOs.writeShort(n3);
        this.IfxOs.write(byArray3, 0, n4);
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

