/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.SunJCE;
import com.gbasedbt.crypto.provider.e;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    public DESKeyFactory() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        e e2 = null;
        try {
            if (!(keySpec instanceof DESKeySpec)) {
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            DESKeySpec dESKeySpec = (DESKeySpec)keySpec;
            e2 = new e(dESKeySpec.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            if (secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (clazz != null && DESKeySpec.class.isAssignableFrom(clazz)) {
                    return new DESKeySpec(secretKey.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof e) {
                    return secretKey;
                }
                DESKeySpec dESKeySpec = (DESKeySpec)this.engineGetKeySpec(secretKey, (Class)DESKeySpec.class);
                return this.engineGenerateSecret(dESKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

