/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jns;

import com.gbasedbt.jns.IfxJNSException;
import com.gbasedbt.jns.LdapSqlhosts;
import com.gbasedbt.jns.ServerGroup;
import com.gbasedbt.jns.ServerInfo;
import com.gbasedbt.jns.Sqlhosts;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Properties;
import java.util.StringTokenizer;

class Jnstoolimpl {
    final int LIST = 1;
    final int LOOKUP = 2;
    final int ADD = 3;
    final int DEL = 4;
    final int UPDSQLH = 5;
    final int DELSQLH = 6;
    int cmd;
    Sqlhosts mysqh;
    LdapSqlhosts ldsqh;
    String cmdSrvrName = "mumbai_tli";
    String cmdFileName = "tfile.txt";
    String pfilename = "jnsproperties.txt";

    public Jnstoolimpl(String[] stringArray) {
        this.parseArgs(stringArray);
        this.initSqlhosts(this.pfilename);
        if (this.cmd == 1) {
            this.list();
        } else if (this.cmd == 2) {
            this.lookup(this.cmdSrvrName);
        } else if (this.cmd == 3) {
            this.add(this.cmdSrvrName);
        } else if (this.cmd == 4) {
            this.del(this.cmdSrvrName);
        } else if (this.cmd == 6) {
            this.delsqlh(this.cmdSrvrName);
        } else if (this.cmd == 5) {
            this.updsqlh(this.cmdFileName);
        }
    }

    public void parseArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.cmd = 1;
        } else if (stringArray[0].equalsIgnoreCase("-l")) {
            this.cmd = 1;
        } else if (stringArray[0].equalsIgnoreCase("-g")) {
            this.cmd = 2;
            if (stringArray.length > 1) {
                this.cmdSrvrName = stringArray[1];
            }
        } else if (stringArray[0].equalsIgnoreCase("-s")) {
            this.cmd = 3;
            if (stringArray.length > 1) {
                this.cmdSrvrName = stringArray[1];
            }
        } else if (stringArray[0].equalsIgnoreCase("-d")) {
            this.cmd = 4;
            if (stringArray.length > 1) {
                this.cmdSrvrName = stringArray[1];
            }
        } else if (stringArray[0].equalsIgnoreCase("-us")) {
            this.cmd = 5;
            if (stringArray.length > 1) {
                this.cmdFileName = stringArray[1];
            }
        } else if (stringArray[0].equalsIgnoreCase("-ds")) {
            this.cmd = 6;
        } else {
            System.out.println("Usage ====> \njava Jnstool [-opt [arg]]\nWhere\nopt = -l (for list)\nopt = -g sname (for get)\nopt = -d sname (for delete)\nopt = -us filename (for update SQLHOSTS node in LDAP)\nopt = -ds (for delete SQLHOSTS node in LDAP)\nNOTE----> You must have \"jnsproperties.txt\" file in CWD\n");
            System.exit(-1);
        }
    }

    public void initSqlhosts(String string) {
        Properties properties;
        try {
            properties = this.readProperties(string);
        }
        catch (Exception exception) {
            properties = new Properties();
        }
        String string2 = properties.getProperty("SQLH_TYPE", "LDAP");
        try {
            if (string2.equalsIgnoreCase("FILE")) {
                this.mysqh = new Sqlhosts(properties);
            } else {
                this.mysqh = new Sqlhosts(properties);
                this.ldsqh = new LdapSqlhosts(properties);
            }
        }
        catch (Exception exception) {
            System.err.println("JNS operation(initSqlhosts) failed.==> " + exception);
            System.err.println("The Stack Trace ==>");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public Properties readProperties(String string) throws Exception {
        Properties properties = new Properties();
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "@ ");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                properties.put(string3, string4);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Error reading Prop file e--> " + exception);
            exception.printStackTrace();
            throw exception;
        }
        return properties;
    }

    public void lookup(String string) {
        String string2 = string;
        try {
            ServerInfo serverInfo = this.mysqh.getServer(string2);
            System.out.println("The Srvr:--> " + serverInfo);
            if (serverInfo.isGroupEntry()) {
                System.out.println("[" + string2 + "] is a grp entry -- Group entries ");
                ServerGroup serverGroup = this.mysqh.getServerGroup(string2);
                while (serverGroup.hasMoreElements()) {
                    String string3;
                    String string4 = string3 = (String)serverGroup.nextElement();
                    System.out.println(" Member:-> " + string3 + " ==> ");
                    System.out.println(this.mysqh.getServer(string4));
                }
            }
        }
        catch (IfxJNSException ifxJNSException) {
            System.err.println("JNS operation(lookup)failed.==>" + ifxJNSException);
            System.err.println("The Stack Trace ==>");
            ifxJNSException.printStackTrace();
        }
    }

    public void list() {
        try {
            ServerGroup serverGroup = this.mysqh.listServers();
            while (serverGroup.hasMoreElements()) {
                String string;
                String string2 = string = (String)serverGroup.nextElement();
                System.out.println("S Member:->" + string + ":=>" + this.mysqh.getServer(string2));
            }
        }
        catch (IfxJNSException ifxJNSException) {
            System.err.println("JNS operation (list) failed.==>" + ifxJNSException);
            System.err.println("The Stack Trace ==>");
            ifxJNSException.printStackTrace();
        }
    }

    public void add(String string) {
        ServerInfo serverInfo = new ServerInfo(string, "gnettype", "ultraman", "21000", string + "++a=b");
        try {
            this.ldsqh.addServer(serverInfo);
        }
        catch (Exception exception) {
            System.err.println("The Error ==>" + exception);
        }
    }

    public void del(String string) {
        try {
            this.ldsqh.delServer(string);
        }
        catch (Exception exception) {
            System.err.println("The Error ==>" + exception);
        }
    }

    public void updsqlh(String string) {
        try {
            this.ldsqh.uploadSqlhosts(string);
        }
        catch (Exception exception) {
            System.err.println("The Error ==>" + exception);
        }
    }

    public void delsqlh(String string) {
        try {
            this.ldsqh.destroySqlhosts();
        }
        catch (Exception exception) {
            System.err.println("The Error ==>" + exception);
        }
    }
}

