/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class IfxToJavaType {
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    public static final int DAYS1900 = 693594;
    public static final int DAYS4CENT = 146097;
    public static final int DAYS4YEAR = 1461;
    CharsetDecoder dec = null;
    CharsetDecoder defdec = null;

    public synchronized String IfxToJavaChar(byte[] byArray, short s2, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, boolean bl) throws IOException {
        int n2;
        for (n2 = byArray.length; n2 > 0 && byArray[n2 - 1] == 0; --n2) {
        }
        return this.IfxToJavaChar(byArray, 0, n2, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n2, int n3, short s2, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, n2, n3, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        String string = this.IfxToJavaChar(byArray, n2, n3, "ISO8859_1", bl);
        return string;
    }

    public synchronized String IfxToJavaChar(byte[] byArray, short s2, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, 0, byArray.length, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, 0, byArray.length, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n2, int n3, short s2, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, n2, n3, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n2, int n3, String string, boolean bl) throws IOException {
        String string2 = null;
        if (bl) {
            string2 = string != null ? new String(byArray, n2, n3, string == "ISO2022CN_GB" ? "ISO2022CN" : string) : new String(byArray, n2, n3, "ISO8859_1");
        } else {
            CharsetDecoder charsetDecoder = null;
            if (string == null) {
                string = "ISO8859_1";
            }
            if (!string.equals("ISO8859_1") && !string.equals("NOCODING")) {
                if (this.dec == null) {
                    this.dec = Charset.forName(string == "ISO2022CN_GB" ? "ISO2022CN" : string).newDecoder();
                }
                charsetDecoder = this.dec;
            } else {
                if (this.defdec == null) {
                    this.defdec = Charset.forName("ISO8859_1").newDecoder();
                }
                charsetDecoder = this.defdec;
            }
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
            byteBuffer.put(byArray, n2, n3);
            byteBuffer.position(0);
            try {
                if (string.equals("NOCODING")) {
                    string2 = new String(byArray, n2, n3);
                } else {
                    CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
                    string2 = charBuffer.toString();
                    if (string2.length() == 0 && n3 == 1) {
                        byteBuffer = ByteBuffer.allocate(n3 + 1);
                        byteBuffer.put(byArray, n2, n3);
                        byteBuffer.position(0);
                        string2 = charsetDecoder.decode(byteBuffer).toString().substring(0, n3);
                    }
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IOException(IfxErrMsg.getMessage(-23103));
            }
        }
        return string2;
    }

    public static Date IfxToJavaDate(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaDate(byArray, 0);
    }

    public static Date IfxToJavaDate(byte[] byArray) {
        return IfxToJavaType.IfxToJavaDate(byArray, 0);
    }

    public static Date IfxToJavaDate(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaDate(byArray, n2);
    }

    public static Date IfxToJavaDate(byte[] byArray, int n2) {
        int n3 = IfxToJavaType.IfxToJavaInt(byArray, n2);
        if (n3 == Integer.MIN_VALUE) {
            return null;
        }
        return IfxToJavaType.convertDaysToDate(n3);
    }

    public static final boolean rleapyear(int n2) {
        return (n2 & 3) == 0 && (n2 % 400 == 0 || n2 % 100 != 0);
    }

    public static Date convertDaysToDate(int n2) {
        int n3;
        int n4 = n2 + 693594;
        byte[] byArray = new byte[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int n5 = (n4 * 4 + 3) / 146097;
        n4 -= n5 * 146097 / 4;
        int n6 = n5 * 100;
        n5 = (n4 * 4 + 3) / 1461;
        int n7 = (n4 -= n5 * 1461 / 4) + 1;
        byArray[2] = IfxToJavaType.rleapyear(n6 += n5 + 1) ? 29 : 28;
        for (n3 = 1; n3 <= 12 && n7 > byArray[n3]; n7 -= byArray[n3], ++n3) {
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)localCalendar.get();
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(n6, n3 - 1, n7, 0, 0, 0);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        return date;
    }

    public static int convertDateToDays(Date date) {
        byte[] byArray = new byte[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(1);
        byArray[2] = IfxToJavaType.rleapyear(n4) ? 29 : 28;
        int n5 = n4 - 1;
        int n6 = n5 / 100 * 146097 / 4 + n5 % 100 * 1461 / 4 + n3 - 1 - 693594;
        for (int i2 = 1; i2 < n2; ++i2) {
            n6 += byArray[i2];
        }
        return n6;
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaDateTime(byArray, 0, byArray.length, s2, null);
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaDateTime(byArray, n2, n3, s2, null);
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, int n2, int n3, short s2, Calendar calendar) {
        Decimal decimal = new Decimal(byArray, n2, n3, s2, true);
        return decimal.timestampValue(calendar);
    }

    public static String IfxToDateTimeUnloadString(byte[] byArray, int n2, int n3, short s2) {
        Decimal decimal = new Decimal(byArray, n2, n3, s2, true);
        return decimal.timestampStringValue();
    }

    public static Interval IfxToJavaInterval(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaInterval(byArray, 0, byArray.length, s2);
    }

    public static Interval IfxToJavaInterval(byte[] byArray, int n2, int n3, short s2) {
        Decimal decimal = new Decimal(byArray, n2, n3, s2, true);
        if (decimal.dec_pos == -1) {
            return null;
        }
        return decimal.intervalValue();
    }

    public static BigDecimal IfxToJavaDecimal(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaDecimal(byArray, 0, byArray.length, s2);
    }

    public static BigDecimal IfxToJavaDecimal(byte[] byArray, int n2, int n3, short s2) {
        Decimal decimal = new Decimal(byArray, n2, n3, s2);
        return decimal.numericValue();
    }

    public static double IfxToJavaDouble(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaDouble(byArray, 0);
    }

    public static double IfxToJavaDouble(byte[] byArray) {
        return IfxToJavaType.IfxToJavaDouble(byArray, 0);
    }

    public static double IfxToJavaDouble(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaDouble(byArray, n2);
    }

    public static double IfxToJavaDouble(byte[] byArray, int n2) {
        long l2 = (long)byArray[0 + n2] << 56 | (long)byArray[1 + n2] << 48 & 0xFF000000000000L | (long)byArray[2 + n2] << 40 & 0xFF0000000000L | (long)byArray[3 + n2] << 32 & 0xFF00000000L | (long)byArray[4 + n2] << 24 & 0xFF000000L | (long)byArray[5 + n2] << 16 & 0xFF0000L | (long)byArray[6 + n2] << 8 & 0xFF00L | (long)byArray[7 + n2] & 0xFFL;
        return Double.longBitsToDouble(l2);
    }

    public static float IfxToJavaReal(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaReal(byArray, 0);
    }

    public static float IfxToJavaReal(byte[] byArray) {
        return IfxToJavaType.IfxToJavaReal(byArray, 0);
    }

    public static float IfxToJavaReal(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaReal(byArray, n2);
    }

    public static float IfxToJavaReal(byte[] byArray, int n2) {
        int n3 = IfxToJavaType.IfxToJavaInt(byArray, n2);
        return Float.intBitsToFloat(n3);
    }

    protected static final short widenByte(byte by) {
        return (short)((short)by & 0xFF);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, 0);
    }

    public static short IfxToJavaSmallInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, 0);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, n2);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, int n2) {
        short s2 = byArray[0 + n2];
        s2 = (short)((s2 << 8) + IfxToJavaType.widenByte(byArray[1 + n2]));
        return s2;
    }

    public static int IfxToJavaInt(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaInt(byArray, 0);
    }

    public static int IfxToJavaInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaInt(byArray, 0);
    }

    public static int IfxToJavaInt(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaInt(byArray, n2);
    }

    public static int IfxToJavaInt(byte[] byArray, int n2) {
        int n3 = byArray[n2];
        n3 = (((n3 << 8) + IfxToJavaType.widenByte(byArray[n2 + 1]) << 8) + IfxToJavaType.widenByte(byArray[n2 + 2]) << 8) + IfxToJavaType.widenByte(byArray[n2 + 3]);
        return n3;
    }

    public static long IfxToJavaLongInt(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, 0);
    }

    public static long IfxToJavaLongInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, 0);
    }

    public static long IfxToJavaLongInt(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, n2);
    }

    public static long IfxToJavaLongInt(byte[] byArray, int n2) {
        long l2 = Long.MIN_VALUE;
        short s2 = (short)((byArray[n2] << 8) + IfxToJavaType.widenByte(byArray[n2 + 1]));
        if (s2 != 0) {
            l2 = 0xFF & byArray[n2 + 6];
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 7]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 8]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 9]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 2]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 3]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 4]);
            l2 = l2 << 8 | (long)(0xFF & byArray[n2 + 5]);
            if (s2 == -1) {
                l2 *= -1L;
            }
        }
        return l2;
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, short s2) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, 0);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, 0);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, int n2, int n3, short s2) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, n2);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, int n2) {
        long l2 = byArray[n2];
        l2 = (((((((l2 << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 1]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 2]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 3]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 4]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 5]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 6]) << 8) + (long)IfxToJavaType.widenByte(byArray[n2 + 7]);
        return l2;
    }
}

