/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import com.gbasedbt.jdbc.IfxObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bson.io.a;
import org.bson.io.b;
import org.bson.util.Util;

public abstract class OutputBuffer
extends OutputStream {
    public static int b;

    @Override
    public abstract void write(byte[] var1);

    @Override
    public abstract void write(byte[] var1, int var2, int var3);

    @Override
    public abstract void write(int var1);

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract void seekEnd();

    public abstract void seekStart();

    public abstract int size();

    public abstract int pipe(OutputStream var1) throws IOException;

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            this.pipe(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should be impossible", iOException);
        }
    }

    public String asString() {
        return new String(this.toByteArray());
    }

    public String asString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }

    public String hex() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.pipe(new a(this, stringBuilder));
        }
        catch (IOException iOException) {
            throw new RuntimeException("impossible");
        }
        return stringBuilder.toString();
    }

    public String md5() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Error - this implementation of Java doesn't support MD5.");
        }
        messageDigest.reset();
        try {
            this.pipe(new b(this, messageDigest));
        }
        catch (IOException iOException) {
            throw new RuntimeException("impossible");
        }
        return Util.toHex(messageDigest.digest());
    }

    public void writeInt(int n2) {
        this.write(n2 >> 0);
        this.write(n2 >> 8);
        this.write(n2 >> 16);
        this.write(n2 >> 24);
    }

    public void writeIntBE(int n2) {
        this.write(n2 >> 24);
        this.write(n2 >> 16);
        this.write(n2 >> 8);
        this.write(n2);
    }

    public void writeInt(int n2, int n3) {
        int n4 = this.getPosition();
        this.setPosition(n2);
        this.writeInt(n3);
        this.setPosition(n4);
    }

    public void writeLong(long l2) {
        int n2 = b;
        this.write((byte)(0xFFL & l2 >> 0));
        this.write((byte)(0xFFL & l2 >> 8));
        this.write((byte)(0xFFL & l2 >> 16));
        this.write((byte)(0xFFL & l2 >> 24));
        this.write((byte)(0xFFL & l2 >> 32));
        this.write((byte)(0xFFL & l2 >> 40));
        this.write((byte)(0xFFL & l2 >> 48));
        this.write((byte)(0xFFL & l2 >> 56));
        if (IfxObject.g) {
            b = ++n2;
        }
    }

    public void writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }
}

