/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import sqlj.codegen.BaseCodegen;
import sqlj.codegen.CursorDecl;
import sqlj.codegen.JSClassType;
import sqlj.codegen.NameBindCursor;
import sqlj.codegen.PosBindCursor;
import sqlj.codegen.engine.CodegenException;
import sqlj.framework.JSClass;
import sqlj.syntax.CursorElem;
import sqlj.syntax.Type;

class CursorCodegen
extends BaseCodegen {
    private JSClassType.Factory m_typeFactory;
    private CursorDecl m_cursorGenerator = null;
    private CursorElem m_celem;

    public CursorCodegen(CursorElem cursorElem, JSClassType.Factory factory) {
        super(cursorElem);
        this.m_celem = cursorElem;
        this.m_typeFactory = factory;
    }

    private void createGenerator() throws CodegenException {
        if (this.m_cursorGenerator != null) {
            return;
        }
        try {
            if (this.m_celem.isByName()) {
                this.m_cursorGenerator = new NameBindCursor(this.m_celem.getClassName());
                this.addColumnsByName(this.m_cursorGenerator, this.m_celem);
            } else {
                this.m_cursorGenerator = new PosBindCursor(this.m_celem.getClassName());
                this.addColumnsByType(this.m_cursorGenerator, this.m_celem);
            }
            this.addClassInfo(this.m_cursorGenerator, this.m_celem, this.m_typeFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CodegenException("ILLEGAL TYPE: " + classNotFoundException.getMessage() + " - this should not happen if semantics has verified the types");
        }
    }

    private void addColumnsByName(CursorDecl cursorDecl, CursorElem cursorElem) throws ClassNotFoundException {
        Enumeration enumeration = cursorElem.getColumnNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Type type = cursorElem.getColumnType(string);
            JSClass jSClass = type.getClass(cursorElem.getScope());
            cursorDecl.addColumn(this.m_typeFactory.getType(jSClass), string);
        }
    }

    private void addColumnsByType(CursorDecl cursorDecl, CursorElem cursorElem) throws ClassNotFoundException {
        Enumeration enumeration = cursorElem.getColumnTypes();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            JSClass jSClass = type.getClass(cursorElem.getScope());
            cursorDecl.addColumn(this.m_typeFactory.getType(jSClass), null);
        }
    }

    @Override
    public void generate(PrintWriter printWriter) throws IOException, CodegenException {
        this.createGenerator();
        this.m_cursorGenerator.stream(printWriter);
    }
}

