/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.codegen.Util;
import sqlj.framework.BaseJSClass;
import sqlj.framework.JSClass;
import sqlj.framework.JSConstructor;
import sqlj.framework.JSField;
import sqlj.framework.JSMember;
import sqlj.framework.JSMethod;
import sqlj.syntax.ClassElem;
import sqlj.util.ClassDescriptor;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;

abstract class ElemJSClass
extends JSClass {
    private JSClass[] m_interfaces = null;
    private JSClass m_declaringClass = null;
    private JSField[] m_fields;
    private static final int WITH_MODS = 25;
    static final ClassNotFoundException CYCLIC_FIELDS = new ClassNotFoundException("cyclic fields");

    public ElemJSClass(BaseJSClass baseJSClass, ClassElem classElem, JSClass[] jSClassArray) throws ClassNotFoundException {
        super(baseJSClass);
        this.m_declaringClass = this.findDeclaringClass(classElem);
        this.m_interfaces = this.calcInterfaces(classElem, jSClassArray);
        this.m_fields = this.calcFields(classElem);
    }

    public ElemJSClass(BaseJSClass baseJSClass, JSClass[] jSClassArray) {
        super(baseJSClass);
        this.m_declaringClass = null;
        this.m_interfaces = jSClassArray;
    }

    @Override
    public JSClass getDeclaringClass() {
        return this.m_declaringClass;
    }

    private JSClass findDeclaringClass(ClassElem classElem) throws ClassNotFoundException {
        Parselet parselet = classElem.getScope().getScope().getEnclosingClass();
        if (parselet != null) {
            BaseJSClass baseJSClass = ((ClassDescriptor)parselet.getDescriptor()).getBaseReflection();
            return this.resolveClass(baseJSClass);
        }
        return null;
    }

    @Override
    public JSClass[] getDeclaredClasses() throws SecurityException {
        return new JSClass[0];
    }

    @Override
    public JSField[] getDeclaredFields() throws SecurityException {
        return this.m_fields;
    }

    private JSField[] calcFields(ClassElem classElem) {
        Object[] objectArray;
        Vector<WithField> vector = new Vector<WithField>();
        Enumeration enumeration = classElem.getWithKeywords();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Parselet parselet = classElem.getWithValue((String)objectArray);
            vector.addElement(new WithField((String)objectArray, 25, parselet));
        }
        objectArray = new JSField[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public JSClass[] getInterfaces() {
        return this.m_interfaces;
    }

    private JSClass[] calcInterfaces(ClassElem classElem, JSClass[] jSClassArray) throws ClassNotFoundException {
        Object[] objectArray;
        Vector<JSClass> vector = new Vector<JSClass>();
        for (int i2 = 0; i2 < jSClassArray.length; ++i2) {
            vector.addElement(jSClassArray[i2]);
        }
        Parselet parselet = classElem.getScope();
        Enumeration enumeration = classElem.getInterfaces();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            vector.addElement(this.resolveClass((String)objectArray));
        }
        objectArray = new JSClass[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private class WithField
    extends JSMemberImpl
    implements JSField {
        private JSClass m_type;
        private Parselet m_value;
        private ClassNotFoundException m_typeError;

        public WithField(String string, int n2, Parselet parselet) {
            super(string, n2);
            this.m_type = null;
            this.m_value = parselet;
        }

        @Override
        public JSClass getType() throws ClassNotFoundException {
            if (this.m_type == null) {
                if (this.m_typeError != null) {
                    this.m_typeError.fillInStackTrace();
                    throw this.m_typeError;
                }
                this.m_typeError = CYCLIC_FIELDS;
                try {
                    this.m_type = ((ExpressionDescriptor)this.m_value.getDescriptor()).getReflection();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.m_typeError = classNotFoundException;
                    throw classNotFoundException;
                }
                this.m_typeError = null;
            }
            return this.m_type;
        }

        @Override
        public Object get() throws IllegalAccessException {
            ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)this.m_value.getDescriptor();
            if (!expressionDescriptor.isConstant()) {
                throw new IllegalAccessException();
            }
            return expressionDescriptor.getValue();
        }
    }

    protected class JSMethodImpl
    extends JSMemberImpl
    implements JSMethod {
        private JSClass[] m_params;
        private JSClass m_type;

        public JSMethodImpl(String string, int n2, JSClass jSClass, JSClass[] jSClassArray) {
            super(string, n2);
            this.m_type = jSClass;
            this.m_params = jSClassArray;
        }

        @Override
        public JSClass getReturnType() {
            return this.m_type;
        }

        @Override
        public JSClass[] getParameterTypes() {
            return this.m_params;
        }
    }

    protected class JSConstructorImpl
    extends JSMemberImpl
    implements JSConstructor {
        private JSClass[] m_params;

        public JSConstructorImpl(int n2, JSClass[] jSClassArray) {
            super(ElemJSClass.this.getName(), n2);
            this.m_params = jSClassArray;
        }

        @Override
        public JSClass[] getParameterTypes() {
            return this.m_params;
        }
    }

    protected class JSMemberImpl
    implements JSMember {
        private int m_mods;
        private String m_name;

        public JSMemberImpl(String string, int n2) {
            this.m_name = string;
            this.m_mods = n2;
        }

        @Override
        public JSClass getDeclaringClass() {
            return ElemJSClass.this;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        @Override
        public int getModifiers() {
            return this.m_mods;
        }
    }

    public static class Base
    extends BaseJSClass {
        Base(ClassElem classElem, String string) {
            super(Base.getFullName(classElem), classElem.getModifiers(), classElem.getScope().getClassResolver(), string);
        }

        private static String getFullName(ClassElem classElem) {
            StringBuffer stringBuffer = Util.getClassPrefix(classElem.getScope().getScope());
            return stringBuffer.append(classElem.getClassName()).toString();
        }

        @Override
        protected JSClass createJSClass() throws ClassNotFoundException {
            throw new ClassNotFoundException(this.getName() + " - invalid call to create JSClass()");
        }
    }
}

