/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.BaseJSClass;
import sqlj.framework.ClassResolver;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.javac.ASTTypeDeclaration;
import sqlj.javac.Node;
import sqlj.javac.SimpleNode;
import sqlj.javac.UnitDescriptorImpl;
import sqlj.mesg.JavacErrors;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;
import sqlj.util.UnitClassResolver;

public class ASTCompilationUnit
extends SimpleNode {
    protected String packageName = null;
    protected String fileName = null;
    protected UnitClassResolver resolver = null;
    protected int num_of_errors = 0;
    protected String firstClassName = null;
    private Vector m_children = new Vector();
    private TypeDescriptor desc = null;

    ASTCompilationUnit(int n2) {
        super(n2);
    }

    public void init(String string, ClassResolver classResolver) {
        this.fileName = string;
        this.resolver = new UnitClassResolver(classResolver);
    }

    public void setPackageName(String string) {
        this.packageName = string;
        if (this.packageName != null) {
            this.resolver.setPackageName(this.packageName);
        }
    }

    @Override
    public Parselet getDefiningUnit() {
        return this;
    }

    @Override
    public Parselet getEnclosingClass() {
        return null;
    }

    public void addClassDecl(Parselet parselet) {
        if (parselet.getScope() != null) {
            throw new IllegalArgumentException("class decl parselet already has scope");
        }
        parselet.setScope(this);
        this.m_children.addElement(parselet);
    }

    public Enumeration getClassDecls() {
        return this.m_children.elements();
    }

    @Override
    public ClassNameResolver getClassResolver() {
        return this.resolver;
    }

    @Override
    public TypeDescriptor getDescriptor() {
        if (this.desc == null) {
            this.desc = new UnitDescriptorImpl(this.packageName, this.firstClassName, this.fileName, this);
        }
        return this.desc;
    }

    public int parseComplete(String string, ErrorLog errorLog) {
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            Node node = this.jjtGetChild(i2);
            if (!(node instanceof ASTTypeDeclaration) || node.jjtGetNumChildren() <= 0) continue;
            Node node2 = node.jjtGetChild(0);
            try {
                TypeDescriptor typeDescriptor = node2.getDescriptor();
                if (!(typeDescriptor instanceof ClassDescriptor)) {
                    if (typeDescriptor == null) continue;
                    ++n2;
                    errorLog.addEntry(new JSError(JavacErrors.badlyPlacedSqlj()), node2.getBeginLine(), node2.getBeginColumn());
                    continue;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)typeDescriptor;
                BaseJSClass baseJSClass = classDescriptor.getBaseReflection();
                node2.setName(baseJSClass.getName(), errorLog);
                this.insertSymTab(node2, 0);
                if (string2 == null) {
                    string2 = node2.getName();
                }
                if (!Modifier.isPublic(baseJSClass.getModifiers())) continue;
                string3 = node2.getName();
                continue;
            }
            catch (ClassCircularityError classCircularityError) {
                ++n2;
                errorLog.addEntry(new JSError(classCircularityError.toString()), node2.getBeginLine(), node2.getBeginColumn());
            }
        }
        this.firstClassName = string3 != null ? string3 : string2;
        String string4 = string3;
        if (string4 != null) {
            int n3 = string4.lastIndexOf(".");
            if (n3 != -1) {
                string4 = string4.substring(n3 + 1);
            }
            if (!string4.equals(string)) {
                ++n2;
                errorLog.addEntry(new JSError(JavacErrors.badFileName(string3, string4)));
            }
        }
        return n2;
    }

    @Override
    public boolean generate(OutputContext outputContext) throws IOException {
        Writer writer = outputContext.getWriter();
        writer.write("/*@lineinfo:filename=" + this.fileName + "*/");
        boolean bl = super.generate(outputContext);
        for (int i2 = 0; i2 < this.m_children.size(); ++i2) {
            Parselet parselet = (Parselet)this.m_children.elementAt(i2);
            bl = parselet.generate(outputContext) && bl;
        }
        writer.flush();
        return bl;
    }
}

