/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import sqlj.runtime.error.ProfileErrors;

public abstract class TypeInfo
implements Serializable,
ObjectInputValidation {
    public static final int IN = 1;
    public static final int OUT = 4;
    public static final int INOUT = 2;
    static final long serialVersionUID = 171681553353768475L;

    public abstract String getJavaTypeName();

    public abstract int getSQLType();

    public static boolean isValidSQLType(int n2) {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return true;
            }
        }
        return false;
    }

    public static String SQLTypeToString(int n2) {
        switch (n2) {
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case -2: {
                return "BINARY";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return n2 + "";
    }

    public abstract String getName();

    public abstract int getMode();

    public static boolean isValidMode(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static String modeToString(int n2) {
        switch (n2) {
            case 1: {
                return "IN";
            }
            case 2: {
                return "INOUT";
            }
            case 4: {
                return "OUT";
            }
        }
        return n2 + "";
    }

    public abstract int getMarkerIndex();

    @Override
    public void validateObject() throws InvalidObjectException {
        int n2 = this.getMode();
        if (!TypeInfo.isValidMode(n2)) {
            throw new InvalidObjectException(ProfileErrors.INVALID_MODE_text(n2));
        }
    }
}

