/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCCallable;
import sqlj.runtime.profile.ref.RTStatementJDBCPrepared;

public class JDBCProfile
implements DynamicProfile {
    private ProfileData profileData;
    private Connection conn;

    public JDBCProfile(Connection connection, ProfileData profileData) {
        this.profileData = profileData;
        this.conn = connection;
    }

    @Override
    public ProfileData getProfileData() {
        return this.profileData;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public RTStatement getStatement(int n2) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n2);
        if (entryInfo.getStatementType() == 2) {
            return this.prepareStatement(this.getSQLString(n2));
        }
        return this.prepareCall(this.getSQLString(n2));
    }

    protected String getSQLString(int n2) throws SQLException {
        return this.profileData.getEntryInfo(n2).getSQLString();
    }

    @Override
    public RTCallableStatement prepareCall(String string) throws SQLException {
        RTStatementJDBCCallable rTStatementJDBCCallable = new RTStatementJDBCCallable(this.conn.prepareCall(string));
        return rTStatementJDBCCallable;
    }

    @Override
    public RTStatement prepareStatement(String string) throws SQLException {
        return new RTStatementJDBCPrepared(this.conn.prepareStatement(string));
    }

    @Override
    public void close() throws SQLException {
    }
}

