/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import sqlj.tools.SourceMapper;

public class ClassMapper {
    private DataInputStream m_in;
    private String[] m_cpStrings = null;
    private int[] m_cpStringsIdx = null;
    private String m_sourceFileName;
    private SourceMapper m_sourceMapper;
    private Vector m_lineNumberTables = new Vector();
    private boolean m_alreadyInstrumented;
    private ClassBuffer m_classBytes;
    private static final int CLASS_ATTRIBUTE = 1;
    private static final int FIELD_ATTRIBUTE = 2;
    private static final int METHOD_ATTRIBUTE = 3;
    private static final int CODE_ATTRIBUTE = 4;

    public void mapClass(Class clazz) {
        this.m_classBytes = new ClassBuffer();
        this.m_in = this.getInputStream(clazz, (OutputStream)this.m_classBytes);
        this.m_sourceMapper = this.getSourceMapper(clazz);
        if (this.m_sourceMapper.size() == 0) {
            System.out.println("Not an original sqlj file - no instrumentation.");
        } else {
            try {
                this.readClass();
                if (this.m_alreadyInstrumented) {
                    System.out.println("No instrumentation: class already instrumented.");
                } else if (this.m_lineNumberTables.size() == 0) {
                    System.out.println("No instrumentation: no line info in class.");
                } else {
                    this.m_classBytes.adjustLineNumbers();
                    this.writeBuffer(this.m_classBytes, clazz);
                }
            }
            catch (IOException iOException) {
                throw new ClassFormatError(clazz.getName());
            }
            finally {
                try {
                    this.m_in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeBuffer(ClassBuffer classBuffer, Class clazz) throws IOException {
        String string = clazz.getName().replace('.', '/') + ".class";
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        classBuffer.writeTo(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    protected DataInputStream getInputStream(Class clazz, OutputStream outputStream) throws SecurityException {
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        BufferedInputStream bufferedInputStream = new BufferedInputStream(clazz.getResourceAsStream(string));
        return this.getInputStream(bufferedInputStream, outputStream);
    }

    protected DataInputStream getInputStream(InputStream inputStream, final OutputStream outputStream) throws SecurityException {
        if (inputStream == null) {
            throw new SecurityException("could not find class file ");
        }
        return new DataInputStream(new FilterInputStream(inputStream){

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = super.read(byArray, n2, n3);
                if (n4 != -1) {
                    outputStream.write(byArray, n2, n4);
                }
                return n4;
            }

            @Override
            public int read() throws IOException {
                int n2 = super.read();
                if (n2 != -1) {
                    outputStream.write(n2);
                }
                return n2;
            }

            @Override
            public long skip(long l2) throws IOException {
                long l3;
                int n2 = 0;
                for (l3 = 0L; n2 != -1 && l3 < l2; ++l3) {
                    n2 = this.read();
                }
                return l3;
            }
        });
    }

    protected SourceMapper getSourceMapper(Class clazz) throws SecurityException {
        String string = "/" + clazz.getName().replace('.', '/') + ".java";
        InputStream inputStream = clazz.getResourceAsStream(string);
        return this.getSourceMapper(inputStream);
    }

    protected SourceMapper getSourceMapper(InputStream inputStream) throws SecurityException {
        if (inputStream == null) {
            throw new SecurityException("could not find java file");
        }
        return new SourceMapper(new InputStreamReader(inputStream));
    }

    public void readClass() throws IOException {
        this.m_in.skipBytes(8);
        int n2 = this.u2();
        this.m_cpStrings = new String[n2];
        this.m_cpStringsIdx = new int[n2];
        int n3 = 1;
        while (n3 < n2) {
            n3 = this.cp_info(n3);
        }
        this.m_in.skipBytes(4);
        this.m_in.skipBytes(2);
        n2 = this.u2();
        this.m_in.skipBytes(n2 * 2);
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.field_info();
        }
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.method_info();
        }
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.attribute_info(1);
        }
    }

    public int cp_info(int n2) throws IOException {
        int n3 = this.u1();
        switch (n3) {
            case 7: {
                this.m_in.skipBytes(2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.m_in.skipBytes(4);
                break;
            }
            case 8: {
                this.m_in.skipBytes(2);
                break;
            }
            case 5: 
            case 6: {
                this.m_in.skipBytes(8);
                ++n2;
                break;
            }
            case 1: {
                this.m_cpStrings[n2] = this.m_in.readUTF();
                this.m_cpStringsIdx[n2] = this.m_classBytes.getCount();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag " + n3 + " at ndx " + n2);
            }
        }
        return n2 + 1;
    }

    public void field_info() throws IOException {
        this.m_in.skipBytes(6);
        int n2 = this.u2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute_info(2);
        }
    }

    public void method_info() throws IOException {
        this.m_in.skipBytes(6);
        int n2 = this.u2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute_info(3);
        }
    }

    public void attribute_info(int n2) throws IOException {
        int n3 = this.u2();
        int n4 = this.u4();
        if (n2 == 1 && this.m_cpStrings[n3].equals("SourceFile")) {
            int n5 = this.u2();
            this.m_sourceFileName = this.m_cpStrings[n5];
            if (this.m_sourceFileName.endsWith(".java")) {
                this.m_classBytes.writeASCIIStringAt("sqlj", this.m_cpStringsIdx[n5] - 4);
                this.m_alreadyInstrumented = false;
            } else {
                this.m_alreadyInstrumented = true;
            }
        } else if (n2 == 4 && this.m_cpStrings[n3].equals("LineNumberTable")) {
            int n6 = this.u2();
            int n7 = this.m_classBytes.getCount();
            this.m_lineNumberTables.addElement(new LineTable(n6, n7));
            for (int i2 = 0; i2 < n6; ++i2) {
                this.m_in.skipBytes(4);
            }
        } else if (n2 == 3 && this.m_cpStrings[n3].equals("Code")) {
            this.code_attribute();
        } else {
            this.m_in.skipBytes(n4);
        }
    }

    public void code_attribute() throws IOException {
        long l2;
        this.m_in.skipBytes(4);
        for (l2 = (long)this.u4(); l2 > Integer.MAX_VALUE; l2 -= Integer.MAX_VALUE) {
            this.m_in.skipBytes(Integer.MAX_VALUE);
        }
        this.m_in.skipBytes((int)l2);
        int n2 = this.u2();
        this.m_in.skipBytes(n2 * 8);
        int n3 = this.u2();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.attribute_info(4);
        }
    }

    public int u4() throws IOException {
        return this.m_in.readInt();
    }

    public int u2() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public int u1() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public static void main(String string, String string2) {
        System.exit(ClassMapper.mainStatus(string, string2));
    }

    public static int mainStatus(String string, String string2) {
        ClassMapper classMapper = new ClassMapper();
        return classMapper.runMain(string, string2);
    }

    public int runMain(String string, String string2) {
        int n2;
        block16: {
            n2 = 0;
            try {
                this.m_classBytes = new ClassBuffer();
                this.m_in = this.getInputStream(new BufferedInputStream(new FileInputStream(string)), (OutputStream)this.m_classBytes);
                this.m_sourceMapper = this.getSourceMapper(new BufferedInputStream(new FileInputStream(string2)));
                if (this.m_sourceMapper.size() == 0) {
                    System.out.println("Not an original sqlj file - no instrumentation.");
                    n2 = 1;
                    break block16;
                }
                try {
                    this.readClass();
                    if (this.m_alreadyInstrumented) {
                        System.out.println("No instrumentation: class already instrumented.");
                        n2 = 1;
                    } else if (this.m_lineNumberTables.size() == 0) {
                        System.out.println("No instrumentation: no line info in class.");
                        n2 = 1;
                    } else {
                        this.m_classBytes.adjustLineNumbers();
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        this.m_classBytes.writeTo(fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    throw new ClassFormatError(string);
                }
                finally {
                    try {
                        this.m_in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Unable to instrument " + string + ": " + exception.getMessage());
                n2 = 1;
            }
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        System.exit(ClassMapper.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        ClassMapper classMapper = new ClassMapper();
        if (stringArray.length == 0) {
            System.out.println("java sqlj.tools.ClassMapper <classname> ... <classname>");
            System.out.println();
            System.out.println("Instruments class files to point to original SQLJ file positions.");
            System.out.println("Current directory must be at the root of the class hierarchy,");
            System.out.println("and *.class files, as well as SQLJ-generated *.java files must");
            System.out.println("be accessible.");
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                if (stringArray[i2].endsWith(".class")) {
                    stringArray[i2] = stringArray[i2].substring(0, stringArray[i2].length() - ".class".length());
                }
                System.out.println("----------------------");
                try {
                    Class<?> clazz = Class.forName(stringArray[i2]);
                    System.out.println("[Instrumenting class " + clazz.getName() + "]");
                    try {
                        classMapper.mapClass(clazz);
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Unable to instrument: " + securityException.getMessage());
                        n2 = 1;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.out.println("No class definition found error: " + noClassDefFoundError.getMessage());
                    n2 = 1;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("An Exception occurred: " + exception.getMessage());
                n2 = 1;
            }
        }
        return n2;
    }

    class LineTable {
        private int m_numEntries;
        private int m_position;

        LineTable(int n2, int n3) {
            this.m_numEntries = n2;
            this.m_position = n3;
        }

        int getNumEntries() {
            return this.m_numEntries;
        }

        int getPosition() {
            return this.m_position;
        }
    }

    class ClassBuffer
    extends ByteArrayOutputStream {
        ClassBuffer() {
        }

        void setIntAt(int n2, int n3) {
            int n4 = n2 / 256;
            int n5 = n2 - 256 * n4;
            this.buf[n3] = (byte)n4;
            this.buf[n3 + 1] = (byte)n5;
        }

        int getIntAt(int n2) {
            int n3 = this.buf[n2];
            int n4 = this.buf[n2 + 1];
            int n5 = 256 * (n3 < 0 ? n3 + 256 : n3);
            return n5 + n4 < 0 ? n4 + 256 : n4;
        }

        void writeASCIIStringAt(String string, int n2) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.buf[n2 + i2] = (byte)string.charAt(i2);
            }
        }

        int getCount() {
            return this.count;
        }

        void adjustLineNumbers() {
            int n2 = 0;
            for (int i2 = 0; i2 < ClassMapper.this.m_lineNumberTables.size(); ++i2) {
                LineTable lineTable = (LineTable)ClassMapper.this.m_lineNumberTables.elementAt(i2);
                int n3 = lineTable.getPosition();
                for (int i3 = 0; i3 < lineTable.getNumEntries(); ++i3) {
                    int n4 = this.getIntAt(n3);
                    int n5 = this.getIntAt(n3 += 2);
                    ClassMapper.this.m_sourceMapper.tgtLineToSrc(n5, 1);
                    this.setIntAt(ClassMapper.this.m_sourceMapper.startLine(), n3);
                    n3 += 2;
                    ++n2;
                }
            }
            System.out.println("[Mapped " + n2 + " line positions]");
        }
    }
}

