/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util;

import sqlj.framework.BaseJSClass;
import sqlj.util.BlockClassResolver;
import sqlj.util.ClassNameResolver;
import sqlj.util.ClassNameResolverWrapper;
import sqlj.util.UnitClassResolver;

public class NestedClassResolver
extends ClassNameResolverWrapper {
    private String m_enclosingClass;
    private int m_enclosingClassLen;
    private int m_blockCount = 0;
    private BaseJSClass m_thisClass;

    public NestedClassResolver(String string, NestedClassResolver nestedClassResolver) {
        this(nestedClassResolver, string);
    }

    public NestedClassResolver(String string, BlockClassResolver blockClassResolver) {
        this(blockClassResolver.getWindow(), string);
    }

    public NestedClassResolver(String string, UnitClassResolver unitClassResolver) {
        this(unitClassResolver, string);
    }

    private NestedClassResolver(ClassNameResolver classNameResolver, String string) {
        super(classNameResolver);
        this.m_enclosingClass = classNameResolver.getClassQualification().append(string).append("$").toString();
        this.m_enclosingClassLen = this.m_enclosingClass.length();
    }

    public static NestedClassResolver newInstance(String string, ClassNameResolver classNameResolver) {
        if (classNameResolver instanceof NestedClassResolver) {
            return new NestedClassResolver(string, (NestedClassResolver)classNameResolver);
        }
        if (classNameResolver instanceof BlockClassResolver) {
            return new NestedClassResolver(string, (BlockClassResolver)classNameResolver);
        }
        if (classNameResolver instanceof UnitClassResolver) {
            return new NestedClassResolver(string, (UnitClassResolver)classNameResolver);
        }
        throw new IllegalArgumentException("unknown base resolver type");
    }

    @Override
    public BaseJSClass getClass(String string) throws ClassNotFoundException {
        BaseJSClass baseJSClass = this.getArray(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        String string2 = string.replace('.', '$');
        baseJSClass = this.getQualifiedClass(this.m_enclosingClass + string2);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        this.initThisClass();
        BaseJSClass baseJSClass2 = this.m_thisClass;
        string2 = "$" + string2;
        while ((baseJSClass2 = this.getSuperclass(baseJSClass2)) != null) {
            baseJSClass = this.getQualifiedClass(baseJSClass2.getName() + string2);
            if (baseJSClass == null) continue;
            return baseJSClass;
        }
        return this.m_base.getClass(string);
    }

    private BaseJSClass getSuperclass(BaseJSClass baseJSClass) {
        String string = baseJSClass.getSuperclassName();
        if (string == null) {
            return null;
        }
        try {
            return this.m_base.getClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private void initThisClass() {
        if (this.m_thisClass == null) {
            this.m_thisClass = this.getQualifiedClass(this.m_enclosingClass.substring(0, this.m_enclosingClassLen - 1));
            if (this.m_thisClass == null) {
                throw new Error("class not found in resolver");
            }
        }
    }

    @Override
    public String getShortName(BaseJSClass baseJSClass) {
        String string = baseJSClass.getName();
        if (string.startsWith(this.m_enclosingClass)) {
            return string.substring(this.m_enclosingClassLen);
        }
        this.initThisClass();
        BaseJSClass baseJSClass2 = this.m_thisClass;
        while ((baseJSClass2 = this.getSuperclass(baseJSClass2)) != null) {
            String string2 = baseJSClass2.getName() + "$";
            if (!string.startsWith(string2)) continue;
            return string.substring(string2.length());
        }
        return this.m_base.getShortName(baseJSClass);
    }

    @Override
    public StringBuffer getClassQualification() {
        return new StringBuffer(this.m_enclosingClass);
    }

    int newBlockCount() {
        return this.m_blockCount++;
    }
}

