/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class OracleOutputStreamWriter
extends OutputStreamWriter {
    private static final int MAXCHAR = 127;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private char[] carr = new char[]{'\\', 'u', '0', '0', '0', '0'};

    public OracleOutputStreamWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        this(outputStream, System.getProperty("file.encoding"));
    }

    public OracleOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string != null && string.equals("Unicode") && System.getProperty("os.arch").equals("x86") ? (string = "UnicodeLittle") : string);
    }

    @Override
    public void write(int n2) throws IOException {
        if (127 < n2) {
            this.writeEscape(n2);
        } else {
            super.write(n2);
        }
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            if ('\u007f' < cArray[n5]) {
                if (n5 > n2) {
                    super.write(cArray, n2, n5 - n2);
                }
                this.writeEscape(cArray[n5]);
                n2 = ++n5;
                continue;
            }
            ++n5;
        }
        if (n4 > n2) {
            super.write(cArray, n2, n4 - n2);
        }
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        if (string == null) {
            return;
        }
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            char c2 = string.charAt(n5);
            if ('\u007f' < c2) {
                if (n5 > n2) {
                    super.write(string, n2, n5 - n2);
                }
                this.writeEscape(c2);
                n2 = ++n5;
                continue;
            }
            ++n5;
        }
        if (n4 > n2) {
            super.write(string, n2, n4 - n2);
        }
    }

    public static String getEscape(int n2) {
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[1] = 117;
        int n3 = n2 / 256;
        cArray[2] = hex[n3 / 16];
        cArray[3] = hex[n3 % 16];
        n3 = n2 % 256;
        cArray[4] = hex[n3 / 16];
        cArray[5] = hex[n3 % 16];
        return new String(cArray);
    }

    private void writeEscape(int n2) throws IOException {
        int n3 = n2 / 256;
        this.carr[2] = hex[n3 / 16];
        this.carr[3] = hex[n3 % 16];
        n3 = n2 % 256;
        this.carr[4] = hex[n3 / 16];
        this.carr[5] = hex[n3 % 16];
        super.write(this.carr, 0, 6);
    }
}

