/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.IOException;
import sqlj.util.io.CharStream;

public class StringCharStream
implements CharStream {
    private String m_s;
    private int m_length;
    private int m_pos;
    private int m_begin_token;

    public StringCharStream(String string) {
        this.m_s = string;
        if (string == null) {
            this.m_s = "";
        }
        this.m_pos = 0;
        this.m_begin_token = 0;
        this.m_length = this.m_s.length();
    }

    @Override
    public char readChar() throws IOException {
        if (this.m_pos >= this.m_length) {
            throw new IOException("Reading past end of string");
        }
        return this.m_s.charAt(this.m_pos++);
    }

    @Override
    public int getColumn() {
        return this.getEndColumn();
    }

    @Override
    public int getLine() {
        return this.getEndLine();
    }

    @Override
    public int getEndColumn() {
        return 0;
    }

    @Override
    public int getEndLine() {
        return this.m_pos;
    }

    @Override
    public int getBeginColumn() {
        return 0;
    }

    @Override
    public int getBeginLine() {
        return this.m_begin_token;
    }

    @Override
    public void backup(int n2) {
        this.m_pos -= n2;
        if (this.m_pos < 0) {
            this.m_pos = 0;
        }
    }

    @Override
    public char BeginToken() throws IOException {
        this.m_begin_token = this.m_pos;
        return this.readChar();
    }

    @Override
    public String GetImage() {
        return this.m_s.substring(this.m_begin_token, this.m_pos);
    }

    @Override
    public char[] GetSuffix(int n2) {
        return this.m_s.substring(this.m_pos - n2, this.m_pos).toCharArray();
    }

    @Override
    public void Done() {
    }
}

