/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.CodeGenUtil;
import udtudrmgr.UDRManager;
import udtudrmgr.UDTMetaData;

public class UDTManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private String gbasedbtdir = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    private boolean hasDefltIOmthd = false;

    public UDTManager(Connection connection) throws SQLException {
        if (connection == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        this.conn = (IfxConnection)connection;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
        if (TraceFlag.compiletrace) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("UDTManager: Trace is NULL");
            } else {
                this.trace.writeTrace(99, "UDTManager: constructor exited");
            }
        }
    }

    public void createUDT(UDTMetaData uDTMetaData, String string, String string2, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDT(mata,jarfile,classname,deploy) entered");
        }
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (uDTMetaData.sqlname == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        UDRManager.checkJarFile(string, this.locale);
        int n3 = this.conn.getDatabaseType();
        if (n3 == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        this.checkUDTClass(string2);
        if (this.isUDTInSysCatalog(uDTMetaData.sqlname)) {
            throw IfxErrMsg.getSQLException(-79848, "", this.locale);
        }
        String string3 = uDTMetaData.jarFileSQLName;
        if (string3 == null) {
            throw IfxErrMsg.getSQLException(-79843, "", this.locale);
        }
        UDRManager.checkJarInSysCatalog(string3, this.conn, this.locale);
        String string4 = UDRManager.transportJarToServer(string, this.jarTmpPath, this.conn, this.locale);
        if (n3 == 1 || n3 == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "UDTManager.createUDT(): start new tx");
                }
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(string3, string4, n2, this.conn);
            this.registerUDT(uDTMetaData);
            this.registerSupportUDRs(uDTMetaData, string2);
            UDRManager.registerUDRs(uDTMetaData, string2, uDTMetaData.sqlname, this.conn, this.locale);
            this.registerImplCasts(uDTMetaData.implCasts, uDTMetaData.sqlname);
            this.registerExplCasts(uDTMetaData.explCasts, uDTMetaData.sqlname);
            this.setExternalName(uDTMetaData.sqlname, string3, string2);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "UDTManager.createUDT(): rollback new tx");
                }
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n3 != 1 && n3 != 2 || this.isInUserTx)) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "UDTManager.createUDT(): commit new tx");
            }
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(string4, this.conn);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDT(mata,jarfile,classname,deploy) exited");
        }
    }

    public String createUDTClass(UDTMetaData uDTMetaData) throws SQLException {
        Vector<CodeGenUtil.Field> vector = new Vector<CodeGenUtil.Field>();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDTClass() entered");
        }
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (uDTMetaData.getSQLName() == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        if (uDTMetaData.getFieldCount() < 1) {
            throw IfxErrMsg.getSQLException(-79850, "", this.locale);
        }
        if (uDTMetaData.getLength() == -1) {
            throw IfxErrMsg.getSQLException(-79851, "", this.locale);
        }
        CodeGenUtil codeGenUtil = new CodeGenUtil();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "count is " + uDTMetaData.getFieldCount());
        }
        for (int i2 = 1; i2 <= uDTMetaData.getFieldCount(); ++i2) {
            String string = uDTMetaData.getFieldName(i2);
            int n2 = uDTMetaData.getFieldType(i2);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "Field = " + i2 + ", '" + string + "'");
            }
            if (string == null || n2 == -1) {
                throw IfxErrMsg.getSQLException(-79852, "", this.locale);
            }
            int n3 = uDTMetaData.getFieldLength(i2);
            String string2 = codeGenUtil.toStringType(n2, (short)n3);
            if (n3 == -1 && (IfxTypes.isString(n2) || n2 == 10 || n2 == 14)) {
                throw IfxErrMsg.getSQLException(-79863, "", this.locale);
            }
            String string3 = CodeGenUtil.getReadProcName(string2, n3);
            String string4 = CodeGenUtil.getWriteProcName(string2, string, n3);
            CodeGenUtil codeGenUtil2 = codeGenUtil;
            codeGenUtil2.getClass();
            vector.addElement(codeGenUtil2.new CodeGenUtil.Field(string, string2, string3, string4));
        }
        String string = this.compilesource(codeGenUtil.generateFile(uDTMetaData.getSQLName(), uDTMetaData.getClassName(), vector));
        String string5 = string.substring(0, string.indexOf(46));
        if (!uDTMetaData.keepJavaFile) {
            this.removeClientFile(string);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "keepJavaFile = " + uDTMetaData.keepJavaFile);
            this.trace.writeTrace(3, "classname = '" + string5 + "'");
            this.trace.writeTrace(1, "UDTManager:createUDTClass() exited");
        }
        return string5;
    }

    public String createJar(UDTMetaData uDTMetaData, String[] stringArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createJar() entered");
        }
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (uDTMetaData.sqlname == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        if (stringArray == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (stringArray.length == 0) {
            throw IfxErrMsg.getSQLException(-79853, "", this.locale);
        }
        String string = uDTMetaData.sqlname + ".jar";
        StringBuffer stringBuffer = new StringBuffer();
        File file = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            file = new File(stringArray[i2]);
            if (!file.exists()) {
                throw IfxErrMsg.getSQLException(-79853, "", this.locale);
            }
            stringBuffer = stringBuffer.append(" " + stringArray[i2]);
        }
        String string2 = "jar cf " + string + stringBuffer.toString();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + string2 + "'");
        }
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79847, "", this.locale);
            }
        }
        catch (Exception exception) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exeception occurs : " + exception.toString());
            }
            throw IfxErrMsg.getSQLException(-79847, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createJar() exited");
        }
        return string;
    }

    public void removeUDT(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeUDT() entered");
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        int n2 = this.conn.getDatabaseType();
        if (n2 == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        int n3 = this.getUDTXid(string);
        if (n2 == 1 || n2 == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            this.unsetExternalName(string);
            this.unregisterCastsAndCastUDRs(string, n3);
            this.unregisterNonCastUDRs(string, n3);
            this.unregisterUDT(string);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n2 != 1 && n2 != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeUDT() exited");
        }
    }

    public void removeJar(String string, int n2) throws SQLException {
        UDRManager.removeJarNow(string, n2, this.conn, this.locale);
    }

    public void setJarTmpPath(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setJarTmpPath() entered");
        }
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, string, this.locale);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setJarTmpPath() exited");
        }
    }

    private void checkUDTClass(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:checkUDTClass() entered");
        }
        try {
            int n2;
            Class<?> clazz = Class.forName(string);
            Class<?>[] classArray = clazz.getInterfaces();
            for (n2 = 0; n2 < classArray.length && !classArray[n2].getName().equals("java.sql.SQLData"); ++n2) {
            }
            if (n2 == classArray.length) {
                throw IfxErrMsg.getSQLException(-79854, "", this.locale);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw IfxErrMsg.getSQLException(-79855, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:checkUDTClass() exited");
        }
    }

    private boolean isUDTInSysCatalog(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:isUDTInSysCatalog() entered");
        }
        String string2 = null;
        string2 = this.conn.getDatabaseType() == 1 ? "select name from gbasedbt.sysxtdtypes where name = '" + string + "' and owner = '" + this.conn.getUserName() + "' and mode = 'B'" : "select name from gbasedbt.sysxtdtypes where name = '" + string + "' and mode = 'B'";
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        resultSet.close();
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string2);
            this.trace.writeTrace(1, "UDTManager:isUDTInSysCatalog() exited");
        }
        return bl;
    }

    private int getUDTXid(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:getUDTXid() entered");
        }
        String string2 = null;
        string2 = this.conn.getDatabaseType() == 1 ? "select extended_id from gbasedbt.sysxtdtypes where owner = '" + this.conn.getUserName() + "' and name = '" + string + "' and mode = 'B'" : "select extended_id from gbasedbt.sysxtdtypes where name = '" + string + "' and mode = 'B'";
        int n2 = -1;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        if (bl) {
            n2 = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        if (!bl) {
            throw IfxErrMsg.getSQLException(-79856, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string2);
            this.trace.writeTrace(3, "xid = " + n2);
            this.trace.writeTrace(1, "UDTManager:getUDTXid() exited");
        }
        return n2;
    }

    private void registerUDT(UDTMetaData uDTMetaData) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerUDT() entered");
        }
        String string = uDTMetaData.sqlname;
        int n2 = uDTMetaData.length;
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("CREATE OPAQUE TYPE " + string + " (");
        if (uDTMetaData.length == -1) {
            stringBuffer.append("internallength = variable");
        } else {
            stringBuffer.append("internallength = " + uDTMetaData.length);
        }
        if (uDTMetaData.align != -1) {
            stringBuffer.append(", alignment = " + uDTMetaData.align);
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString().trim();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string2);
        }
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerUDT() exited");
        }
    }

    private void unregisterUDT(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterUDT() entered");
        }
        String string2 = "DROP TYPE " + string + " RESTRICT";
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string2);
            this.trace.writeTrace(1, "UDTManager:unregisterUDT() exited");
        }
    }

    private void registerSupportUDRs(UDTMetaData uDTMetaData, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() entered");
        }
        boolean[] blArray = new boolean[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            blArray[i2] = true;
        }
        Method method = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Hashtable hashtable = uDTMetaData.supportudrs;
        String string8 = uDTMetaData.sqlname;
        String string9 = uDTMetaData.jarFileSQLName;
        Statement statement = this.conn.createStatement();
        if (hashtable != null && hashtable.size() != 0) {
            int n2 = hashtable.size();
            UDTMetaData.supportudrinfo[] supportudrinfoArray = new UDTMetaData.supportudrinfo[n2];
            int n3 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                supportudrinfoArray[n3] = (UDTMetaData.supportudrinfo)enumeration.nextElement();
                method = supportudrinfoArray[n3].method;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "m = " + method.toString());
                }
                string2 = method.getName();
                string3 = supportudrinfoArray[n3].sqlname;
                string4 = UDRManager.fromClassesToIfxNames(method.getParameterTypes(), string, string8, this.trace, this.locale);
                string5 = UDRManager.fromClassesToJavaNames(method.getParameterTypes(), this.trace);
                string6 = UDRManager.fromClassesToIfxNames(new Class[]{method.getReturnType()}, string, string8, this.trace, this.locale);
                string7 = "CREATE FUNCTION " + string3 + " (" + string4 + ") RETURNS " + string6 + " EXTERNAL NAME '" + string9 + ":" + string + "." + string2 + "(" + string5 + ")' LANGUAGE JAVA NOT VARIANT END FUNCTION";
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "sql = " + string7);
                }
                statement.executeUpdate(string7);
                blArray[supportudrinfoArray[n3].type] = false;
                ++n3;
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() exited");
            }
            return;
        }
        block12: for (int i3 = 0; i3 < 8; ++i3) {
            if (!blArray[i3]) continue;
            switch (i3) {
                case 0: {
                    string7 = "CREATE FUNCTION " + string8 + "_input (lvarchar) RETURNS " + string8 + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (lvarchar as " + string8 + " with " + string8 + "_input)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 1: {
                    string7 = "CREATE FUNCTION " + string8 + "_output (" + string8 + ") RETURNS lvarchar EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as lvarchar with " + string8 + "_output)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 2: {
                    string7 = "CREATE FUNCTION " + string8 + "_send (" + string8 + ") RETURNS sendrecv EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as sendrecv with " + string8 + "_send)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 3: {
                    string7 = "CREATE FUNCTION " + string8 + "_receive (sendrecv) RETURNS " + string8 + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (sendrecv as " + string8 + " with " + string8 + "_receive)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 4: {
                    string7 = "CREATE FUNCTION " + string8 + "_import (impexp) RETURNS " + string8 + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (impexp as " + string8 + " with " + string8 + "_import)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 5: {
                    string7 = "CREATE FUNCTION " + string8 + "_export (" + string8 + ") RETURNS impexp EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as impexp with " + string8 + "_export)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 6: {
                    string7 = "CREATE FUNCTION " + string8 + "_binaryimport (impexpbin) RETURNS " + string8 + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (impexpbin as " + string8 + " with " + string8 + "_binaryimport)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 7: {
                    string7 = "CREATE FUNCTION " + string8 + "_binaryexport (" + string8 + ") RETURNS impexpbin EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as impexpbin with " + string8 + "_binaryexport)";
                    statement.executeUpdate(string7);
                }
            }
        }
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() exited");
        }
    }

    private void registerImplCasts(Vector vector, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerImplCasts() entered");
        }
        String string2 = null;
        String string3 = null;
        UDTMetaData.castinfo castinfo2 = null;
        if (vector != null && vector.size() != 0) {
            Statement statement = this.conn.createStatement();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "castVec's size = " + vector.size());
            }
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                castinfo2 = (UDTMetaData.castinfo)vector.elementAt(i2);
                string3 = IfxTypes.IfxTypeToName(castinfo2.ifxtype);
                string2 = "CREATE IMPLICIT CAST (" + string3 + " as " + string + " with " + castinfo2.methodsqlname + ")";
                statement.executeUpdate(string2);
            }
            statement.close();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerImplCasts() exited");
        }
    }

    private void registerExplCasts(Vector vector, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerExplCasts() entered");
        }
        String string2 = null;
        String string3 = null;
        UDTMetaData.castinfo castinfo2 = null;
        if (vector != null && vector.size() != 0) {
            Statement statement = this.conn.createStatement();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "castVec's size = " + vector.size());
            }
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                castinfo2 = (UDTMetaData.castinfo)vector.elementAt(i2);
                string3 = IfxTypes.IfxTypeToName(castinfo2.ifxtype);
                string2 = "CREATE EXPLICIT CAST (" + string + " as " + string3 + " with " + castinfo2.methodsqlname + ")";
                statement.executeUpdate(string2);
            }
            statement.close();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerExplCasts() exited");
        }
    }

    private void unregisterCastsAndCastUDRs(String string, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterCastsAndCastUDRs() entered");
        }
        String string2 = null;
        Statement statement = this.conn.createStatement();
        Statement statement2 = this.conn.createStatement();
        string2 = this.conn.getDatabaseType() == 1 ? "select argument_type, argument_xid, result_type, result_xid, routine_name, class from gbasedbt.syscasts where (argument_xid = " + n2 + " or result_xid = " + n2 + ") and owner = '" + this.conn.getUserName() + "'" : "select argument_type, argument_xid, result_type, result_xid, routine_name, class from gbasedbt.syscasts where (argument_xid = " + n2 + " or result_xid = " + n2 + ")";
        ResultSet resultSet = statement2.executeQuery(string2);
        while (resultSet.next()) {
            String string3;
            int n3 = resultSet.getInt(1);
            int n4 = resultSet.getInt(2);
            int n5 = resultSet.getInt(3);
            int n6 = resultSet.getInt(4);
            String string4 = resultSet.getString(5);
            String string5 = resultSet.getString(6);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "UDTManager: ");
                this.trace.writeTrace(3, "\targument_type = " + n3 + ", argument_xid = " + n4);
                this.trace.writeTrace(3, "\tresult_type = " + n5 + ", result_xid = " + n6);
                this.trace.writeTrace(3, "\troutine = " + string4);
                this.trace.writeTrace(3, "\tcastclass = " + string5);
            }
            if (string5.equals("I")) {
                string3 = n3 <= 18 ? IfxTypes.IfxTypeToName(n3) : this.getXTypeName(n4);
                string2 = "DROP CAST (" + string3 + " as " + string + ")";
            } else {
                string3 = n5 <= 18 ? IfxTypes.IfxTypeToName(n5) : this.getXTypeName(n6);
                string2 = "DROP CAST (" + string + " as " + string3 + ")";
            }
            statement.executeUpdate(string2);
            string2 = "DROP ROUTINE " + string4;
            statement.executeUpdate(string2);
        }
        resultSet.close();
        statement.close();
        statement2.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterCastsAndCastUDRs() exited");
        }
    }

    private void unregisterNonCastUDRs(String string, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterNonCastUDRs() entered");
        }
        String string2 = null;
        Statement statement = this.conn.createStatement();
        Statement statement2 = this.conn.createStatement();
        string2 = this.conn.getDatabaseType() == 1 ? "select procname, isproc, paramtypes::lvarchar from gbasedbt.sysprocedures where paramtypes::lvarchar like '%" + string + "%' and langid = (select langid from gbasedbt.sysroutinelangs where langname = 'java') and owner = '" + this.conn.getUserName() + "'" : "select procname, isproc, paramtypes::lvarchar from gbasedbt.sysprocedures where paramtypes::lvarchar like '%" + string + "%' and langid = (select langid from gbasedbt.sysroutinelangs where langname = 'java')";
        ResultSet resultSet = statement2.executeQuery(string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            String string4 = resultSet.getString(2);
            String string5 = resultSet.getString(3);
            string2 = string4.equals("f") ? "DROP FUNCTION " + string3 + " (" + string5 + ")" : "DROP PROCEDURE " + string3 + " (" + string5 + ")";
            statement.executeUpdate(string2);
        }
        resultSet.close();
        statement.close();
        statement2.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterNonCastUDRs() exited");
        }
    }

    private void setExternalName(String string, String string2, String string3) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setExternalName() entered");
        }
        Statement statement = this.conn.createStatement();
        String string4 = "EXECUTE PROCEDURE sqlj.setUDTExtName('" + string + "', '" + string2 + ":" + string3 + "')";
        statement.executeUpdate(string4);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setExternalName() exited");
        }
    }

    private void unsetExternalName(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unsetExternalName() entered");
        }
        Statement statement = this.conn.createStatement();
        String string2 = "EXECUTE PROCEDURE sqlj.unsetUDTExtName('" + string + "')";
        statement.executeUpdate(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unsetExternalName() exited");
        }
    }

    private String compilesource(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:compilesource() entered");
        }
        String string2 = "javac " + string;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + string2 + "'");
        }
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79847, "", this.locale);
            }
        }
        catch (Exception exception) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exception occurs : " + exception.toString());
            }
            throw IfxErrMsg.getSQLException(-79847, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:compilesource() exited");
        }
        return string;
    }

    private String getXTypeName(int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:getXTypeName() entered");
        }
        String string = "select name from gbasedbt.sysxtdtypes where extended_id = " + n2;
        String string2 = null;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string);
            this.trace.writeTrace(3, "name = " + string2);
            this.trace.writeTrace(1, "UDTManager:getXTypeName() exited");
        }
        return string2;
    }

    private void removeClientFile(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeClientFile() entered");
        }
        String string2 = "rm -f " + string;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + string2 + "'");
        }
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79858, "", this.locale);
            }
        }
        catch (Exception exception) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exception occurs : " + exception.toString());
            }
            throw IfxErrMsg.getSQLException(-79858, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeClientFile() exited");
        }
    }
}

