/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class AliasManager {
    private Map aliases = new HashMap();

    public AliasManager() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("com/martiansoftware/nailgun/builtins/builtins.properties"));
            this.loadFromProperties(props);
        }
        catch (IOException e) {
            System.err.println("Unable to load builtins.properties: " + e.getMessage());
        }
    }

    public void loadFromProperties(Properties properties) {
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.endsWith(".desc")) continue;
            try {
                Class<?> clazz = Class.forName(properties.getProperty(key));
                String desc = properties.getProperty(key + ".desc", "");
                this.addAlias(new Alias(key, desc, clazz));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate class " + properties.getProperty(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(Alias alias) {
        Map map2 = this.aliases;
        synchronized (map2) {
            this.aliases.put(alias.getName(), alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAliases() {
        TreeSet result = new TreeSet();
        Map map2 = this.aliases;
        synchronized (map2) {
            result.addAll(this.aliases.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String aliasName) {
        Map map2 = this.aliases;
        synchronized (map2) {
            this.aliases.remove(aliasName);
        }
    }

    public Alias getAlias(String aliasName) {
        return (Alias)this.aliases.get(aliasName);
    }
}

