/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGConstants;
import com.martiansoftware.nailgun.NGSecurityManager;
import com.martiansoftware.nailgun.NGSession;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NailStats;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import com.martiansoftware.nailgun.builtins.DefaultNail;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NGServer
implements Runnable {
    public static final int DEFAULT_SESSIONPOOLSIZE = 10;
    private InetAddress addr = null;
    private int port = 0;
    private ServerSocket serversocket;
    private boolean shutdown = false;
    private boolean running = false;
    private AliasManager aliasManager;
    private boolean allowNailsByClassName = true;
    private Class defaultNailClass = null;
    private NGSessionPool sessionPool = null;
    public final PrintStream out = System.out;
    public final PrintStream err = System.err;
    public final InputStream in = System.in;
    private Map allNailStats = null;
    private SecurityManager originalSecurityManager = null;

    public NGServer(InetAddress addr, int port, int sessionPoolSize) {
        this.init(addr, port, sessionPoolSize);
    }

    public NGServer(InetAddress addr, int port) {
        this.init(addr, port, 10);
    }

    public NGServer() {
        this.init(null, 2113, 10);
    }

    private void init(InetAddress addr, int port, int sessionPoolSize) {
        this.addr = addr;
        this.port = port;
        this.aliasManager = new AliasManager();
        this.allNailStats = new HashMap();
        this.sessionPool = new NGSessionPool(this, sessionPoolSize);
    }

    public void setAllowNailsByClassName(boolean allowNailsByClassName) {
        this.allowNailsByClassName = allowNailsByClassName;
    }

    public boolean allowsNailsByClassName() {
        return this.allowNailsByClassName;
    }

    public void setDefaultNailClass(Class defaultNailClass) {
        this.defaultNailClass = defaultNailClass;
    }

    public Class getDefaultNailClass() {
        Class clazz = this.defaultNailClass == null ? DefaultNail.class : this.defaultNailClass;
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NailStats getOrCreateStatsFor(Class nailClass) {
        NailStats result = null;
        Map map2 = this.allNailStats;
        synchronized (map2) {
            result = (NailStats)this.allNailStats.get(nailClass);
            if (result == null) {
                result = new NailStats(nailClass);
                this.allNailStats.put(nailClass, result);
            }
        }
        return result;
    }

    void nailStarted(Class nailClass) {
        NailStats stats = this.getOrCreateStatsFor(nailClass);
        stats.nailStarted();
    }

    void nailFinished(Class nailClass) {
        NailStats stats = (NailStats)this.allNailStats.get(nailClass);
        stats.nailFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNailStats() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Map map2 = this.allNailStats;
        synchronized (map2) {
            Iterator i = this.allNailStats.keySet().iterator();
            while (i.hasNext()) {
                Class nailclass = (Class)i.next();
                result.put(nailclass.getName(), ((NailStats)this.allNailStats.get(nailclass)).clone());
            }
        }
        return result;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean exitVM) {
        NGServer nGServer = this;
        synchronized (nGServer) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        try {
            this.serversocket.close();
        }
        catch (Throwable toDiscard) {
            // empty catch block
        }
        this.sessionPool.shutdown();
        Class[] argTypes = new Class[]{NGServer.class};
        Object[] argValues = new Object[]{this};
        Iterator i = this.getAliasManager().getAliases().iterator();
        while (i.hasNext()) {
            Alias alias = (Alias)i.next();
            this.getOrCreateStatsFor(alias.getAliasedClass());
        }
        Map map2 = this.allNailStats;
        synchronized (map2) {
            Iterator i2 = this.allNailStats.values().iterator();
            while (i2.hasNext()) {
                NailStats ns = (NailStats)i2.next();
                Class nailClass = ns.getNailClass();
                try {
                    Method nailShutdown = nailClass.getMethod("nailShutdown", argTypes);
                    nailShutdown.invoke(null, argValues);
                }
                catch (Throwable toDiscard) {}
            }
        }
        System.setIn(this.in);
        System.setOut(this.out);
        System.setErr(this.err);
        System.setSecurityManager(this.originalSecurityManager);
        if (exitVM) {
            System.exit(0);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPort() {
        return this.serversocket == null ? this.port : this.serversocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NGSession sessionOnDeck;
        block8: {
            this.running = true;
            sessionOnDeck = null;
            this.originalSecurityManager = System.getSecurityManager();
            System.setSecurityManager(new NGSecurityManager(this.originalSecurityManager));
            InputStream inputStream = System.in;
            synchronized (inputStream) {
                if (!(System.in instanceof ThreadLocalInputStream)) {
                    System.setIn(new ThreadLocalInputStream(this.in));
                    System.setOut(new ThreadLocalPrintStream(this.out));
                    System.setErr(new ThreadLocalPrintStream(this.err));
                }
            }
            try {
                this.serversocket = this.addr == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 0, this.addr);
                while (!this.shutdown) {
                    sessionOnDeck = this.sessionPool.take();
                    Socket socket = this.serversocket.accept();
                    sessionOnDeck.run(socket);
                }
            }
            catch (Throwable t) {
                if (this.shutdown) break block8;
                t.printStackTrace();
            }
        }
        if (sessionOnDeck != null) {
            sessionOnDeck.shutdown();
        }
        this.running = false;
    }

    private static void usage() {
        System.err.println("Usage: java com.martiansoftware.nailgun.NGServer");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer port");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress:port");
    }

    public static void main(String[] args) throws NumberFormatException, UnknownHostException {
        if (args.length > 1) {
            NGServer.usage();
            return;
        }
        InetAddress serverAddress = null;
        int port = 2113;
        if (args.length != 0) {
            String[] argParts = args[0].split(":");
            String addrPart = null;
            String portPart = null;
            if (argParts.length == 2) {
                addrPart = argParts[0];
                portPart = argParts[1];
            } else if (argParts[0].indexOf(46) >= 0) {
                addrPart = argParts[0];
            } else {
                portPart = argParts[0];
            }
            if (addrPart != null) {
                serverAddress = InetAddress.getByName(addrPart);
            }
            if (portPart != null) {
                port = Integer.parseInt(portPart);
            }
        }
        NGServer server = new NGServer(serverAddress, port, 10);
        Thread t = new Thread(server);
        t.setName("NGServer(" + serverAddress + ", " + port + ")");
        t.start();
        Runtime.getRuntime().addShutdownHook(new NGServerShutdowner(server));
        int runningPort = server.getPort();
        while (runningPort == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable toIgnore) {
                // empty catch block
            }
            runningPort = server.getPort();
        }
        System.out.println("NGServer " + NGConstants.VERSION + " started on " + (serverAddress == null ? "all interfaces" : serverAddress.getHostAddress()) + ", port " + runningPort + ".");
    }

    private static class NGServerShutdowner
    extends Thread {
        private NGServer server = null;

        NGServerShutdowner(NGServer server) {
            this.server = server;
        }

        public void run() {
            this.server.shutdown(false);
            for (int count = 0; this.server.isRunning() && count < 50; ++count) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.server.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
            } else {
                System.out.println("NGServer shut down.");
            }
        }
    }
}

