/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import com.martiansoftware.nailgun.NGContext;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.scalafmt.Error;
import org.scalafmt.Error$NoMatchingFiles$;
import org.scalafmt.Formatted;
import org.scalafmt.Scalafmt$;
import org.scalafmt.cli.Cli;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CliOptions$;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.GitFiles$;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.InputMethod$StdinCode$;
import org.scalafmt.cli.RecursiveSearch$;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.cli.TermDisplay$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.config.Align;
import org.scalafmt.config.BinPack;
import org.scalafmt.config.ContinuationIndent;
import org.scalafmt.config.Docstrings;
import org.scalafmt.config.ImportSelectors;
import org.scalafmt.config.IndentOperator;
import org.scalafmt.config.LineEndings;
import org.scalafmt.config.Literals;
import org.scalafmt.config.Newlines;
import org.scalafmt.config.OptIn;
import org.scalafmt.config.ProjectFiles;
import org.scalafmt.config.RewriteSettings;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.config.ScalafmtRunner;
import org.scalafmt.config.Spaces;
import org.scalafmt.config.TrailingCommas;
import org.scalafmt.config.VerticalMultiline;
import org.scalafmt.shaded.meta.internal.tokenizers.PlatformTokenizerCache$;
import org.scalafmt.shaded.meta.parsers.ParseException;
import org.scalafmt.shaded.meta.tokenizers.TokenizeException;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.FileOps$;
import org.scalafmt.util.GitOps;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ParIterableLike;
import scala.io.Codec;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NoStackTrace;

public final class Cli$ {
    public static Cli$ MODULE$;

    static {
        new Cli$();
    }

    public void nailMain(NGContext nGContext) {
        AbsoluteFile workingDirectory = (AbsoluteFile)AbsoluteFile$.MODULE$.fromPath(nGContext.getWorkingDirectory()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected absolute path, "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"obtained nGContext.getWorkingDirectory = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nGContext.getWorkingDirectory()})));
        });
        CommonOptions x$3 = CliOptions$.MODULE$.default().common().copy(workingDirectory, nGContext.out, nGContext.in, nGContext.err);
        ScalafmtConfig x$4 = CliOptions$.MODULE$.default().copy$default$1();
        Set<Range> x$5 = CliOptions$.MODULE$.default().copy$default$2();
        Seq<AbsoluteFile> x$6 = CliOptions$.MODULE$.default().copy$default$3();
        Seq<String> x$7 = CliOptions$.MODULE$.default().copy$default$4();
        WriteMode x$8 = CliOptions$.MODULE$.default().copy$default$5();
        boolean x$9 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$10 = CliOptions$.MODULE$.default().copy$default$7();
        boolean x$11 = CliOptions$.MODULE$.default().copy$default$8();
        boolean x$12 = CliOptions$.MODULE$.default().copy$default$9();
        Option<Object> x$13 = CliOptions$.MODULE$.default().copy$default$10();
        boolean x$14 = CliOptions$.MODULE$.default().copy$default$11();
        Option<String> x$15 = CliOptions$.MODULE$.default().copy$default$12();
        String x$16 = CliOptions$.MODULE$.default().copy$default$13();
        Option<AbsoluteFile> x$17 = CliOptions$.MODULE$.default().copy$default$14();
        Function1<AbsoluteFile, GitOps> x$18 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$19 = CliOptions$.MODULE$.default().copy$default$17();
        ExitCode exit = this.mainWithOptions(nGContext.getArgs(), CliOptions$.MODULE$.default().copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19));
        nGContext.exit(exit.code());
    }

    public void main(String[] args, InputStream in, PrintStream out, PrintStream err, String workingDirectory) {
        InputStream x$20 = in;
        PrintStream x$21 = out;
        PrintStream x$22 = err;
        AbsoluteFile x$23 = (AbsoluteFile)AbsoluteFile$.MODULE$.fromPath(workingDirectory).get();
        CommonOptions x$24 = new CommonOptions(x$23, x$21, x$20, x$22);
        ScalafmtConfig x$25 = CliOptions$.MODULE$.default().copy$default$1();
        Set<Range> x$26 = CliOptions$.MODULE$.default().copy$default$2();
        Seq<AbsoluteFile> x$27 = CliOptions$.MODULE$.default().copy$default$3();
        Seq<String> x$28 = CliOptions$.MODULE$.default().copy$default$4();
        WriteMode x$29 = CliOptions$.MODULE$.default().copy$default$5();
        boolean x$30 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$31 = CliOptions$.MODULE$.default().copy$default$7();
        boolean x$32 = CliOptions$.MODULE$.default().copy$default$8();
        boolean x$33 = CliOptions$.MODULE$.default().copy$default$9();
        Option<Object> x$34 = CliOptions$.MODULE$.default().copy$default$10();
        boolean x$35 = CliOptions$.MODULE$.default().copy$default$11();
        Option<String> x$36 = CliOptions$.MODULE$.default().copy$default$12();
        String x$37 = CliOptions$.MODULE$.default().copy$default$13();
        Option<AbsoluteFile> x$38 = CliOptions$.MODULE$.default().copy$default$14();
        Function1<AbsoluteFile, GitOps> x$39 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$40 = CliOptions$.MODULE$.default().copy$default$17();
        CliOptions options = CliOptions$.MODULE$.default().copy(x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$24, x$39, x$40);
        this.mainWithOptions(args, options);
    }

    private void throwIfError(ExitCode exit) {
        ExitCode exitCode = exit;
        ExitCode exitCode2 = ExitCode$.MODULE$.Ok();
        if (exitCode == null ? exitCode2 != null : !((Object)exitCode).equals(exitCode2)) {
            throw new NoStackTrace(exit){

                public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }

                public Throwable fillInStackTrace() {
                    return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
                }
                {
                    NoStackTrace.$init$((NoStackTrace)this);
                }
            };
        }
    }

    public void main(String[] args) {
        ExitCode exit = this.mainWithOptions(args, CliOptions$.MODULE$.default());
        throw package$.MODULE$.exit(exit.code());
    }

    public void exceptionThrowingMain(String[] args) {
        ExitCode exit = this.mainWithOptions(args, CliOptions$.MODULE$.default());
        this.throwIfError(exit);
    }

    public ExitCode mainWithOptions(String[] args, CliOptions options) {
        ExitCode exitCode;
        Option<CliOptions> option = this.getConfig(args, options);
        if (option instanceof Some) {
            Some some = (Some)option;
            CliOptions x = (CliOptions)some.value();
            exitCode = this.run(x);
        } else if (None$.MODULE$.equals(option)) {
            exitCode = ExitCode$.MODULE$.CommandLineArgumentError();
        } else {
            throw new MatchError(option);
        }
        return exitCode;
    }

    public Option<CliOptions> getConfig(String[] args, CliOptions init) {
        return CliArgParser$.MODULE$.scoptParser().parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), init).map((Function1 & Serializable & scala.Serializable)parsed -> CliOptions$.MODULE$.auto(args, init, (CliOptions)parsed));
    }

    private boolean canFormat(String path) {
        return path.endsWith(".scala") || path.endsWith(".sbt") || path.endsWith(".sc");
    }

    private Seq<AbsoluteFile> getFilesFromCliOptions(CliOptions options) {
        Seq seq;
        FileFetchMode fileFetchMode = options.fileFetchMode();
        boolean bl = GitFiles$.MODULE$.equals(fileFetchMode) ? true : RecursiveSearch$.MODULE$.equals(fileFetchMode);
        if (bl) {
            FileFetchMode fileFetchMode2 = fileFetchMode;
            GitFiles$ gitFiles$ = GitFiles$.MODULE$;
            Function1 & Serializable & scala.Serializable fetchFiles = !(fileFetchMode2 != null ? !fileFetchMode2.equals(gitFiles$) : gitFiles$ != null) ? (Function1 & Serializable & scala.Serializable)x$1 -> options.gitOps().lsTree((AbsoluteFile)x$1) : (Function1 & Serializable & scala.Serializable)x$2 -> FileOps$.MODULE$.listFiles((AbsoluteFile)x$2);
            seq = (Seq)options.files().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbsoluteFile absoluteFile = x0$1;
                Seq seq = absoluteFile.jfile().isDirectory() ? (Seq)((TraversableLike)fetchFiles.apply((Object)absoluteFile)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Cli$.canFormat$1(f, options))) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbsoluteFile[]{absoluteFile}));
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        } else if (fileFetchMode instanceof DiffFiles) {
            DiffFiles diffFiles = (DiffFiles)fileFetchMode;
            String branch2 = diffFiles.branch();
            seq = (Seq)options.gitOps().diff(branch2).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Cli$.canFormat$1(f, options)));
        } else {
            throw new MatchError((Object)fileFetchMode);
        }
        return seq;
    }

    private Seq<InputMethod> getInputMethods(CliOptions options) {
        Seq seq;
        if (options.stdIn()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputMethod.StdinCode[]{InputMethod$StdinCode$.MODULE$.apply(options.assumeFilename(), options.common().in())}));
        } else {
            Seq<AbsoluteFile> projectFiles = this.getFilesFromCliOptions(options);
            seq = (Seq)projectFiles.map((Function1 & Serializable & scala.Serializable)file -> new InputMethod.FileContents((AbsoluteFile)file), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private ExitCode handleFile(InputMethod inputMethod, CliOptions options) {
        ExitCode exitCode;
        try {
            exitCode = this.unsafeHandleFile(inputMethod, options);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof Error.MisformattedFile)) {
                throw throwable;
            }
            Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable2;
            String diff = misformattedFile.customMessage();
            options.common().err().println(diff);
            ExitCode exitCode2 = ExitCode$.MODULE$.TestError();
            exitCode = exitCode2;
        }
        return exitCode;
    }

    private ExitCode unsafeHandleFile(InputMethod inputMethod, CliOptions options) {
        ExitCode exitCode;
        String input = inputMethod.readInput(options);
        Formatted formatResult = Scalafmt$.MODULE$.format(input, options.config(), options.range(), inputMethod.filename());
        Formatted formatted = formatResult;
        if (formatted instanceof Formatted.Success) {
            Formatted.Success success = (Formatted.Success)formatted;
            String formatted2 = success.formattedCode();
            inputMethod.write(formatted2, input, options);
            exitCode = ExitCode$.MODULE$.Ok();
        } else if (formatted instanceof Formatted.Failure) {
            ExitCode exitCode2;
            Formatted.Failure failure = (Formatted.Failure)formatted;
            Throwable e = failure.e();
            if (options.config().runner().ignoreWarnings()) {
                exitCode2 = ExitCode$.MODULE$.Ok();
            } else {
                ExitCode exitCode3;
                Throwable throwable = e;
                boolean bl = throwable instanceof ParseException ? true : throwable instanceof TokenizeException;
                if (bl) {
                    options.common().err().println(throwable.toString());
                    exitCode3 = ExitCode$.MODULE$.ParseError();
                } else {
                    new Cli.FailedToFormat(inputMethod.filename(), e).printStackTrace(options.common().out());
                    exitCode3 = ExitCode$.MODULE$.UnexpectedError();
                }
                exitCode2 = exitCode3;
            }
            exitCode = exitCode2;
        } else {
            throw new MatchError((Object)formatted);
        }
        return exitCode;
    }

    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        TermDisplay termDisplay;
        block0: {
            termDisplay = new TermDisplay(new OutputStreamWriter(options.info()), options.nonInteractive() || TermDisplay$.MODULE$.defaultFallbackMode());
            if (options.quiet() || !options.inPlace() && !options.testing() || inputMethods.length() <= 5) break block0;
            termDisplay.init();
            termDisplay.startTask(msg, options.common().workingDirectory().jfile());
            termDisplay.taskLength(msg, inputMethods.length(), 0L);
        }
        return termDisplay;
    }

    public ExitCode run(CliOptions options) {
        String termDisplayMessage;
        Seq<InputMethod> inputMethods = this.getInputMethods(options);
        if (inputMethods.isEmpty() && options.diff().isEmpty() && !options.stdIn()) {
            throw Error$NoMatchingFiles$.MODULE$;
        }
        AtomicInteger counter = new AtomicInteger();
        String string = termDisplayMessage = options.testing() ? "Looking for unformatted files..." : "Reformatting...";
        if (options.debug()) {
            String pwd = options.common().workingDirectory().jfile().getPath();
            PrintStream out = options.info();
            out.println("Working directory: " + pwd);
            out.println("Formatting files: " + inputMethods.toList());
        }
        ScalafmtRunner x$41 = options.config().runner().forSbt();
        String x$42 = options.config().copy$default$1();
        int x$43 = options.config().copy$default$2();
        Docstrings x$44 = options.config().copy$default$3();
        OptIn x$45 = options.config().copy$default$4();
        BinPack x$46 = options.config().copy$default$5();
        ContinuationIndent x$47 = options.config().copy$default$6();
        Align x$48 = options.config().copy$default$7();
        Spaces x$49 = options.config().copy$default$8();
        Literals x$50 = options.config().copy$default$9();
        LineEndings x$51 = options.config().copy$default$10();
        Map<String, String> x$52 = options.config().copy$default$11();
        RewriteSettings x$53 = options.config().copy$default$12();
        IndentOperator x$54 = options.config().copy$default$13();
        Newlines x$55 = options.config().copy$default$14();
        boolean x$56 = options.config().copy$default$16();
        ImportSelectors x$57 = options.config().copy$default$17();
        boolean x$58 = options.config().copy$default$18();
        boolean x$59 = options.config().copy$default$19();
        boolean x$60 = options.config().copy$default$20();
        boolean x$61 = options.config().copy$default$21();
        boolean x$62 = options.config().copy$default$22();
        TrailingCommas x$63 = options.config().copy$default$23();
        boolean x$64 = options.config().copy$default$24();
        int x$65 = options.config().copy$default$25();
        VerticalMultiline x$66 = options.config().copy$default$26();
        String x$67 = options.config().copy$default$27();
        Codec x$68 = options.config().copy$default$28();
        ProjectFiles x$69 = options.config().copy$default$29();
        CliOptions sbtOptions = options.copy(options.config().copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$41, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69), options.copy$default$2(), options.copy$default$3(), options.copy$default$4(), options.copy$default$5(), options.copy$default$6(), options.copy$default$7(), options.copy$default$8(), options.copy$default$9(), options.copy$default$10(), options.copy$default$11(), options.copy$default$12(), options.copy$default$13(), options.copy$default$14(), options.copy$default$15(), options.copy$default$16(), options.copy$default$17());
        TermDisplay termDisplay = this.newTermDisplay(options, inputMethods, termDisplayMessage);
        AtomicReference<ExitCode> exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
        ((ParIterableLike)inputMethods.par()).foreach((Function1 & Serializable & scala.Serializable)inputMethod -> {
            Cli$.$anonfun$run$1(options, counter, termDisplayMessage, sbtOptions, termDisplay, exitCode, inputMethod);
            return BoxedUnit.UNIT;
        });
        termDisplay.completedTask(termDisplayMessage, exitCode.get().isOk());
        termDisplay.stop();
        ExitCode exit = exitCode.get();
        if (options.testing()) {
            if (exit.isOk()) {
                options.common().out().println("All files are formatted with scalafmt :)");
            } else if (exit.is(ExitCode$.MODULE$.TestError())) {
                options.common().out().println("error: --test failed");
                if (new StringOps(Predef$.MODULE$.augmentString(options.config().onTestFailure())).nonEmpty()) {
                    options.common().out().println(options.config().onTestFailure());
                }
            } else {
                options.common().out().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exit})));
            }
        }
        return options.testing() && !options.config().runner().fatalWarnings() && !exit.is(ExitCode$.MODULE$.TestError()) ? ExitCode$.MODULE$.Ok() : exit;
    }

    private static final boolean canFormat$1(AbsoluteFile f, CliOptions options$2) {
        return options$2.filterMatcher().matches(f);
    }

    public static final /* synthetic */ void $anonfun$run$1(CliOptions options$1, AtomicInteger counter$1, String termDisplayMessage$1, CliOptions sbtOptions$1, TermDisplay termDisplay$1, AtomicReference exitCode$1, InputMethod inputMethod) {
        CliOptions inputConfig = inputMethod.isSbt() || inputMethod.isSc() ? sbtOptions$1 : options$1;
        ExitCode code = MODULE$.handleFile(inputMethod, inputConfig);
        exitCode$1.getAndUpdate(new UnaryOperator<ExitCode>(code){
            private final ExitCode code$1;

            public ExitCode apply(ExitCode t) {
                return ExitCode$.MODULE$.merge(this.code$1, t);
            }
            {
                this.code$1 = code$1;
            }
        });
        PlatformTokenizerCache$.MODULE$.megaCache().clear();
        termDisplay$1.taskProgress(termDisplayMessage$1, counter$1.incrementAndGet());
    }

    private Cli$() {
        MODULE$ = this;
    }
}

