/*
 * Decompiled with CFR 0.152.
 */
package com.gemnasium;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

public class Config {
    private static final String DEFAULT_BASE_URL = "https://gemnasium.com";
    private static final String API_PREFIX = "/api/v2";
    private static final String GEMNASIUM_PROPERTIES_FILE_PATH = "/src/main/resources/gemnasium.properties";
    private File baseDir;
    private String apiKey;
    private String baseUrl;
    private String projectBranch;
    private String projectSlug;
    private String projectRevision;
    private String ignoredScopes;

    public Config(File baseDir, String baseUrl, String apiKey, String projectBranch, String projectSlug, String projectRevision, String ignoredScopes) throws MojoExecutionException {
        Properties configProperties;
        this.baseDir = baseDir;
        try {
            configProperties = this.loadConfigProperties();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't load configuration file.", e);
        }
        this.baseUrl = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_BASE_URL"), baseUrl, configProperties.getProperty("baseUrl"));
        if (this.baseUrl == null || this.baseUrl.isEmpty()) {
            this.baseUrl = DEFAULT_BASE_URL;
        }
        this.apiKey = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_API_KEY"), apiKey, configProperties.getProperty("apiKey"));
        this.projectBranch = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_PROJECT_BRANCH"), projectBranch, configProperties.getProperty("projectBranch"));
        this.projectSlug = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_PROJECT_SLUG"), projectSlug, configProperties.getProperty("projectSlug"));
        this.projectRevision = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_PROJECT_REVISION"), projectRevision, configProperties.getProperty("projectRevision"));
        this.ignoredScopes = this.getFirstNotEmpty(System.getenv().get("GEMNASIUM_IGNORED_SCOPES"), ignoredScopes, configProperties.getProperty("ignoredScopes"));
    }

    private String getFirstNotEmpty(String envVarConfig, String pluginConfig, String propertyConfig) {
        if (envVarConfig != null && !envVarConfig.isEmpty()) {
            return envVarConfig;
        }
        if (pluginConfig != null && !pluginConfig.isEmpty()) {
            return pluginConfig;
        }
        return propertyConfig;
    }

    public Properties loadConfigProperties() throws Exception {
        Properties properties = new Properties();
        File file = new File(this.baseDir + GEMNASIUM_PROPERTIES_FILE_PATH);
        if (!file.exists()) {
            return properties;
        }
        FileInputStream is = new FileInputStream(file);
        properties.load(is);
        return properties;
    }

    public void updateConfigProperties(Properties updatedProperties) throws Exception {
        Properties oldProperties = this.loadConfigProperties();
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)oldProperties);
        newProperties.putAll((Map<?, ?>)updatedProperties);
        this.storeConfigProperties(newProperties);
    }

    public String toString() {
        return "baseUrl:" + this.baseUrl + "\napiKey:" + this.apiKey + "\nprojectBranch:" + this.projectBranch + "\nprojectSlug:" + this.projectSlug + "\nprojectRevision:" + this.projectRevision + "\nignoredScopes:" + this.ignoredScopes + "\n";
    }

    private void storeConfigProperties(Properties properties) throws Exception {
        File file = new File(this.baseDir + GEMNASIUM_PROPERTIES_FILE_PATH);
        FileOutputStream os = new FileOutputStream(file);
        properties.store(os, "Gemnasium configuration");
    }

    public String getApiBaseUrl() {
        return this.baseUrl + API_PREFIX;
    }

    public String getUIBaseUrl() {
        if (this.baseUrl == DEFAULT_BASE_URL) {
            return "https://beta.gemnasium.com";
        }
        return this.baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setbaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getProjectBranch() {
        return this.projectBranch;
    }

    public void setProjectBranch(String projectBranch) {
        this.projectBranch = projectBranch;
    }

    public String getProjectSlug() {
        return this.projectSlug;
    }

    public void setProjectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
    }

    public String getProjectRevision() {
        return this.projectRevision;
    }

    public void setProjectRevision(String projectRevision) {
        this.projectRevision = projectRevision;
    }

    public String getIgnoredScopes() {
        return this.ignoredScopes;
    }

    public void setIgnoredScopes(String ignoredScopes) {
        this.ignoredScopes = ignoredScopes;
    }
}

