/*
 * Decompiled with CFR 0.152.
 */
package com.gemnasium;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gemnasium.AbstractMainMojo;
import com.gemnasium.utils.AuthUtils;
import com.gemnasium.utils.ProjectsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="send-dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class SendDependenciesMojo
extends AbstractMainMojo {
    public static final String DEPENDENCY_FILE_NAME = "gemnasium-maven-plugin.json";

    public void execute() throws MojoExecutionException {
        super.execute();
        this.sendDependencies();
    }

    public void sendDependencies() throws MojoExecutionException {
        JsonNode node;
        HttpsURLConnection conn;
        URL url;
        String content = new String();
        try {
            ArrayNode jsonDependencies = ProjectsUtils.getJsonDependencies(this.getAllDependencies(), this.getDirectDependencies());
            content = ProjectsUtils.getDependencyFileContent(jsonDependencies);
        }
        catch (JsonProcessingException e) {
            throw new MojoExecutionException("send-dependencies failed, can't get project dependencies", (Exception)((Object)e));
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        ObjectNode jsonNode = mapper.createObjectNode();
        jsonNode.put("path", DEPENDENCY_FILE_NAME);
        jsonNode.put("content", content);
        arrayNode.add((JsonNode)jsonNode);
        String requestBody = arrayNode.toString();
        try {
            url = new URL(this.config.getApiBaseUrl() + "/projects/" + this.config.getProjectSlug() + "/dependency_files");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("send-dependencies failed, invalid parameters baseUrl or teamSlug, can't forge URL");
        }
        try {
            conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + AuthUtils.getEncodedBasicToken(this.config.getApiKey()));
            if (this.config.getProjectBranch() != null && !this.config.getProjectBranch().isEmpty()) {
                conn.setRequestProperty("X-Gms-Branch", this.config.getProjectBranch());
            }
            if (this.config.getProjectRevision() != null && !this.config.getProjectRevision().isEmpty()) {
                conn.setRequestProperty("X-Gms-Revision", this.config.getProjectRevision());
            }
            OutputStream os = conn.getOutputStream();
            os.write(requestBody.getBytes("UTF-8"));
            os.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("send-dependencies failed, can't connect to Gemnasium API", (Exception)e);
        }
        InputStream is = null;
        try {
            is = conn.getInputStream();
        }
        catch (IOException ioe) {
            try {
                if (conn.getResponseCode() != 200) {
                    is = conn.getErrorStream();
                    JsonNode node2 = mapper.readTree(is);
                    throw new MojoExecutionException("send-dependencies failed, API Error: " + node2.get("message").asText());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("send-dependencies failed, API Error", (Exception)e);
            }
        }
        try {
            node = mapper.readTree(is);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("send-dependencies failed, malformed API response");
        }
        if (node.get("commit_sha") == null || node.get("commit_sha").asText().isEmpty()) {
            throw new MojoExecutionException("send-dependencies failed, no new commit was returned by the API");
        }
        String commitSha = node.get("commit_sha").asText();
        String projectUrl = this.config.getUIBaseUrl() + "/projects/" + this.config.getProjectSlug() + "/commits/" + commitSha;
        this.getLog().info((CharSequence)"Your project's dependencies have been successfully sent to Gemnasium and a new revision has been created:");
        this.getLog().info((CharSequence)projectUrl);
    }
}

