/*
 * Decompiled with CFR 0.152.
 */
package com.gemnasium;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemnasium.AbstractMainMojo;
import com.gemnasium.utils.AuthUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="show-project", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class ShowProjectMojo
extends AbstractMainMojo {
    public void execute() throws MojoExecutionException {
        super.execute();
        this.showProject();
    }

    private void showProject() throws MojoExecutionException {
        HttpsURLConnection conn;
        URL url;
        String projectSlug = this.config.getProjectSlug();
        if (projectSlug == null || projectSlug.isEmpty()) {
            throw new MojoExecutionException("show-project failed, please provide the projectSlug option.");
        }
        try {
            url = new URL(this.config.getApiBaseUrl() + "/projects/" + projectSlug);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("create-project failed, invalid parameters baseUrl or teamSlug, can't forge URL");
        }
        try {
            conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "Basic " + AuthUtils.getEncodedBasicToken(this.config.getApiKey()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("show-project failed, can't connect to Gemnasium API.", (Exception)e);
        }
        InputStream is = null;
        try {
            is = conn.getInputStream();
        }
        catch (IOException ioe) {
            try {
                if (conn.getResponseCode() != 200) {
                    is = conn.getErrorStream();
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode node = mapper.readTree(is);
                    throw new MojoExecutionException("show-project failed, API Error: " + node.get("message").asText());
                }
                throw new MojoExecutionException("show-project failed, API Error");
            }
            catch (IOException e) {
                throw new MojoExecutionException("show-project failed, API Error");
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(is);
            this.getLog().info((CharSequence)("Project Info for: " + node.get("name").asText()));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\t slug: " + node.get("slug").asText()));
            this.getLog().info((CharSequence)("\t branch: " + node.get("branch").asText()));
            this.getLog().info((CharSequence)("\t color: " + node.get("color").asText()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("show-project failed, malformed API response");
        }
    }
}

