/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.StructSdtMessages_Message;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.db.driver.ExternalProviderBase;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.GXService;
import com.genexus.util.StorageUtils;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalProviderGoogle
extends ExternalProviderBase
implements ExternalProvider {
    private static Logger logger = LogManager.getLogger(ExternalProviderGoogle.class);
    static final String NAME = "GOOGLECS";
    static final String KEY = "KEY";
    static final String APPLICATION_NAME = "APPLICATION_NAME";
    static final String BUCKET = "BUCKET_NAME";
    static final String FOLDER = "FOLDER_NAME";
    static final String PROJECT_ID = "PROJECT_ID";
    static final String REGION = "REGION";
    private static final int OBJECT_NOT_FOUND = 404;
    private com.google.api.services.storage.Storage legacyClient;
    private Storage storageClient;
    private String bucket;
    private String folder;
    private String projectId;
    private String url;
    private String region;
    private int defaultExpirationMinutes = 1440;

    public ExternalProviderGoogle() throws Exception {
        this.initialize();
    }

    public ExternalProviderGoogle(GXService providerService) throws Exception {
        super(providerService);
        this.initialize();
    }

    private void initialize() throws Exception {
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
            byte[] keyArray = this.getEncryptedPropertyValue(KEY, KEY).getBytes("UTF-8");
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(keyArray)).createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
            this.legacyClient = new Storage.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(this.getPropertyValue(APPLICATION_NAME, APPLICATION_NAME)).build();
            this.region = this.getPropertyValue(REGION, REGION, "US-EAST1");
            this.projectId = this.getPropertyValue(PROJECT_ID, PROJECT_ID);
            this.storageClient = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(keyArray)))).setProjectId(this.projectId)).build().getService();
        }
        catch (GeneralSecurityException ex) {
            logger.error("Error authenticating", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
        this.bucket = this.getEncryptedPropertyValue(BUCKET, BUCKET);
        this.folder = this.getPropertyValue(FOLDER, FOLDER, "");
        this.url = String.format("https://%s.storage.googleapis.com/", this.bucket);
        this.createBucket();
        this.createFolder(this.folder);
    }

    public String getName() {
        return NAME;
    }

    private void createBucket() {
        try {
            boolean bucketAlreadyExists;
            boolean bl = bucketAlreadyExists = this.storageClient.get(this.bucket, new Storage.BucketGetOption[]{Storage.BucketGetOption.fields((Storage.BucketField[])new Storage.BucketField[0])}) != null;
            if (!bucketAlreadyExists) {
                StorageClass storageClass = StorageClass.STANDARD;
                this.storageClient.create(BucketInfo.newBuilder((String)this.bucket).setStorageClass(storageClass).setLocation(this.region).build(), new Storage.BucketTargetOption[0]);
            }
        }
        catch (StorageException ex) {
            logger.error("Error creating bucket", (Object)ex.getMessage());
        }
    }

    private void createFolder(String folderName) {
        try {
            folderName = StorageUtils.normalizeDirectoryName((String)folderName);
            StorageObject object = new StorageObject().setName(folderName);
            InputStreamContent emptyContent = new InputStreamContent("application/directory", (InputStream)new ByteArrayInputStream(new byte[0]));
            emptyContent.setLength(0L);
            Storage.Objects.Insert insertRequest = this.legacyClient.objects().insert(this.bucket, object, (AbstractInputStreamContent)emptyContent);
            insertRequest.execute();
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
    }

    private Map<String, String> createObjectMetadata(String tableName, String fieldName, String resourceKey) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Table", tableName);
        metadata.put("Field", fieldName);
        metadata.put("KeyValue", resourceKey);
        return metadata;
    }

    public void download(String externalFileName, String localFile, ResourceAccessControlList acl) {
        try (FileOutputStream out = new FileOutputStream(localFile);){
            Storage.Objects.Get request = this.legacyClient.objects().get(this.bucket, externalFileName);
            request.getMediaHttpDownloader().setDirectDownloadEnabled(true).download(new GenericUrl(this.url + StorageUtils.encodeName((String)externalFileName)), (OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public String upload(String localFile, String externalFileName, ResourceAccessControlList acl) {
        try {
            BlobId blobId = BlobId.of((String)this.bucket, (String)externalFileName);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            this.storageClient.create(blobInfo, Files.readAllBytes(Paths.get(localFile, new String[0])), new Storage.BlobTargetOption[0]);
            this.setBlobAcl(blobId, acl);
            return this.getResourceUrl(blobInfo, acl);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return "";
        }
    }

    private void setBlobAcl(BlobId blobId, ResourceAccessControlList acl) {
        if (!this.isPrivateResource(acl)) {
            this.storageClient.createAcl(blobId, Acl.of((Acl.Entity)Acl.User.ofAllUsers(), (Acl.Role)Acl.Role.READER));
        }
    }

    public String upload(String externalFileName, InputStream input, ResourceAccessControlList acl) {
        try {
            BlobId blobId = BlobId.of((String)this.bucket, (String)externalFileName);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            byte[] targetArray = IOUtils.toByteArray((InputStream)input);
            this.storageClient.create(blobInfo, targetArray, new Storage.BlobTargetOption[0]);
            this.setBlobAcl(blobId, acl);
            return this.getResourceUrl(blobInfo, acl);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return "";
        }
    }

    private String getResourceUrl(BlobInfo blobInfo, ResourceAccessControlList acl) {
        return this.getResourceUrl(blobInfo, acl, 1440);
    }

    private String getResourceUrl(BlobInfo blobInfo, ResourceAccessControlList acl, int expirationMinutes) {
        if (this.isPrivateResource(acl)) {
            expirationMinutes = expirationMinutes > 0 ? expirationMinutes : this.defaultExpirationMinutes;
            return this.storageClient.signUrl(blobInfo, (long)expirationMinutes, TimeUnit.MINUTES, new Storage.SignUrlOption[]{Storage.SignUrlOption.withV4Signature(), Storage.SignUrlOption.withVirtualHostedStyle()}).toString();
        }
        return this.url + StorageUtils.encodeName((String)blobInfo.getName());
    }

    public String get(String objectName, ResourceAccessControlList acl, int expirationMinutes) {
        Blob blob = this.storageClient.get(BlobId.of((String)this.bucket, (String)objectName));
        BlobInfo bInfo = BlobInfo.newBuilder((BlobId)blob.getBlobId()).build();
        return this.getResourceUrl(bInfo, acl, expirationMinutes);
    }

    private boolean isPrivateResource(ResourceAccessControlList acl) {
        return acl == ResourceAccessControlList.Private || acl == ResourceAccessControlList.Default && this.defaultAcl == ResourceAccessControlList.Private;
    }

    public void delete(String objectName, ResourceAccessControlList acl) {
        Boolean deleted = this.storageClient.delete(BlobId.of((String)this.bucket, (String)objectName));
        if (!deleted.booleanValue()) {
            logger.warn("Could not delete resource: " + objectName);
        }
    }

    public String rename(String objectName, String newName, ResourceAccessControlList acl) {
        String newUrl = this.copy(objectName, newName, acl);
        this.delete(objectName, acl);
        return newUrl;
    }

    public String copy(String objectName, String newName, ResourceAccessControlList acl) {
        if (objectName.contains(this.url)) {
            objectName = objectName.replace(this.url, "");
        }
        Blob blob = this.storageClient.get(this.bucket, objectName, new Storage.BlobGetOption[0]);
        CopyWriter copyWriter = blob.copyTo(this.bucket, newName, new Blob.BlobSourceOption[0]);
        Blob copiedBlob = copyWriter.getResult();
        this.setBlobAcl(copiedBlob.getBlobId(), acl);
        return this.url + StorageUtils.encodeName((String)newName);
    }

    public String copy(String objectUrl, String newName, String tableName, String fieldName, ResourceAccessControlList acl) {
        try {
            String resourceFolderName = this.folder + "/" + tableName + "/" + fieldName;
            String resourceKey = resourceFolderName + "/" + newName;
            objectUrl = objectUrl.replace(this.url, "");
            objectUrl = URLDecoder.decode(objectUrl, "UTF-8");
            try {
                Blob blob = this.storageClient.get(this.bucket, objectUrl, new Storage.BlobGetOption[0]);
                CopyWriter copyWriter = blob.copyTo(this.bucket, resourceKey, new Blob.BlobSourceOption[0]);
                Blob copiedBlob = copyWriter.getResult();
                this.setBlobAcl(copiedBlob.getBlobId(), acl);
                return this.url + StorageUtils.encodeName((String)resourceKey);
            }
            catch (Exception ex) {
                logger.error("Error saving file to external provider", (Object)ex.getMessage());
                return "";
            }
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Storage exception", (Object)ex.getMessage());
            return "";
        }
    }

    public long getLength(String objectName, ResourceAccessControlList acl) {
        try {
            return ((StorageObject)this.legacyClient.objects().get(this.bucket, objectName).execute()).getSize().longValue();
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return 0L;
        }
    }

    public Date getLastModified(String objectName, ResourceAccessControlList acl) {
        try {
            return new Date(((StorageObject)this.legacyClient.objects().get(this.bucket, objectName).execute()).getUpdated().getValue());
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return new Date();
        }
    }

    public boolean exists(String objectName, ResourceAccessControlList acl) {
        try {
            this.legacyClient.objects().get(this.bucket, objectName).execute();
            return true;
        }
        catch (GoogleJsonResponseException ex) {
            if (ex.getStatusCode() != 404) {
                logger.error("Error while checking if file exists", (Object)ex.getMessage());
            }
            return false;
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return false;
        }
    }

    public String getDirectory(String directoryName) {
        if (this.existsDirectory(directoryName = StorageUtils.normalizeDirectoryName((String)directoryName))) {
            return this.bucket + "/" + directoryName;
        }
        return "";
    }

    public boolean existsDirectory(String directoryName) {
        boolean exists = false;
        directoryName = StorageUtils.normalizeDirectoryName((String)directoryName);
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.legacyClient.objects().list(this.bucket);
            listObjects.setDelimiter("/");
            do {
                if ((objects = (Objects)listObjects.execute()).getPrefixes() != null) {
                    for (String object : objects.getPrefixes()) {
                        if (!object.equals(directoryName)) continue;
                        exists = true;
                    }
                }
                listObjects.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
        return exists;
    }

    public void createDirectory(String directoryName) {
        this.createFolder(StorageUtils.normalizeDirectoryName((String)directoryName));
    }

    public void deleteDirectory(String directoryName) {
        directoryName = StorageUtils.normalizeDirectoryName((String)directoryName);
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.legacyClient.objects().list(this.bucket);
            listObjects.setPrefix(directoryName);
            do {
                if ((objects = (Objects)listObjects.execute()).getItems() != null) {
                    for (StorageObject object : objects.getItems()) {
                        if (!this.isFile(object.getName(), "")) continue;
                        this.delete(object.getName(), null);
                    }
                }
                listObjects.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
            for (String subdir : this.getSubDirectories(directoryName)) {
                this.deleteDirectory(subdir);
            }
            if (this.exists(directoryName, null)) {
                this.delete(directoryName, null);
            }
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
    }

    public void renameDirectory(String directoryName, String newDirectoryName) {
        ResourceAccessControlList acl = null;
        directoryName = StorageUtils.normalizeDirectoryName((String)directoryName);
        newDirectoryName = StorageUtils.normalizeDirectoryName((String)newDirectoryName);
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.legacyClient.objects().list(this.bucket);
            listObjects.setPrefix(directoryName);
            do {
                if ((objects = (Objects)listObjects.execute()).isEmpty()) {
                    this.copy(directoryName, newDirectoryName, acl);
                    this.delete(directoryName, acl);
                }
                if (objects.getItems() != null) {
                    for (StorageObject object : objects.getItems()) {
                        this.copy(object.getName(), object.getName().replace(directoryName, newDirectoryName), acl);
                        this.delete(object.getName(), acl);
                    }
                }
                listObjects.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
            for (String subdir : this.getSubDirectories(directoryName)) {
                this.renameDirectory(subdir, subdir.replace(directoryName, newDirectoryName));
                this.deleteDirectory(subdir);
            }
            if (this.exists(directoryName, acl)) {
                this.delete(directoryName, acl);
            }
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
    }

    public List<String> getFiles(String directoryName, String filter) {
        ArrayList<String> files = new ArrayList<String>();
        directoryName = StorageUtils.normalizeDirectoryName((String)directoryName);
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.legacyClient.objects().list(this.bucket);
            listObjects.setPrefix(directoryName);
            do {
                if ((objects = (Objects)listObjects.execute()).getItems() != null) {
                    for (StorageObject object : objects.getItems()) {
                        if (!this.isFile(object.getName(), "") || !filter.isEmpty() && !object.getName().contains(filter)) continue;
                        files.add(object.getName());
                    }
                }
                listObjects.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
        return files;
    }

    public List<String> getFiles(String directoryName) {
        return this.getFiles(directoryName, "");
    }

    public List<String> getSubDirectories(String directoryName) {
        ArrayList<String> directories = new ArrayList<String>();
        directoryName = StorageUtils.normalizeDirectoryName((String)directoryName);
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.legacyClient.objects().list(this.bucket);
            listObjects.setPrefix(directoryName);
            listObjects.setDelimiter("/");
            do {
                if ((objects = (Objects)listObjects.execute()).getPrefixes() != null) {
                    for (String object : objects.getPrefixes()) {
                        directories.add(object);
                    }
                }
                listObjects.setPageToken(objects.getNextPageToken());
            } while (null != objects.getNextPageToken());
        }
        catch (IOException ex) {
            this.handleIOException(ex);
        }
        return directories;
    }

    public InputStream getStream(String objectName, ResourceAccessControlList acl) {
        try {
            Storage.Objects.Get request = this.legacyClient.objects().get(this.bucket, objectName);
            return request.executeMediaAsInputStream();
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            return null;
        }
    }

    public boolean getMessageFromException(Exception ex, StructSdtMessages_Message msg) {
        try {
            GoogleStorageException gex = (GoogleStorageException)ex;
            msg.setId(gex.getStatusCode());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFile(String name, String directoryName) {
        return !name.endsWith("/") && (directoryName.isEmpty() || !name.replace(directoryName, "").contains("/"));
    }

    void handleIOException(IOException ex) {
        if (this.canBuildException(ex)) {
            throw this.buildException(ex);
        }
        logger.error("Error " + ex.getClass(), (Throwable)ex);
    }

    void handleIOException(GoogleJsonResponseException ex) {
        if (this.canBuildException((Exception)((Object)ex))) {
            throw this.buildException((IOException)((Object)ex));
        }
        logger.error("Error " + ((Object)((Object)ex)).getClass(), (Throwable)ex);
    }

    boolean canBuildException(Exception ex) {
        return ex.getMessage().contains("<Message>") && ex.getMessage().contains("<Error><Code>");
    }

    GoogleStorageException buildException(IOException ex) {
        String msg = "";
        if (ex.getMessage().contains("<Message>")) {
            msg = ex.getMessage().split("<Message>")[1].split("</Message>")[0];
        }
        return new GoogleStorageException(msg, ex);
    }

    public String getObjectNameFromURL(String url) {
        String objectName = null;
        if (url.startsWith(this.getStorageUri())) {
            objectName = url.replace(this.getStorageUri(), "");
        }
        return objectName;
    }

    private String getStorageUri() {
        return this.url;
    }

    class GoogleStorageException
    extends RuntimeException {
        private String statusCode;

        GoogleStorageException(String msg, IOException ex) {
            super(msg, ex);
            if (ex.getMessage().contains("<Error><Code>")) {
                this.statusCode = ex.getMessage().split("<Error><Code>")[1].split("</Code>")[0];
            }
        }

        public String getStatusCode() {
            return this.statusCode;
        }
    }
}

