/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import com.genexus.common.interfaces.SpecificImplementation;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import java.util.Vector;

class AuthorizationModule
implements HTTPClientModule {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private static Hashtable<HttpOutputStream, AuthorizationModule> deferred_auth_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private boolean close_tok_remd = false;
    private Request saved_req = null;
    private Response saved_resp = null;

    AuthorizationModule() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) throws IOException, AuthSchemeNotImplException {
        int rem_idx;
        NVPair[] hdrs;
        block19: {
            AuthorizationInfo guess;
            block21: {
                AuthorizationHandler auth_handler;
                block18: {
                    block20: {
                        Hashtable proxy_auth_list;
                        HTTPConnection con = req.getConnection();
                        auth_handler = AuthorizationInfo.getAuthHandler();
                        hdrs = req.getHeaders();
                        rem_idx = -1;
                        HttpOutputStream out = req.getStream();
                        if (out != null && deferred_auth_list.get(out) != null) {
                            this.copyFrom(deferred_auth_list.remove(out));
                            req.copyFrom(this.saved_req);
                            Log.write(8, "AuthM: Handling deferred auth challenge");
                            this.handle_auth_challenge(req, this.saved_resp);
                            if (this.auth_sent != null) {
                                Log.write(8, "AuthM: Sending request with Authorization '" + this.auth_sent + "'");
                            } else {
                                Log.write(8, "AuthM: Sending request with Proxy-Authorization '" + this.prxy_sent + "'");
                            }
                            return 1;
                        }
                        if (con.getProxyHost() == null || this.prxy_from_4xx) break block18;
                        for (int idx = 0; idx < hdrs.length; ++idx) {
                            if (!hdrs[idx].getName().equalsIgnoreCase("Proxy-Authorization")) continue;
                            rem_idx = idx;
                            break;
                        }
                        if ((guess = (AuthorizationInfo)(proxy_auth_list = Util.getList(proxy_cntxt_list, con.getContext())).get(con.getProxyHost() + ":" + con.getProxyPort())) == null) break block18;
                        if (auth_handler == null) break block20;
                        try {
                            guess = auth_handler.fixupAuthInfo(guess, req, null, null);
                        }
                        catch (AuthSchemeNotImplException asnie) {
                            break block18;
                        }
                        if (guess == null) break block18;
                    }
                    if (rem_idx == -1) {
                        rem_idx = hdrs.length;
                        hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                        req.setHeaders(hdrs);
                    }
                    hdrs[rem_idx] = new NVPair("Proxy-Authorization", guess.toString());
                    rem_idx = -1;
                    this.prxy_sent = guess;
                    this.prxy_from_4xx = false;
                    Log.write(8, "AuthM: Preemptively sending Proxy-Authorization '" + guess + "'");
                }
                if (rem_idx >= 0) {
                    System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
                    hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
                    req.setHeaders(hdrs);
                }
                rem_idx = -1;
                if (this.auth_from_4xx || (guess = AuthorizationInfo.findBest(req)) == null) break block19;
                if (auth_handler == null) break block21;
                try {
                    guess = auth_handler.fixupAuthInfo(guess, req, null, null);
                }
                catch (AuthSchemeNotImplException asnie) {
                    break block19;
                }
                if (guess == null) break block19;
            }
            if (rem_idx == -1) {
                rem_idx = hdrs.length;
                hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                req.setHeaders(hdrs);
            }
            hdrs[rem_idx] = new NVPair("Authorization", guess.toString());
            rem_idx = -1;
            this.auth_sent = guess;
            this.auth_from_4xx = false;
            Log.write(8, "AuthM: Preemptively sending Authorization '" + guess + "'");
        }
        if (rem_idx >= 0) {
            System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
            hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
            req.setHeaders(hdrs);
        }
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        if (resp.getStatusCode() != 401 && resp.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, req, resp, false, false).addPath(req.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
        if (resp.getHeader("WWW-Authenticate") == null) {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        if (resp.getHeader("Proxy-Authenticate") == null) {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthHeaders(resp, req, this.auth_sent, this.prxy_sent);
        }
        if (this.close_tok_remd) {
            this.add_close_token(req);
            this.close_tok_remd = false;
        }
        int sts = resp.getStatusCode();
        switch (sts) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (req.getStream() != null) {
                    if (!HTTPConnection.deferStreamed) {
                        Log.write(8, "AuthM: status " + sts + " not handled - request has an output stream");
                        return 10;
                    }
                    this.saved_req = (Request)req.clone();
                    this.saved_resp = (Response)resp.clone();
                    deferred_auth_list.put(req.getStream(), this);
                    req.getStream().reset();
                    resp.setRetryRequest(true);
                    Log.write(8, "AuthM: Handling of status " + sts + " deferred because an output stream was used");
                    return 10;
                }
                Log.write(8, "AuthM: Handling status: " + sts + " " + resp.getReasonLine());
                this.handle_auth_challenge(req, resp);
                if (this.auth_sent != null || this.prxy_sent != null) {
                    try {
                        resp.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.auth_sent != null) {
                        Log.write(8, "AuthM: Resending request with Authorization '" + this.auth_sent + "'");
                    } else {
                        Log.write(8, "AuthM: Resending request with Proxy-Authorization '" + this.prxy_sent + "'");
                    }
                    return 13;
                }
                if (req.getStream() != null) {
                    Log.write(8, "AuthM: status " + sts + " not handled - request has an output stream");
                } else {
                    Log.write(8, "AuthM: No Auth Info found - status " + sts + " not handled");
                }
                return 10;
            }
        }
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthTrailers(resp, req, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request req, Response resp) throws AuthSchemeNotImplException, IOException {
        int[] idx_arr = new int[]{this.auth_lst_idx, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(resp.getHeader("WWW-Authenticate"), req, resp, "Authorization", false, idx_arr, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
            this.auth_lst_idx = idx_arr[0];
            this.auth_scm_idx = idx_arr[1];
        } else {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        idx_arr[0] = this.prxy_lst_idx;
        idx_arr[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(resp.getHeader("Proxy-Authenticate"), req, resp, "Proxy-Authorization", true, idx_arr, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
            this.prxy_lst_idx = idx_arr[0];
            this.prxy_scm_idx = idx_arr[1];
        } else {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
        if (this.prxy_sent != null) {
            HTTPConnection con = req.getConnection();
            Util.getList(proxy_cntxt_list, con.getContext()).put(con.getProxyHost() + ":" + con.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && resp.getHeader("WWW-Authenticate") == null && resp.getHeader("Proxy-Authenticate") == null) {
            if (resp.getStatusCode() != 401) {
                throw new ProtocolException("Missing Proxy-Authenticate header");
            }
            if (SpecificImplementation.SendErrorOn401 && resp.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationInfo setAuthHeaders(String auth_str, Request req, RoResponse resp, String header, boolean proxy_auth, int[] idx_arr, AuthorizationInfo prev) throws ProtocolException, AuthSchemeNotImplException, IOException {
        try {
            int auth_idx;
            int idx;
            if (Log.isEnabled(256)) {
                Log.write(256, "ExtInfo: AuthStr: " + auth_str);
                Log.write(256, "ExtInfo: Header: " + header);
                Log.write(256, "ExtInfo: ProxyAuth: " + proxy_auth);
            }
            if (auth_str == null) {
                return null;
            }
            AuthorizationInfo[] challenges = AuthorizationInfo.parseAuthString(auth_str, req, resp);
            if (Log.isEnabled(8)) {
                Log.write(8, "AuthM: parsed " + challenges.length + " challenges:");
                for (idx = 0; idx < challenges.length; ++idx) {
                    Log.write(8, "AuthM: Challenge " + challenges[idx]);
                }
            }
            if (challenges.length == 0) {
                return null;
            }
            if (prev != null && prev.getScheme().equalsIgnoreCase("Basic")) {
                for (idx = 0; idx < challenges.length; ++idx) {
                    if (!prev.getRealm().equals(challenges[idx].getRealm()) || !prev.getScheme().equalsIgnoreCase(challenges[idx].getScheme())) continue;
                    AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
                }
            }
            AuthorizationInfo credentials = null;
            AuthorizationHandler auth_handler = AuthorizationInfo.getAuthHandler();
            while (credentials == null && idx_arr[0] != -1 && idx_arr[0] < challenges.length) {
                credentials = AuthorizationInfo.getAuthorization(challenges[idx_arr[0]], req, resp, false, proxy_auth);
                if (auth_handler != null && credentials != null) {
                    credentials = auth_handler.fixupAuthInfo(credentials, req, challenges[idx_arr[0]], resp);
                }
                if ((idx_arr[0] = idx_arr[0] + 1) != challenges.length) continue;
                idx_arr[0] = -1;
            }
            if (credentials == null) {
                for (int idx2 = 0; idx2 < challenges.length; ++idx2) {
                    if (idx_arr[1] >= challenges.length) {
                        idx_arr[1] = 0;
                    }
                    try {
                        credentials = AuthorizationInfo.queryAuthHandler(challenges[idx_arr[1]], req, resp, proxy_auth);
                        break;
                    }
                    catch (AuthSchemeNotImplException asnie) {
                        if (idx2 != challenges.length - 1) continue;
                        throw asnie;
                    }
                    finally {
                        idx_arr[1] = idx_arr[1] + 1;
                    }
                }
            }
            if (Log.isEnabled(256)) {
                if (credentials == null) {
                    Log.write(256, "ExtInfo: No credentials");
                } else {
                    Log.write(256, "ExtInfo: Credentials: Scheme=" + credentials.getScheme() + " - Realm=" + credentials.getRealm() + " Host:" + credentials.getHost() + " - Port: " + credentials.getPort());
                }
            }
            if (credentials == null) {
                return null;
            }
            NVPair[] hdrs = req.getHeaders();
            for (auth_idx = 0; auth_idx < hdrs.length && !hdrs[auth_idx].getName().equalsIgnoreCase(header); ++auth_idx) {
            }
            if (auth_idx == hdrs.length) {
                hdrs = Util.resizeArray(hdrs, auth_idx + 1);
                req.setHeaders(hdrs);
            }
            hdrs[auth_idx] = new NVPair(header, credentials.toString());
            if (credentials.getScheme().equalsIgnoreCase("NTLM") && credentials.getCookie().startsWith("TlRMTVNTUAAB") && this.remove_close_token(req)) {
                this.close_tok_remd = true;
            }
            return credentials;
        }
        catch (ProtocolException e) {
            if (Log.isEnabled(256)) {
                Log.write(256, "ExtInfo: Rethrowing exception ", e);
            }
            throw e;
        }
        catch (AuthSchemeNotImplException e) {
            if (Log.isEnabled(256)) {
                Log.write(256, "ExtInfo: Rethrowing exception ", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (Log.isEnabled(256)) {
                Log.write(256, "ExtInfo: Rethrowing exception ", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (Log.isEnabled(256)) {
                Log.write(256, "ExtInfo: Rethrowing unhandled exception ", e);
            }
            throw new IOException(e.toString());
        }
    }

    private void copyFrom(AuthorizationModule other) {
        this.auth_lst_idx = other.auth_lst_idx;
        this.prxy_lst_idx = other.prxy_lst_idx;
        this.auth_scm_idx = other.auth_scm_idx;
        this.prxy_scm_idx = other.prxy_scm_idx;
        this.auth_sent = other.auth_sent;
        this.prxy_sent = other.prxy_sent;
        this.auth_from_4xx = other.auth_from_4xx;
        this.prxy_from_4xx = other.prxy_from_4xx;
        this.num_tries = other.num_tries;
        this.saved_req = other.saved_req;
        this.saved_resp = other.saved_resp;
    }

    private boolean remove_close_token(Request req) throws ProtocolException {
        Vector<HttpHeaderElement> pcon;
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Connection"); ++idx) {
        }
        if (idx >= hdrs.length) {
            return false;
        }
        try {
            pcon = Util.parseHeader(hdrs[idx].getValue());
        }
        catch (ParseException pe) {
            throw new ProtocolException(pe.toString());
        }
        HttpHeaderElement cls = new HttpHeaderElement("close");
        if (!pcon.removeElement(cls)) {
            return false;
        }
        while (pcon.removeElement(cls)) {
        }
        if (pcon.size() > 0) {
            hdrs[idx] = new NVPair("Connection", Util.assembleHeader(pcon));
        } else {
            NVPair[] nhdrs = new NVPair[hdrs.length - 1];
            System.arraycopy(hdrs, 0, nhdrs, 0, idx);
            System.arraycopy(hdrs, idx + 1, nhdrs, idx, nhdrs.length - idx);
            req.setHeaders(nhdrs);
        }
        return true;
    }

    private void add_close_token(Request req) throws ProtocolException {
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Connection"); ++idx) {
        }
        if (idx >= hdrs.length) {
            hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
            hdrs[idx] = new NVPair("Connection", "close");
            req.setHeaders(hdrs);
        } else {
            Vector<HttpHeaderElement> pcon;
            try {
                pcon = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ProtocolException(pe.toString());
            }
            pcon.addElement(new HttpHeaderElement("close"));
            hdrs[idx] = new NVPair("Connection", Util.assembleHeader(pcon));
        }
    }
}

