/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Util;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BufferedInputStream
extends FilterInputStream {
    private byte[] buffer = new byte[2000];
    private int pos = 0;
    private int end = 0;
    private int mark_pos = -1;
    private int lr_thrshld = 1500;

    BufferedInputStream(InputStream stream) {
        super(stream);
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        return this.end > this.pos ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (this.pos >= this.end && len >= this.lr_thrshld && this.mark_pos < 0) {
            return this.in.read(buf, off, len < 524288 ? len : 524288);
        }
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        int left = this.end - this.pos;
        if (len > left) {
            len = left;
        }
        System.arraycopy(this.buffer, this.pos, buf, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int left = this.end - this.pos;
        if (n <= (long)left) {
            this.pos = (int)((long)this.pos + n);
            return n;
        }
        this.pos = this.end;
        return (long)left + this.in.skip(n - (long)left);
    }

    private final void fillBuff() throws IOException {
        if (this.mark_pos > 0) {
            if (this.end >= this.buffer.length) {
                System.arraycopy(this.buffer, this.mark_pos, this.buffer, 0, this.end - this.mark_pos);
                this.pos = this.end - this.mark_pos;
            }
        } else if (this.mark_pos != 0 || this.end >= this.buffer.length) {
            this.pos = 0;
        }
        this.end = this.pos;
        int got = this.in.read(this.buffer, this.pos, this.buffer.length - this.pos < 524288 ? this.buffer.length - this.pos : 524288);
        if (got > 0) {
            this.end = this.pos + got;
        }
    }

    @Override
    public int available() throws IOException {
        int avail = this.end - this.pos;
        if (avail == 0) {
            return this.in.available();
        }
        try {
            avail += this.in.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return avail;
    }

    void markForSearch() {
        this.mark_pos = this.pos;
    }

    int pastEnd(byte[] search, int[] search_cmp) {
        int idx = Util.findStr(search, search_cmp, this.buffer, this.mark_pos, this.pos);
        if (idx == -1) {
            this.mark_pos = this.pos > search.length ? this.pos - search.length : 0;
        } else {
            int eos = idx + search.length;
            idx = this.pos - eos;
            this.pos = eos;
            this.mark_pos = -1;
        }
        return idx;
    }
}

