/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.Log;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import java.io.IOException;
import java.net.ProtocolException;

class DefaultModule
implements HTTPClientModule {
    private int req_timeout_retries = 3;

    DefaultModule() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 408: {
                if (this.req_timeout_retries-- == 0 || req.getStream() != null) {
                    Log.write(32, "DefM:  Status " + sts + " " + resp.getReasonLine() + " not handled - maximum number of retries exceeded");
                    return 10;
                }
                Log.write(32, "DefM:  Handling " + sts + " " + resp.getReasonLine() + " - resending request");
                return 13;
            }
            case 411: {
                if (req.getStream() != null && req.getStream().getLength() == -1) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (req.getData() != null) {
                    throw new ProtocolException("Received status code 411 even though Content-Length was sent");
                }
                Log.write(32, "DefM:  Handling " + sts + " " + resp.getReasonLine() + " - resending request with 'Content-length: 0'");
                req.setData(new byte[0]);
                return 13;
            }
            case 505: {
                return 10;
            }
        }
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) {
    }
}

