/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FileResponse;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class FileConnection
extends HTTPConnection {
    private String completeFilesDir;
    private String filesDir;
    private static char alternateSeparator = (char)(File.separatorChar == '\\' ? 47 : 92);

    public FileConnection(URL dirUrl) throws IOException {
        super("FileConnection");
        if (!dirUrl.getProtocol().equalsIgnoreCase("file")) {
            throw new IOException("FileConnection needs 'FILE' protocol");
        }
        if (dirUrl.getHost().startsWith("\\\\")) {
            this.completeFilesDir = dirUrl.getHost() + dirUrl.getFile().replace(alternateSeparator, File.separatorChar);
            this.filesDir = dirUrl.getHost() + File.separatorChar;
        } else if (dirUrl.getFile().replace('/', '\\').startsWith("\\\\")) {
            this.completeFilesDir = dirUrl.getFile().replace(alternateSeparator, File.separatorChar);
            this.filesDir = this.completeFilesDir + File.separatorChar;
        } else {
            File tempFile = new File(dirUrl.getHost() + ":" + dirUrl.getFile());
            if (!tempFile.isDirectory()) {
                throw new IOException(dirUrl.getFile() + " is NOT a directory");
            }
            this.completeFilesDir = tempFile.getAbsolutePath().replace(alternateSeparator, File.separatorChar);
            this.filesDir = dirUrl.getHost() + ":" + File.separator;
        }
    }

    @Override
    public HTTPResponse Get(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        return new FileResponse(this.filesDir + file);
    }
}

