/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.MD4State;

class MD4 {
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private MD4State state = new MD4State();
    private byte[] final_hash;

    public MD4() {
    }

    public MD4(byte[] data) {
        this();
        this.update(data);
    }

    public void update(byte[] data, int off, int len) {
        if (this.final_hash != null) {
            throw new IllegalStateException("Hash already terminated");
        }
        int buf_off = (int)(this.state.count >>> 3 & 0x3FL);
        int part_len = 64 - buf_off;
        this.state.count += (long)(len << 3);
        if (len >= part_len) {
            System.arraycopy(data, off, this.state.buffer, buf_off, part_len);
            this.transform(this.state.buffer, 0);
            int end = off + len;
            off += part_len;
            while (off < end - 63) {
                this.transform(data, off);
                off += 64;
            }
            buf_off = 0;
            len = end - off;
        }
        System.arraycopy(data, off, this.state.buffer, buf_off, len);
    }

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    private static final int rotate_left(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private static final int FF(int a, int b, int c, int d, int x, int s) {
        return MD4.rotate_left(a += (b & c | ~b & d) + x, s);
    }

    private static final int GG(int a, int b, int c, int d, int x, int s) {
        return MD4.rotate_left(a += (b & c | b & d | c & d) + x + 1518500249, s);
    }

    private static final int HH(int a, int b, int c, int d, int x, int s) {
        return MD4.rotate_left(a += (b ^ c ^ d) + x + 1859775393, s);
    }

    private void transform(byte[] buffer, int shift) {
        int a = this.state.state[0];
        int b = this.state.state[1];
        int c = this.state.state[2];
        int d = this.state.state[3];
        int[] x = MD4.decode(buffer, shift, 64);
        a = MD4.FF(a, b, c, d, x[0], 3);
        d = MD4.FF(d, a, b, c, x[1], 7);
        c = MD4.FF(c, d, a, b, x[2], 11);
        b = MD4.FF(b, c, d, a, x[3], 19);
        a = MD4.FF(a, b, c, d, x[4], 3);
        d = MD4.FF(d, a, b, c, x[5], 7);
        c = MD4.FF(c, d, a, b, x[6], 11);
        b = MD4.FF(b, c, d, a, x[7], 19);
        a = MD4.FF(a, b, c, d, x[8], 3);
        d = MD4.FF(d, a, b, c, x[9], 7);
        c = MD4.FF(c, d, a, b, x[10], 11);
        b = MD4.FF(b, c, d, a, x[11], 19);
        a = MD4.FF(a, b, c, d, x[12], 3);
        d = MD4.FF(d, a, b, c, x[13], 7);
        c = MD4.FF(c, d, a, b, x[14], 11);
        b = MD4.FF(b, c, d, a, x[15], 19);
        a = MD4.GG(a, b, c, d, x[0], 3);
        d = MD4.GG(d, a, b, c, x[4], 5);
        c = MD4.GG(c, d, a, b, x[8], 9);
        b = MD4.GG(b, c, d, a, x[12], 13);
        a = MD4.GG(a, b, c, d, x[1], 3);
        d = MD4.GG(d, a, b, c, x[5], 5);
        c = MD4.GG(c, d, a, b, x[9], 9);
        b = MD4.GG(b, c, d, a, x[13], 13);
        a = MD4.GG(a, b, c, d, x[2], 3);
        d = MD4.GG(d, a, b, c, x[6], 5);
        c = MD4.GG(c, d, a, b, x[10], 9);
        b = MD4.GG(b, c, d, a, x[14], 13);
        a = MD4.GG(a, b, c, d, x[3], 3);
        d = MD4.GG(d, a, b, c, x[7], 5);
        c = MD4.GG(c, d, a, b, x[11], 9);
        b = MD4.GG(b, c, d, a, x[15], 13);
        a = MD4.HH(a, b, c, d, x[0], 3);
        d = MD4.HH(d, a, b, c, x[8], 9);
        c = MD4.HH(c, d, a, b, x[4], 11);
        b = MD4.HH(b, c, d, a, x[12], 15);
        a = MD4.HH(a, b, c, d, x[2], 3);
        d = MD4.HH(d, a, b, c, x[10], 9);
        c = MD4.HH(c, d, a, b, x[6], 11);
        b = MD4.HH(b, c, d, a, x[14], 15);
        a = MD4.HH(a, b, c, d, x[1], 3);
        d = MD4.HH(d, a, b, c, x[9], 9);
        c = MD4.HH(c, d, a, b, x[5], 11);
        b = MD4.HH(b, c, d, a, x[13], 15);
        a = MD4.HH(a, b, c, d, x[3], 3);
        d = MD4.HH(d, a, b, c, x[11], 9);
        c = MD4.HH(c, d, a, b, x[7], 11);
        b = MD4.HH(b, c, d, a, x[15], 15);
        this.state.state[0] = this.state.state[0] + a;
        this.state.state[1] = this.state.state[1] + b;
        this.state.state[2] = this.state.state[2] + c;
        this.state.state[3] = this.state.state[3] + d;
    }

    public byte[] getHash() {
        if (this.final_hash != null) {
            return this.final_hash;
        }
        int[] orig_count = new int[]{(int)(this.state.count & 0xFFFFFFFFFFFFFFFFL), (int)(this.state.count >> 32)};
        int buf_off = (int)(this.state.count >>> 3 & 0x3FL);
        int pad_len = buf_off < 56 ? 56 - buf_off : 120 - buf_off;
        this.update(padding, 0, pad_len);
        this.update(MD4.encode(orig_count, 0, 2), 0, 8);
        this.final_hash = MD4.encode(this.state.state, 0, 4);
        return this.final_hash;
    }

    private static final int[] decode(byte[] buffer, int off, int len) {
        int ilen = len >>> 2;
        int[] out = new int[ilen];
        int src = off;
        for (int dst = 0; dst < ilen; ++dst) {
            out[dst] = buffer[src++] & 0xFF | (buffer[src++] & 0xFF) << 8 | (buffer[src++] & 0xFF) << 16 | (buffer[src++] & 0xFF) << 24;
        }
        return out;
    }

    private static final byte[] encode(int[] buffer, int off, int len) {
        int blen = len << 2;
        byte[] out = new byte[blen];
        int dst = 0;
        int src = off;
        while (dst < blen) {
            int b = buffer[src];
            out[dst++] = (byte)(b & 0xFF);
            out[dst++] = (byte)(b >> 8 & 0xFF);
            out[dst++] = (byte)(b >> 16 & 0xFF);
            out[dst++] = (byte)(b >> 24 & 0xFF);
            ++src;
        }
        return out;
    }

    public String toString() {
        byte[] hash = this.getHash();
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int idx = 0; idx < hash.length; ++idx) {
            int num = hash[idx] & 0xFF;
            if (num < 16) {
                buf.append("0");
            }
            buf.append(Integer.toString(num, 16));
        }
        return buf.toString();
    }
}

