/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.ResponseHandler;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

final class RespInputStream
extends InputStream
implements GlobalConstants {
    private static boolean dontTimeoutBody = false;
    private StreamDemultiplexor demux = null;
    private ResponseHandler resph;
    boolean closed = false;
    private boolean dont_truncate = false;
    private byte[] buffer = null;
    private boolean interrupted = false;
    private int offset = 0;
    private int end = 0;
    int count = 0;
    private byte[] ch = new byte[1];

    RespInputStream(StreamDemultiplexor demux, ResponseHandler resph) {
        this.demux = demux;
        this.resph = resph;
    }

    @Override
    public synchronized int read() throws IOException {
        int rcvd = this.read(this.ch, 0, 1);
        if (rcvd == 1) {
            return this.ch[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int rcvd;
        if (this.closed) {
            return -1;
        }
        int left = this.end - this.offset;
        if (!(this.buffer == null || left == 0 && this.interrupted)) {
            if (left == 0) {
                return -1;
            }
            len = len > left ? left : len;
            System.arraycopy(this.buffer, this.offset, b, off, len);
            this.offset += len;
            return len;
        }
        if (this.resph.resp.cd_type != 1) {
            Log.write(4, "RspIS: Reading stream " + this.hashCode());
        }
        if ((rcvd = dontTimeoutBody && this.resph.resp.cd_type != 1 ? this.demux.read(b, off, len, this.resph, 0) : this.demux.read(b, off, len, this.resph, this.resph.resp.timeout)) != -1 && this.resph.resp.got_headers) {
            this.count += rcvd;
        }
        return rcvd;
    }

    @Override
    public synchronized long skip(long num) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int left = this.end - this.offset;
        if (!(this.buffer == null || left == 0 && this.interrupted)) {
            num = num > (long)left ? (long)left : num;
            this.offset = (int)((long)this.offset + num);
            return num;
        }
        long skpd = this.demux.skip(num, this.resph);
        if (this.resph.resp.got_headers) {
            this.count = (int)((long)this.count + skpd);
        }
        return skpd;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        if (!(this.buffer == null || this.end - this.offset == 0 && this.interrupted)) {
            return this.end - this.offset;
        }
        return this.demux.available(this.resph);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.dont_truncate && (this.buffer == null || this.interrupted)) {
                this.readAll(this.resph.resp.timeout);
            }
            Log.write(4, "RspIS: User closed stream " + this.hashCode());
            this.demux.closeSocketIfAllStreamsClosed();
            if (this.dont_truncate) {
                try {
                    this.resph.resp.http_resp.invokeTrailerHandlers(false);
                }
                catch (ModuleException me) {
                    throw new IOException(me.toString());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readAll(int timeout) throws IOException {
        Log.write(4, "RspIS: Read-all on stream " + this.hashCode());
        GlobalConstants globalConstants = this.resph.resp;
        synchronized (globalConstants) {
            if (!this.resph.resp.got_headers) {
                int sav_to = this.resph.resp.timeout;
                this.resph.resp.timeout = timeout;
                this.resph.resp.getStatusCode();
                this.resph.resp.timeout = sav_to;
            }
        }
        globalConstants = this;
        synchronized (globalConstants) {
            if (this.buffer != null && !this.interrupted) {
                return;
            }
            int rcvd = 0;
            try {
                if (this.closed) {
                    this.buffer = new byte[10000];
                    do {
                        this.count += rcvd;
                    } while ((rcvd = this.demux.read(this.buffer, 0, this.buffer.length, this.resph, timeout)) != -1);
                    this.buffer = null;
                } else {
                    if (this.buffer == null) {
                        this.buffer = new byte[10000];
                        this.offset = 0;
                        this.end = 0;
                    }
                    while ((rcvd = this.demux.read(this.buffer, this.end, this.buffer.length - this.end, this.resph, timeout)) >= 0) {
                        this.count += rcvd;
                        this.end += rcvd;
                        this.buffer = Util.resizeArray(this.buffer, this.end + 10000);
                    }
                }
            }
            catch (InterruptedIOException iioe) {
                this.interrupted = true;
                throw iioe;
            }
            catch (IOException ioe) {
                this.buffer = null;
            }
            this.interrupted = false;
        }
    }

    synchronized void dontTruncate() {
        this.dont_truncate = true;
    }

    static {
        try {
            dontTimeoutBody = Boolean.getBoolean("HTTPClient.dontTimeoutRespBody");
            if (dontTimeoutBody) {
                Log.write(4, "RspIS: disabling timeouts when reading response body");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

