/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DefaultSSLConnection;
import HTTPClient.ISSLConnection;
import HTTPClient.JSSESSLConnection;
import HTTPClient.TLSConnection;

public class SSLManager {
    private static ISSLConnection sslConnection = null;

    public static ISSLConnection getSSLConnection() {
        return SSLManager.getSSLConnection(true);
    }

    public static ISSLConnection getSSLConnection(boolean uniqueInstance) {
        if (uniqueInstance) {
            if (sslConnection != null) {
                return (ISSLConnection)sslConnection.clone();
            }
        } else {
            sslConnection = null;
        }
        if (Boolean.getBoolean("HTTPClient.sslUseTLS")) {
            try {
                sslConnection = new TLSConnection();
                return sslConnection;
            }
            catch (Throwable TLSNotAvailable) {
                TLSNotAvailable.printStackTrace();
            }
        }
        if (!Boolean.getBoolean("HTTPClient.sslDontUseJSSE")) {
            try {
                sslConnection = new JSSESSLConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (sslConnection == null) {
            sslConnection = new DefaultSSLConnection();
        }
        return (ISSLConnection)sslConnection.clone();
    }

    public static boolean isSSLAvailable() {
        if (sslConnection == null) {
            SSLManager.getSSLConnection();
        }
        return !(sslConnection instanceof DefaultSSLConnection);
    }
}

