/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.GXSmartCacheProvider;
import com.genexus.ICacheService;
import com.genexus.common.classes.AbstractGXFile;
import com.genexus.common.interfaces.IGXSmartCacheProvider;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXDirectory;
import com.genexus.util.GXFileCollection;
import com.genexus.xml.XMLReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class BaseProvider
implements IGXSmartCacheProvider {
    private static final ILogger logger = LogManager.getLogger(BaseProvider.class);
    volatile ConcurrentHashMap<String, Vector<String>> queryTables;
    protected Date startupDate;
    static Object syncLock = new Object();
    protected static final String FORCED_INVALIDATE = "SD";

    protected String normalizeKey(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            return key.toLowerCase();
        }
        return key;
    }

    protected void normalizeKey(List<String> keys) {
        ListIterator<String> iterator = keys.listIterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            iterator.set(this.normalizeKey(s));
        }
    }

    private void loadQueryTables() {
        if (this.isEnabled()) {
            String path = SpecificImplementation.Application.getModelContext().getHttpContext().getDefaultPath();
            String configurationDirectoryPath = path + File.separatorChar + "Metadata" + File.separatorChar + "TableAccess";
            ConcurrentHashMap<String, Vector<String>> qTables = new ConcurrentHashMap<String, Vector<String>>();
            this.loadQueryTablesPlatform(configurationDirectoryPath, qTables);
            this.startupDate = CommonUtil.now(false, false);
            this.queryTables = qTables;
        }
    }

    public void loadQueryTablesPlatform(String configurationDirectoryPath, ConcurrentHashMap<String, Vector<String>> qTables) {
        if (ApplicationContext.getInstance().isSpringBootApp()) {
            this.loadQueryTablesSpringBoot(configurationDirectoryPath, qTables);
        } else {
            this.loadQueryTablesNone(configurationDirectoryPath, qTables);
        }
    }

    public void loadQueryTablesNone(String configurationDirectoryPath, ConcurrentHashMap<String, Vector<String>> qTables) {
        GXDirectory configurationDirectory = new GXDirectory(configurationDirectoryPath);
        GXFileCollection files = configurationDirectory.getFiles();
        XMLReader reader = new XMLReader();
        boolean anyTable = false;
        for (int i = 1; i <= files.getItemCount(); ++i) {
            Vector<String> lst = new Vector<String>();
            lst.add(FORCED_INVALIDATE);
            AbstractGXFile xmlFile = files.item(i);
            reader.open(xmlFile.getAbsoluteName());
            short ok = reader.readType(1, "Table");
            while (ok == 1) {
                anyTable = true;
                lst.add(this.normalizeKey(reader.getAttributeByName("name")));
                ok = reader.readType(1, "Table");
            }
            reader.close();
            if (!anyTable) continue;
            qTables.put(this.normalizeKey(xmlFile.getNameNoExt()), lst);
        }
    }

    public void loadQueryTablesSpringBoot(String configurationDirectoryPath, ConcurrentHashMap<String, Vector<String>> qTables) {
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(configurationDirectoryPath + "/*.xml");
            XMLReader reader = new XMLReader();
            reader.setDocEncoding("UTF8");
            boolean anyTable = false;
            for (int i = 0; i < resources.length; ++i) {
                Vector<String> lst = new Vector<String>();
                lst.add(FORCED_INVALIDATE);
                String xmlContent = resources[i].getContentAsString(StandardCharsets.UTF_8);
                if (!xmlContent.startsWith("<")) {
                    xmlContent = xmlContent.substring(1);
                }
                reader.openFromString(xmlContent);
                short ok = reader.readType(1, "Table");
                while (ok == 1) {
                    anyTable = true;
                    lst.add(this.normalizeKey(reader.getAttributeByName("name")));
                    ok = reader.readType(1, "Table");
                }
                reader.close();
                if (!anyTable) continue;
                qTables.put(this.normalizeKey(resources[i].getFilename().substring(0, resources[i].getFilename().lastIndexOf("."))), lst);
            }
        }
        catch (IOException e) {
            logger.error("Error reading Table Access metadata", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentHashMap<String, Vector<String>> queryTables() {
        if (this.queryTables == null) {
            Object object = syncLock;
            synchronized (object) {
                if (this.queryTables == null) {
                    this.loadQueryTables();
                }
            }
        }
        return this.queryTables;
    }

    @Override
    public void invalidateAll() {
    }

    @Override
    public void invalidate(String item) {
    }

    @Override
    public void recordUpdates(int handle) {
    }

    @Override
    public Object CheckDataStatus(String queryId, Date dateLastModified, Date[] dateUpdated_arr) {
        return GXSmartCacheProvider.DataUpdateStatus.Unknown;
    }

    @Override
    public void discardUpdates(int handle) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ICacheService getUpdatedTables() {
        return null;
    }

    @Override
    public void setUpdated(String table, int handle) {
    }
}

