/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GXJarClassLoader
extends ClassLoader {
    private String source;
    private ZipFile zipFile = null;
    private boolean sourceIsJAR;
    private Hashtable<String, Long> classTimeStamps = new Hashtable();
    private Hashtable<String, Class> classes = new Hashtable();
    private long jarTimeStamp = 0L;
    private boolean autoReload;
    private int loadDepth;
    private static final ILogger logger = LogManager.getLogger(GXJarClassLoader.class);

    public GXJarClassLoader(String location, boolean autoReload) {
        this.source = location.trim().toLowerCase();
        this.autoReload = autoReload;
        this.sourceIsJAR = new File(this.source).isFile();
        this.loadDepth = 0;
        if (!autoReload) {
            this.openJar();
        }
        logger.debug("## GXJarClassLoader: Initialized (autoReloading: " + autoReload + ")");
    }

    public GXJarClassLoader getClassLoaderInstance() {
        if (!this.autoReload || !this.wasModified()) {
            return this;
        }
        logger.debug("## GXJarClassLoader: Changed classes detected ...");
        return new GXJarClassLoader(this.source, this.autoReload);
    }

    public boolean getAutoReload() {
        return this.autoReload;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class cls = this.loadClass(className, true);
        return cls;
    }

    private void openJar() {
        block4: {
            if (!this.sourceIsJAR) {
                return;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.source);
                    this.jarTimeStamp = new File(this.source).lastModified();
                }
                catch (IOException e) {
                    if (this.source.length() == 0) break block4;
                    System.err.println("Can't open JAR File: " + this.source + " : " + e.getMessage());
                }
            }
        }
        ++this.loadDepth;
    }

    private void closeJar() {
        if (!this.sourceIsJAR || this.zipFile == null) {
            return;
        }
        --this.loadDepth;
        if (this.loadDepth > 0) {
            return;
        }
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.zipFile = null;
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        try {
            Class<?> result = super.findSystemClass(className);
            return result;
        }
        catch (Throwable throwable) {
            byte[] classBytes;
            Class<?> result = this.classes.get(className);
            if (result != null) {
                return result;
            }
            if (this.autoReload) {
                this.openJar();
            }
            if ((classBytes = this.loadBytes(className)) == null) {
                this.closeJar();
                try {
                    result = this.getClass().getClassLoader().loadClass(className);
                    logger.debug("## GXJarClassLoader: Loading ParentClass: " + className);
                    return result;
                }
                catch (Throwable throwable2) {
                    throw new ClassNotFoundException(className);
                }
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                this.closeJar();
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            if (this.autoReload) {
                this.closeJar();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadBytes(String className) {
        byte[] result = null;
        className = className.replace('.', '/') + ".class";
        logger.debug("## GXJarClassLoader: Loading class: " + className + " [" + this.source + "]");
        BufferedInputStream bis = null;
        InputStream theStream = null;
        try {
            if (this.sourceIsJAR) {
                ZipEntry theEntry = this.zipFile.getEntry(className);
                if (theEntry != null) {
                    result = new byte[(int)theEntry.getSize()];
                    theStream = this.zipFile.getInputStream(theEntry);
                    new DataInputStream(new BufferedInputStream(theStream)).readFully(result);
                    theStream.close();
                }
            } else {
                File theFile = new File(this.source + File.separator + className);
                if (theFile.exists()) {
                    result = new byte[(int)theFile.length()];
                    theStream = new FileInputStream(theFile);
                    new DataInputStream(new BufferedInputStream(theStream)).readFully(result);
                    theStream.close();
                    this.classTimeStamps.put(className, new Long(theFile.lastModified()));
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (theStream != null) {
                    theStream.close();
                }
            }
            catch (IOException ioe) {
                logger.error("## GXJarClassLoader: Failed to close buffered input stream", ioe);
            }
        }
        return result;
    }

    public boolean wasModified() {
        if (this.sourceIsJAR) {
            return new File(this.source).lastModified() != this.jarTimeStamp;
        }
        Enumeration<String> enum1 = this.classTimeStamps.keys();
        while (enum1.hasMoreElements()) {
            String className = enum1.nextElement();
            if (new File(this.source + File.separator + className).lastModified() == this.classTimeStamps.get(className).longValue()) continue;
            return true;
        }
        return false;
    }
}

