/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.DateUtils;
import com.genexus.GXParameterPacker;
import com.genexus.GXSimpleCollection;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.util.Codecs;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.zip.GZIPInputStream;

public final class GXParameterUnpacker {
    private int count = 0;
    private byte[] buf;
    private int originalSize;

    public GXParameterUnpacker(byte[] buf) {
        this.originalSize = buf.length;
        this.reset(buf);
    }

    public int getOriginalSize() {
        return this.originalSize;
    }

    public GXParameterUnpacker() {
        this.buf = null;
    }

    public byte[] getUnreadBuff() {
        byte[] res = new byte[this.buf.length - this.count];
        System.arraycopy(this.buf, this.count, res, 0, res.length);
        return res;
    }

    public boolean eof() {
        return this.buf.length == this.count;
    }

    public int getCount() {
        return this.count;
    }

    public int getLength() {
        return this.buf.length;
    }

    public void resetFromString(String str) {
        try {
            this.reset(Codecs.base64Decode(str.getBytes()));
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public void reset(byte[] buf) {
        this.count = 0;
        if (GXParameterPacker.COMPRESS) {
            if (buf.length == 0) {
                this.buf = new byte[0];
            } else if (buf[0] == 0) {
                this.buf = new byte[buf.length - 1];
                System.arraycopy(buf, 1, this.buf, 0, buf.length - 1);
            } else {
                try {
                    this.buf = CommonUtil.readToByteArray(new GZIPInputStream(new ByteArrayInputStream(buf, 1, buf.length - 1)));
                }
                catch (IOException e) {
                    System.err.println("Error decompressing parameters");
                    throw new InternalError("Error decompressing parameters");
                }
            }
        } else {
            this.buf = buf;
        }
    }

    public final boolean readBoolean() {
        return this.buf[this.count++] == 1;
    }

    public final byte readByte() {
        return this.buf[this.count++];
    }

    public final byte[] readLongByteArray() {
        return this.readByteArray();
    }

    public final byte[] readByteArray() {
        byte[] data = new byte[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readByte();
        }
        return data;
    }

    public final void readByteArray(byte[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readByte();
        }
    }

    public final byte[][] readByteArray2() {
        byte[][] data = new byte[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readByte();
            }
        }
        return data;
    }

    public final void readByteArray2(byte[][] data) {
        this.readByteArray(data);
    }

    public final void readByteArray(byte[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readByte();
            }
        }
    }

    public final short readShort() {
        return (short)(((this.buf[this.count++] & 0xFF) << 8) + (this.buf[this.count++] & 0xFF));
    }

    public final short[] readShortArray() {
        short[] data = new short[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readShort();
        }
        return data;
    }

    public final void readShortArray(short[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readShort();
        }
    }

    public final short[][] readShortArray2() {
        short[][] data = new short[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readShort();
            }
        }
        return data;
    }

    public final void readShortArray2(short[][] data) {
        this.readShortArray(data);
    }

    public final void readShortArray(short[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readShort();
            }
        }
    }

    public final char readChar() {
        return (char)((this.buf[this.count++] << 8) + (this.buf[this.count++] & 0xFF));
    }

    public final char[] readCharArray() {
        char[] data = new char[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readChar();
        }
        return data;
    }

    public final void readCharArray(char[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readChar();
        }
    }

    public final char[][] readCharArray2() {
        char[][] data = new char[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readChar();
            }
        }
        return data;
    }

    public final void readCharArray2(char[][] data) {
        this.readCharArray(data);
    }

    public final void readCharArray(char[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readChar();
            }
        }
    }

    public final int readInt() {
        return ((this.buf[this.count++] & 0xFF) << 24) + ((this.buf[this.count++] & 0xFF) << 16) + ((this.buf[this.count++] & 0xFF) << 8) + (this.buf[this.count++] & 0xFF);
    }

    public final int[] readIntArray() {
        int[] data = new int[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readInt();
        }
        return data;
    }

    public final void readIntArray(int[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readInt();
        }
    }

    public final int[][] readIntArray2() {
        int[][] data = new int[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readInt();
            }
        }
        return data;
    }

    public final void readIntArray2(int[][] data) {
        this.readIntArray(data);
    }

    public final void readIntArray(int[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readInt();
            }
        }
    }

    public final long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long[] readLongArray() {
        long[] data = new long[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readLong();
        }
        return data;
    }

    public final void readLongArray(long[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readLong();
        }
    }

    public final long[][] readLongArray2() {
        long[][] data = new long[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readLong();
            }
        }
        return data;
    }

    public final void readLongArray2(long[][] data) {
        this.readLongArray(data);
    }

    public final void readLongArray(long[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readLong();
            }
        }
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float[] readFloatArray() {
        float[] data = new float[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readFloat();
        }
        return data;
    }

    public final void readFloatArray(float[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readFloat();
        }
    }

    public final float[][] readFloatArray2() {
        float[][] data = new float[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readFloat();
            }
        }
        return data;
    }

    public final void readFloatArray2(float[][] data) {
        this.readFloatArray(data);
    }

    public final void readFloatArray(float[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readFloat();
            }
        }
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double[] readDoubleArray() {
        double[] data = new double[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readDouble();
        }
        return data;
    }

    public final void readDoubleArray(double[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readDouble();
        }
    }

    public final double[][] readDoubleArray2() {
        double[][] data = new double[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readDouble();
            }
        }
        return data;
    }

    public final void readDoubleArray2(double[][] data) {
        this.readDoubleArray(data);
    }

    public final void readDoubleArray(double[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readDouble();
            }
        }
    }

    public final String readBlobfile() {
        String fileName = SpecificImplementation.Application.getDefaultPreferences().getBLOB_PATH() + SpecificImplementation.FileUtils.getTempFileName("tmp");
        byte[] data = new byte[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readByte();
        }
        try (FileOutputStream fos = new FileOutputStream(new File(fileName));){
            BufferedOutputStream destination = new BufferedOutputStream(fos);
            ((OutputStream)destination).write(data, 0, data.length);
            ((OutputStream)destination).close();
        }
        catch (IOException e) {
            System.err.println("Error reading " + fileName + " e " + e.getMessage());
        }
        return fileName;
    }

    public final String readString() {
        int length = this.readInt();
        StringBuffer sb = new StringBuffer(length);
        for (int i = length - 1; i >= 0; --i) {
            sb.append(this.readChar());
        }
        return sb.toString();
    }

    public final String[] readStringArray() {
        String[] data = new String[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readString();
        }
        return data;
    }

    public final void readStringArray(String[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readString();
        }
    }

    public final String[][] readStringArray2() {
        String[][] data = new String[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readString();
            }
        }
        return data;
    }

    public final void readStringArray2(String[][] data) {
        this.readStringArray(data);
    }

    public final void readStringArray(String[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readString();
            }
        }
    }

    public final Date readDate() {
        return DateUtils.getTimeAsDate(this.readLong());
    }

    public final Date[] readDateArray() {
        Date[] data = new Date[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readDate();
        }
        return data;
    }

    public final void readDateArray(Date[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readDate();
        }
    }

    public final Date[][] readDateArray2() {
        Date[][] data = new Date[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readDate();
            }
        }
        return data;
    }

    public final void readDateArray2(Date[][] data) {
        this.readDateArray(data);
    }

    public final void readDateArray(Date[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readDate();
            }
        }
    }

    public final BigDecimal readDecimal() {
        return new BigDecimal(this.readString());
    }

    public final BigDecimal[] readDecimalArray() {
        BigDecimal[] data = new BigDecimal[this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = this.readDecimal();
        }
        return data;
    }

    public final void readDecimalArray(BigDecimal[] data) {
        int length = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            data[i] = this.readDecimal();
        }
    }

    public final BigDecimal[][] readDecimalArray2() {
        BigDecimal[][] data = new BigDecimal[this.readInt()][this.readInt()];
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[0].length - 1; j >= 0; --j) {
                data[i][j] = this.readDecimal();
            }
        }
        return data;
    }

    public final void readDecimalArray2(BigDecimal[][] data) {
        this.readDecimalArray(data);
    }

    public final void readDecimalArray(BigDecimal[][] data) {
        int length = this.readInt();
        int length2 = this.readInt();
        for (int i = length - 1; i >= 0; --i) {
            for (int j = length2 - 1; j >= 0; --j) {
                data[i][j] = this.readDecimal();
            }
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.buf.length; ++i) {
            ret.append(this.buf[i]);
            ret.append(',');
        }
        ret.append("count: ");
        ret.append(this.count);
        ret.append("length: ");
        ret.append(this.buf.length);
        return ret.toString();
    }

    public void readGeneric(int[] types, Object[] data) {
        block13: for (int i = 0; i < data.length; ++i) {
            switch (types[i]) {
                case 1: {
                    ((byte[])data[i])[0] = this.readByte();
                    continue block13;
                }
                case 2: {
                    ((short[])data[i])[0] = this.readShort();
                    continue block13;
                }
                case 3: {
                    ((int[])data[i])[0] = this.readInt();
                    continue block13;
                }
                case 4: {
                    ((long[])data[i])[0] = this.readLong();
                    continue block13;
                }
                case 5: {
                    ((float[])data[i])[0] = this.readFloat();
                    continue block13;
                }
                case 6: {
                    ((double[])data[i])[0] = this.readDouble();
                    continue block13;
                }
                case 7: {
                    ((String[])data[i])[0] = this.readString();
                    continue block13;
                }
                case 8: {
                    ((Date[])data[i])[0] = this.readDate();
                    continue block13;
                }
                case 9: {
                    ((BigDecimal[])data[i])[0] = this.readDecimal();
                    continue block13;
                }
                case 10: {
                    ((boolean[])data[i])[0] = this.readBoolean();
                    continue block13;
                }
                case 11: {
                    ((String[])data[i])[0] = this.readBlobfile();
                    continue block13;
                }
                default: {
                    System.err.println("Unrecognized parm2 " + types[i]);
                }
            }
        }
    }

    public Object[] readGeneric2() {
        short size = this.readShort();
        Object[] data = new Object[size];
        block13: for (int i = 0; i < data.length; ++i) {
            byte type = this.readByte();
            switch (type) {
                case 1: {
                    data[i] = new Byte(this.readByte());
                    continue block13;
                }
                case 2: {
                    data[i] = new Short(this.readShort());
                    continue block13;
                }
                case 3: {
                    data[i] = new Integer(this.readInt());
                    continue block13;
                }
                case 4: {
                    data[i] = new Long(this.readLong());
                    continue block13;
                }
                case 5: {
                    data[i] = new Float(this.readFloat());
                    continue block13;
                }
                case 6: {
                    data[i] = new Double(this.readDouble());
                    continue block13;
                }
                case 7: {
                    data[i] = this.readString();
                    continue block13;
                }
                case 8: {
                    data[i] = this.readDate();
                    continue block13;
                }
                case 9: {
                    data[i] = this.readDecimal();
                    continue block13;
                }
                case 10: {
                    data[i] = new Boolean(this.readBoolean());
                    continue block13;
                }
                case 11: {
                    data[i] = this.readBlobfile();
                    continue block13;
                }
                default: {
                    System.err.println("Unrecognized parm2 " + type);
                }
            }
        }
        return data;
    }

    public final Object readObject() {
        try {
            ByteArrayInputStream tempStream = new ByteArrayInputStream(this.readByteArray());
            ObjectInputStream in = new ObjectInputStream(tempStream);
            Object ret = in.readObject();
            in.close();
            tempStream.close();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object --> " + e.getMessage());
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("Error reading object --> " + e2.getMessage());
        }
    }

    public final GXSimpleCollection readGxObjectCollection() {
        return (GXSimpleCollection)this.readObject();
    }
}

