/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.DecimalUtil;
import com.genexus.GXPicture;
import com.genexus.GXTypeConstants;
import com.genexus.Messages;
import com.genexus.PictureFormatter;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.util.GXSimpleDateFormat;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class LocalUtil {
    private static final int ANSI = 0;
    private static final int YMD = 1;
    private static final int MDY = 2;
    private static final int DMY = 3;
    private static final int MDY4 = 4;
    private static final int DMY4 = 5;
    private static final int Y4MD = 6;
    private static final String GXLANG_SPA = "spa";
    private static final String GXLANG_ENG = "eng";
    private static final String GXLANG_ITA = "ita";
    private static final String GXLANG_POR = "por";
    private static final String GXLANG_CN = "chs";
    private static final String GXLANG_CT = "cht";
    private static final String GXLANG_TW = "tw";
    private static final String GXLANG_JAP = "jap";
    private static final String JLANG_SPA = "es";
    private static final String JLANG_ENG = "en";
    private static final String JLANG_ITA = "it";
    private static final String JLANG_POR = "pt";
    private static final String JLANG_CN = "cn";
    private static final String JLANG_CT = "ct";
    private static final String JLANG_TW = "tw";
    private static final String JLANG_JP = "ja";
    private static Hashtable<String, LocalUtil> listLocalUtil = new Hashtable();
    private GXSimpleDateFormat ttoc_2_df10;
    private GXSimpleDateFormat ttoc_2_df8;
    private GXSimpleDateFormat ttoc_1_df;
    private GXSimpleDateFormat ttoc_3_5_df;
    private GXSimpleDateFormat ttoc_3_2_df;
    private GXSimpleDateFormat ttoc_3_8_df;
    private GXSimpleDateFormat ttoc_3_12_df;
    private GXSimpleDateFormat dtoc_df;
    private GXSimpleDateFormat millisecond_df;
    private GXSimpleDateFormat second_df;
    private GXSimpleDateFormat minute_df;
    private GXSimpleDateFormat hour_df;
    private GXSimpleDateFormat day_df;
    private GXSimpleDateFormat month_df;
    private GXSimpleDateFormat year_df;
    private GXSimpleDateFormat dateOk_df;
    private TimeZone defaultTimeZone;
    private Locale defaultLocale;
    private GregorianCalendar ymdhmstot_gc;
    private DecimalFormat str_df;
    private Calendar ddiff_cal1;
    private Calendar ddiff_cal2;
    private Locale appLocale;
    private GregorianCalendar appGregorianCalendar;
    public char decimalPoint;
    private String dateFormat;
    private String timeFormat;
    public int firstYear2K;
    private String language;
    private Locale locale;
    private Messages msgs;
    private char dateSeparator;
    private boolean startsYearDate = false;
    public String _dateFormat;
    public String _timeFormat;
    public String _language;

    public static LocalUtil getLocalUtil(char decimalPoint, String dateFormat, String timeFormat, int firstYear2K, String language) {
        String key = LocalUtil.getKey(decimalPoint, dateFormat, timeFormat, firstYear2K, language);
        LocalUtil ret = listLocalUtil.get(key);
        if (ret == null) {
            ret = new LocalUtil(decimalPoint, dateFormat, timeFormat, firstYear2K, language);
            listLocalUtil.put(key, ret);
        }
        return ret;
    }

    public LocalUtil(char decimalPoint, String dateFormat, String timeFormat, int firstYear2K, String language) {
        this.decimalPoint = decimalPoint;
        this._language = language;
        this.language = this.getLANGUAGE(language.toLowerCase());
        this._dateFormat = dateFormat;
        this.dateFormat = LocalUtil.mapCTODFormatToPattern(this.mapDateFormat(dateFormat), "/", false);
        if (this.dateFormat.substring(0, 2).equalsIgnoreCase("YY")) {
            this.startsYearDate = true;
        }
        this._timeFormat = timeFormat;
        this.timeFormat = this.getTIME_FMT(timeFormat);
        this.firstYear2K = firstYear2K;
        this.initialize();
    }

    public static void endLocalUtil() {
        listLocalUtil = null;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public static String getKey(char decimalPoint, String dateFormat, String timeFormat, int firstYear2K, String language) {
        return dateFormat + timeFormat + language + decimalPoint + firstYear2K;
    }

    public Messages getMessages() {
        return this.msgs;
    }

    private String getLANGUAGE(String language) {
        if (language.equalsIgnoreCase(GXLANG_SPA)) {
            return JLANG_SPA;
        }
        if (language.equalsIgnoreCase(GXLANG_ITA)) {
            return JLANG_ITA;
        }
        if (language.equalsIgnoreCase(GXLANG_POR)) {
            return JLANG_POR;
        }
        if (language.equalsIgnoreCase(GXLANG_CN)) {
            return JLANG_CN;
        }
        if (language.equalsIgnoreCase("tw")) {
            return "tw";
        }
        if (language.equalsIgnoreCase(GXLANG_CT)) {
            return JLANG_CT;
        }
        if (language.equalsIgnoreCase(GXLANG_JAP)) {
            return JLANG_JP;
        }
        if (language.equalsIgnoreCase(GXLANG_ENG)) {
            return JLANG_ENG;
        }
        String lng = SpecificImplementation.LocalUtil.getLanguage(language);
        if (lng != null && lng.length() >= 2) {
            return lng.toLowerCase().substring(0, 2);
        }
        return language;
    }

    public String getLanguageID(String lang) {
        if (CommonUtil.rtrim(lang).equals("")) {
            lang = this.language;
        }
        return this.getLANGUAGE(lang);
    }

    private String getTIME_FMT(String aux) {
        if (aux.equals("12") || aux.equals("") && this.language.equals(JLANG_ENG)) {
            return "hh:mm:ss a";
        }
        return "HH:mm:ss";
    }

    public int mapTimeFormat(String dateFmt) {
        if (dateFmt.equals("12")) {
            return 1;
        }
        return 0;
    }

    public int mapDateTimeFormat(String dateFmt) {
        if (dateFmt.equalsIgnoreCase("ANSI")) {
            return 0;
        }
        if (dateFmt.equalsIgnoreCase("MDY") || dateFmt.equalsIgnoreCase("MDY4")) {
            return 2;
        }
        if (dateFmt.equalsIgnoreCase("DMY") || dateFmt.equalsIgnoreCase("DMY4")) {
            return 3;
        }
        if (dateFmt.equalsIgnoreCase("YMD") || dateFmt.equalsIgnoreCase("Y4MD")) {
            return 1;
        }
        return 2;
    }

    public int mapDateFormat(String dateFmt) {
        if (dateFmt.equalsIgnoreCase("ANSI")) {
            return 0;
        }
        if (dateFmt.equalsIgnoreCase("MDY")) {
            return 2;
        }
        if (dateFmt.equalsIgnoreCase("DMY")) {
            return 3;
        }
        if (dateFmt.equalsIgnoreCase("MDY4")) {
            return 4;
        }
        if (dateFmt.equalsIgnoreCase("DMY4")) {
            return 5;
        }
        if (dateFmt.equalsIgnoreCase("YMD")) {
            return 1;
        }
        if (dateFmt.equalsIgnoreCase("Y4MD")) {
            return 6;
        }
        return 5;
    }

    private static String mapCTODFormatToPattern(int format) {
        switch (format) {
            case 2: {
                return "MM/dd/yy";
            }
            case 0: {
                return "yyyy-MM-dd";
            }
            case 3: {
                return "dd/MM/yy";
            }
            case 4: {
                return "MM/dd/yyyy";
            }
            case 5: {
                return "dd/MM/yyyy";
            }
            case 1: {
                return "yy/MM/dd";
            }
            case 6: {
                return "yyyy/MM/dd";
            }
        }
        throw new InternalError("Bad Format for DTOC " + format);
    }

    private static String mapCTODFormatToPattern(int format, String dSep, boolean longYear) {
        switch (format) {
            case 3: {
                return "dd" + dSep + "MM" + dSep + "yy" + (longYear ? "yy" : "");
            }
            case 2: {
                return "MM" + dSep + "dd" + dSep + "yy" + (longYear ? "yy" : "");
            }
            case 1: {
                return "yy" + (longYear ? "yy" : "") + dSep + "MM" + dSep + "dd";
            }
            case 5: {
                return "dd" + dSep + "MM" + dSep + "yyyy";
            }
            case 4: {
                return "MM" + dSep + "dd" + dSep + "yyyy";
            }
            case 6: {
                return "yyyy" + dSep + "MM" + dSep + "dd";
            }
            case 0: {
                return "yy" + (longYear ? "yy" : "") + dSep + "MM" + dSep + "dd";
            }
        }
        throw new InternalError("Bad Format for DTOC " + format);
    }

    private static String getNullDateFormat(String date, int gxformat) {
        String separator = LocalUtil.getSeparator(date);
        String format = !separator.isEmpty() ? LocalUtil.mapCTODFormatToPattern(gxformat, separator, LocalUtil.hasLongYear(date)) : LocalUtil.mapCTODFormatToPattern(gxformat);
        StringBuffer out = new StringBuffer();
        int len = format.length();
        for (int i = 0; i < len; ++i) {
            out.append(format.charAt(i) == '/' ? (char)'/' : ' ');
        }
        return out.toString();
    }

    private void initialize() {
        String country = this.decimalPoint == '.' ? "US" : "ES";
        this.defaultTimeZone = TimeZone.getDefault();
        this.ttoc_2_df10 = new GXSimpleDateFormat(this.dateFormat.substring(0, 8) + "yy");
        this.ttoc_2_df10.setTimeZone(this.defaultTimeZone);
        this.ttoc_2_df8 = new GXSimpleDateFormat(this.dateFormat.substring(0, 8));
        this.ttoc_2_df8.setTimeZone(this.defaultTimeZone);
        this.ttoc_1_df = new GXSimpleDateFormat(this.dateFormat + ' ' + this.timeFormat);
        this.ttoc_1_df.setTimeZone(this.defaultTimeZone);
        this.ttoc_3_5_df = new GXSimpleDateFormat("HH:mm");
        this.ttoc_3_5_df.setTimeZone(this.defaultTimeZone);
        this.ttoc_3_2_df = new GXSimpleDateFormat("HH");
        this.ttoc_3_2_df.setTimeZone(this.defaultTimeZone);
        this.ttoc_3_8_df = new GXSimpleDateFormat("HH:mm:ss");
        this.ttoc_3_8_df.setTimeZone(this.defaultTimeZone);
        this.ttoc_3_12_df = new GXSimpleDateFormat("HH:mm:ss.SSS");
        this.ttoc_3_12_df.setTimeZone(this.defaultTimeZone);
        this.defaultLocale = Locale.getDefault();
        this.ymdhmstot_gc = new GregorianCalendar(this.defaultLocale);
        this.ymdhmstot_gc.setTimeZone(TimeZone.getDefault());
        this.appLocale = new Locale(this.language, country);
        this.appGregorianCalendar = new GregorianCalendar(this.appLocale);
        this.appGregorianCalendar.setTimeZone(this.defaultTimeZone);
        this.str_df = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        this.dtoc_df = new GXSimpleDateFormat(this.dateFormat);
        this.dtoc_df.setTimeZone(this.defaultTimeZone);
        this.ddiff_cal1 = Calendar.getInstance(this.defaultLocale);
        this.ddiff_cal1.setTimeZone(this.defaultTimeZone);
        this.ddiff_cal2 = Calendar.getInstance(this.defaultLocale);
        this.ddiff_cal2.setTimeZone(this.defaultTimeZone);
        this.day_df = new GXSimpleDateFormat("d");
        this.day_df.setTimeZone(this.defaultTimeZone);
        this.year_df = new GXSimpleDateFormat("yyyyy");
        this.year_df.setTimeZone(this.defaultTimeZone);
        this.month_df = new GXSimpleDateFormat("M");
        this.month_df.setTimeZone(this.defaultTimeZone);
        this.hour_df = new GXSimpleDateFormat("k");
        this.hour_df.setTimeZone(this.defaultTimeZone);
        this.minute_df = new GXSimpleDateFormat("m");
        this.minute_df.setTimeZone(this.defaultTimeZone);
        this.second_df = new GXSimpleDateFormat("s");
        this.second_df.setTimeZone(this.defaultTimeZone);
        this.millisecond_df = new GXSimpleDateFormat("S");
        this.millisecond_df.setTimeZone(this.defaultTimeZone);
        this.dateOk_df = new GXSimpleDateFormat(this.dateFormat.length() < 10 ? this.dateFormat + "yy" : this.dateFormat);
        this.dateOk_df.setTimeZone(this.defaultTimeZone);
        String resourceName = "messages." + this._language.toLowerCase() + ".txt";
        if (SpecificImplementation.Application.getModelContextPackageClass() != null) {
            this.msgs = Messages.getMessages(resourceName, this.getLocale());
        }
        this.dateSeparator = this.dateFormat.charAt(2);
    }

    private String getCountry() {
        return this.decimalPoint == '.' ? "US" : "ES";
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.decimalPoint == ',' ? new Locale(JLANG_SPA, this.getCountry()) : new Locale(JLANG_ENG, this.getCountry());
        }
        return this.locale;
    }

    private Locale getMessagesLocale() {
        if (this.language.equals(JLANG_ENG)) {
            return new Locale(this.language, "US");
        }
        if (this.language.equals(JLANG_CN)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if (this.language.equals("tw")) {
            return Locale.TRADITIONAL_CHINESE;
        }
        return new Locale(this.language, this.language.toUpperCase());
    }

    public final String ttoc(Date d1) {
        Date d = CommonUtil.ymdhmsToT_noYL(2001, 1, 1, 0, 30, 0);
        if (d.equals(CommonUtil.nullDate())) {
            return this.justSeparators(this.ttoc_1_df.toPattern());
        }
        return this.ttoc_1_df.gxFormat(d).trim();
    }

    private String justSeparators(String in) {
        int len = in.length();
        StringBuffer out = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char val = in.charAt(i);
            if (!(LocalUtil.getBLANK_EMPTY_DATE() || val != '-' && val != '/' && val != ':')) {
                out.append(val);
                continue;
            }
            out.append(' ');
        }
        return out.toString();
    }

    static boolean getBLANK_EMPTY_DATE() {
        return SpecificImplementation.LocalUtil.IsBlankEmptyDate();
    }

    protected String ttoc(Date d, int M) {
        switch (M) {
            case 0: {
                return "";
            }
            case 8: {
                if (d.equals(CommonUtil.nullDate())) {
                    return this.justSeparators(this.ttoc_2_df8.toPattern());
                }
                return this.ttoc_2_df8.gxFormat(d);
            }
        }
        if (d.equals(CommonUtil.nullDate())) {
            return this.justSeparators(this.ttoc_2_df10.toPattern());
        }
        return this.ttoc_2_df10.gxFormat(d);
    }

    public String getDateFormatPattern(int dateLength, int timeLength, int ampm, int format, String dSep, String tSep, String dtSep) {
        String dateFormatText = LocalUtil.mapCTODFormatToPattern(format, dSep, dateLength > 8);
        String timeFormatText = this.getTimeFormatPattern(timeLength, ampm, format, tSep);
        return (dateLength > 0 ? dateFormatText : "") + (dateLength > 0 && timeLength > 0 ? dtSep : "") + (timeLength > 0 ? timeFormatText : "");
    }

    private String getTimeFormatPattern(int timeLength, int ampm, int format, String tSep) {
        String formatHour = ampm == 0 ? "HH" : "hh";
        String formatMin = "mm";
        String formatSec = "ss";
        String formatMil = "SSS";
        String milSep = ".";
        String formatAMPM = ampm == 0 ? "" : " a";
        String timeFormatText = formatHour;
        if (timeLength > 2) {
            timeFormatText = timeFormatText + tSep + formatMin;
        }
        if (timeLength > 5) {
            timeFormatText = timeFormatText + tSep + formatSec;
        }
        if (timeLength > 8) {
            timeFormatText = timeFormatText + milSep + formatMil;
        }
        timeFormatText = timeFormatText + formatAMPM;
        return timeFormatText;
    }

    static String formatEmptyDate(String pic) {
        String emptyDT = pic.replaceAll("d|M|y", " ");
        if (LocalUtil.getBLANK_EMPTY_DATE()) {
            emptyDT = (emptyDT = emptyDT.replaceAll("/|:|m|s|S|\\.", " ")).indexOf(97) == -1 ? emptyDT.replaceAll("h|H", " ") : emptyDT.replaceAll("hh|HH|a", "  ");
        } else if ((emptyDT = emptyDT.replaceAll("m|s|S", "0")).indexOf(97) == -1) {
            emptyDT = emptyDT.replaceAll("h|H", "0");
        } else {
            emptyDT = emptyDT.replaceAll("hh|HH", "12");
            emptyDT = emptyDT.replaceAll("a", "AM");
        }
        return emptyDT;
    }

    public String ttoc(Date d, int dateLength, int timeLength, int ampm, int format, String dSep, String tSep, String dtSep) {
        String sep;
        String dFormatText = LocalUtil.mapCTODFormatToPattern(format, dSep, dateLength > 8);
        String timeFormatText = this.getTimeFormatPattern(timeLength, ampm, format, tSep);
        GXSimpleDateFormat dateFormat = new GXSimpleDateFormat(dFormatText);
        GXSimpleDateFormat timeFormat = new GXSimpleDateFormat(timeFormatText);
        String string = sep = dateLength > 0 && timeLength > 0 ? dtSep : "";
        if (d.equals(CommonUtil.nullDate())) {
            if (dateLength == 0) {
                dFormatText = "";
            }
            return LocalUtil.formatEmptyDate(dFormatText + sep + timeFormatText);
        }
        return (dateLength > 0 ? dateFormat.gxFormat(d) : "") + (dateLength > 0 && timeLength > 0 ? dtSep : "") + (timeLength > 0 ? timeFormat.gxFormat(d) : "");
    }

    public String ttoc(Date d, int M, int N) {
        if (M == 0 && N == 0) {
            M = 10;
            N = 8;
        }
        String day = this.ttoc(d, M);
        switch (N) {
            case 0: {
                return CommonUtil.ltrim(day);
            }
            case 2: {
                if (d.equals(CommonUtil.nullDate())) {
                    return CommonUtil.ltrim(day + ' ' + this.justSeparators(this.ttoc_3_2_df.toPattern()));
                }
                return CommonUtil.ltrim(day + ' ' + this.ttoc_3_2_df.gxFormat(d));
            }
            case 5: {
                if (d.equals(CommonUtil.nullDate())) {
                    return CommonUtil.ltrim(day + ' ' + this.justSeparators(this.ttoc_3_5_df.toPattern()));
                }
                return CommonUtil.ltrim(day + ' ' + this.ttoc_3_5_df.gxFormat(d));
            }
            case 12: {
                if (d.equals(CommonUtil.nullDate())) {
                    return CommonUtil.ltrim(day + ' ' + this.justSeparators(this.ttoc_3_12_df.toPattern()));
                }
                return CommonUtil.ltrim(day + ' ' + this.ttoc_3_12_df.gxFormat(d));
            }
        }
        if (d.equals(CommonUtil.nullDate())) {
            return CommonUtil.ltrim(day + ' ' + this.justSeparators(this.ttoc_3_8_df.toPattern()));
        }
        return CommonUtil.ltrim(day + ' ' + this.ttoc_3_8_df.gxFormat(d));
    }

    public String getYear(String year) {
        if (year.length() == 3 || year.length() == 1) {
            year = year + '0';
        } else if (year.length() == 0) {
            year = "90";
        }
        year = CommonUtil.val(year) < (double)this.firstYear2K ? "20" + year : "19" + year;
        return year;
    }

    public String getDate(String dateIn) {
        String dateFormat = this.dateFormat.length() < 10 ? this.dateFormat + "yy" : this.dateFormat;
        int len = dateIn.length();
        String da = CommonUtil.trimSpaces(dateIn);
        if (len == 10 && da.length() == 8) {
            dateIn = da;
            len = 8;
        }
        if (da.equals("--") || da.equals("//")) {
            char c = da.charAt(0);
            dateIn = "01" + c + "01" + c + "90";
        }
        if (len == 8) {
            String year = CommonUtil.right(dateIn, 2);
            year = CommonUtil.val(year) < (double)this.firstYear2K ? "20" + year : "19" + year;
            dateIn = CommonUtil.left(dateIn, 6) + year;
        } else if (len == 10 && dateFormat.length() == 8) {
            dateIn = CommonUtil.left(dateIn, 6) + CommonUtil.right(dateIn, 2);
        }
        return dateIn;
    }

    public boolean dateOk(String dateIn) {
        String date = CommonUtil.trimSpaces(dateIn);
        if (dateIn.length() > 8 && dateIn.charAt(8) == ' ' && !CommonUtil.isTime(dateIn.substring(9))) {
            return false;
        }
        if (date.equals("--") || date.equals("//")) {
            return true;
        }
        int len = dateIn.length();
        if (len != 10 && len != 8) {
            if (date.length() < 10 && date.length() != 8) {
                return false;
            }
            dateIn = CommonUtil.trimSpaces(CommonUtil.left(date, 10 < date.length() ? 10 : date.length()));
            len = dateIn.length();
            if (len != 10 && len != 8) {
                return false;
            }
        }
        try {
            dateIn = this.getDate(dateIn);
            Date d = this.dateOk_df.parse(dateIn);
            String s = this.dateOk_df.gxFormat(d);
            return s.equals(dateIn);
        }
        catch (ParseException f) {
            return false;
        }
    }

    private boolean isDateTimeValue(String value) {
        return value.indexOf(58) > 0 || value.toUpperCase().endsWith("M") || value.length() == 2;
    }

    public int vcdate(String date, int f) {
        if (this.isDateTimeValue(date)) {
            return this.vcdate_time(date, f);
        }
        try {
            String aux = CommonUtil.trimSpaces(date);
            if (aux.equals("--") || aux.equals("//") || aux.equals("") || aux.equals("00")) {
                return 1;
            }
            GXSimpleDateFormat df = new GXSimpleDateFormat(this.dateFormat);
            df.setTimeZone(TimeZone.getDefault());
            df.setLenient(false);
            df.parse(date);
            return 1;
        }
        catch (InternalError e) {
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int vcdate_time(String date, int f) {
        return this.vcdtime(date, 0, f);
    }

    private static String fixUnparseableEmptyTime(String value) {
        if ((value = value.toLowerCase()).endsWith(" 00 am") || value.endsWith(" 00:00 am") || value.endsWith(" 00:00 pm") || value.endsWith(" 00 pm") || value.endsWith("00:00:00 am") || value.endsWith("00:00:00 pm") || value.endsWith("00:00:00.000 am") || value.endsWith("00:00:00.000 pm")) {
            return value.substring(0, value.length() - 3);
        }
        return value;
    }

    private static boolean isNullTimeValue(String value, boolean isAMPM) {
        if (isAMPM) {
            return value.equals("12 ") || value.equals("12:00 ") || value.equals("12:00:00 ") || value.equals("12 AM") || value.equals("12:00 AM") || value.equals("12:00:00 AM") || value.equals("12:00:00.000 AM");
        }
        return value.equals("00 ") || value.equals("00:00 ") || value.equals("00:00:00 ") || value.equals("00:00:00.000 ");
    }

    public static void main(String[] arg) {
        System.out.println(LocalUtil.isNullDateTime("  /  /   12 AM", 2, 1));
        System.out.println(LocalUtil.isNullDateTime("  /  /   12:00 AM", 2, 1));
        System.out.println(LocalUtil.isNullDateTime("  /  /   12:00:00 AM", 2, 1));
        System.out.println("->");
        System.out.println(LocalUtil.isNullDateTime("  /  /   12:00:00 AM", 2, 0));
        System.out.println(LocalUtil.isNullDateTime("  /  /   00", 2, 0));
        System.out.println(LocalUtil.isNullDateTime("  /  /   00:00", 2, 0));
        System.out.println(LocalUtil.isNullDateTime("  /  /   00:00:00", 2, 0));
    }

    private static boolean isNullDateTime(String date, int format, int am) {
        String nullFormat = LocalUtil.getNullDateFormat(date, format);
        if (date.startsWith(nullFormat) && date.length() > nullFormat.length()) {
            String timeValue = date.substring(nullFormat.length() - 1).trim();
            return LocalUtil.isNullTimeValue(timeValue, am > 0);
        }
        return false;
    }

    public int vcdtime(String date, int format, int am) {
        if (LocalUtil.isNullDateTime(date, format, am)) {
            return 1;
        }
        if (this.ctotex(date, format) == null) {
            return 0;
        }
        return 1;
    }

    public Date ymdtod(int year, int month, int day) {
        return this.ymdhmsToT(year, month, day, 0, 0, 0);
    }

    public Date ymdhmsToT(int year, int month, int day, int hour, int minute, int second) {
        return this.ymdhmsToT(year, month, day, hour, minute, second, 0);
    }

    public Date ymdhmsToT(int year, int month, int day, int hour, int minute, int second, int milliseconds) {
        if (!(year >= 100 || year == 0 && month == 0 && day == 0 || year == 1 && month == 1 && day == 1)) {
            year += year > this.firstYear2K ? 1900 : 2000;
        }
        return CommonUtil.ymdhmsToT_noYL(year, month, day, hour, minute, second, milliseconds);
    }

    public Date ymdhmsToT(int year, int month, int day, int hour) {
        return this.ymdhmsToT(year, month, day, hour, 0, 0);
    }

    public Date ymdhmsToT(int year, int month, int day) {
        return this.ymdhmsToT(year, month, day, 0, 0, 0);
    }

    public Date ymdhmsToT(int year, int month, int day, int hour, int minute) {
        return this.ymdhmsToT(year, month, day, hour, minute, 0);
    }

    public String dtoc(Date date, int formatId, String separator) {
        String format = LocalUtil.mapCTODFormatToPattern(formatId);
        format = separator.equals("-") ? format.replace('/', '-') : format.replace('-', '/');
        if (separator.equals("") && formatId == 0) {
            format = "yyyyMMdd";
        }
        GXSimpleDateFormat dateFormat = new GXSimpleDateFormat(format);
        dateFormat.setTimeZone(this.defaultTimeZone);
        if (date.equals(CommonUtil.nullDate())) {
            return this.justSeparators(dateFormat.toPattern());
        }
        return dateFormat.gxFormat(date);
    }

    public Date parseDateParm(String valueString) {
        if (valueString.trim().length() == 0 || !Character.isDigit(valueString.trim().charAt(0))) {
            return CommonUtil.nullDate();
        }
        if (valueString.indexOf(47) != -1) {
            return this.ctod(valueString);
        }
        return CommonUtil.ymdhmsToT_noYL((int)CommonUtil.val(valueString.substring(0, 4)), (int)CommonUtil.val(valueString.substring(4, 6)), (int)CommonUtil.val(valueString.substring(6, 8)), 0, 0, 0);
    }

    public Date parseDTimeParm(String valueString) {
        if (valueString.trim().length() == 0) {
            return CommonUtil.nullDate();
        }
        if (valueString.indexOf(47) != -1) {
            return this.ctod(valueString);
        }
        int msVal = valueString.trim().length() > 14 ? (int)CommonUtil.val(valueString.substring(14, 17)) : 0;
        return CommonUtil.ymdhmsToT_noYL((int)CommonUtil.val(valueString.substring(0, 4)), (int)CommonUtil.val(valueString.substring(4, 6)), (int)CommonUtil.val(valueString.substring(6, 8)), (int)CommonUtil.val(valueString.substring(8, 10)), (int)CommonUtil.val(valueString.substring(10, 12)), (int)CommonUtil.val(valueString.substring(12, 14)), msVal);
    }

    public String dtoc(Date date) {
        if (date.equals(CommonUtil.nullDate())) {
            return this.justSeparators(this.dtoc_df.toPattern());
        }
        return this.dtoc_df.gxFormat(date);
    }

    public String cdow(Date date) {
        Locale l = new Locale(this.language, this.getCountry());
        GXSimpleDateFormat df = new GXSimpleDateFormat(SpecificImplementation.cdowMask, l);
        df.setTimeZone(TimeZone.getDefault());
        return df.gxFormat(date);
    }

    public String cdow(Date date, String language) {
        Locale l = new Locale(this.getLanguageID(language), this.getCountry());
        GXSimpleDateFormat df = new GXSimpleDateFormat(SpecificImplementation.cdowMask, l);
        df.setTimeZone(TimeZone.getDefault());
        StringBuffer sb = new StringBuffer(df.gxFormat(date));
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public String cmonth(Date date) {
        return this.cmonth(date, this.language);
    }

    public String cmonth(Date date, String language) {
        Locale l = new Locale(this.getLanguageID(language), this.getCountry());
        GXSimpleDateFormat df = new GXSimpleDateFormat(SpecificImplementation.cdowMask.replace("E", "M"), l);
        df.setTimeZone(TimeZone.getDefault());
        StringBuffer sb = new StringBuffer(df.gxFormat(date));
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public Date ctod(String date, int format) {
        if (PictureFormatter.isDateEmpty(date)) {
            return CommonUtil.nullDate();
        }
        String separator = LocalUtil.getSeparator(date);
        if (!separator.isEmpty()) {
            String pattern = LocalUtil.mapCTODFormatToPattern(format, separator, LocalUtil.hasLongYear(date));
            GXSimpleDateFormat df = new GXSimpleDateFormat(pattern);
            df.setTimeZone(TimeZone.getDefault());
            try {
                return this.applyYearLimit(df.parse(date), pattern);
            }
            catch (ParseException e) {
                return CommonUtil.nullDate();
            }
        }
        return CommonUtil.nullDate();
    }

    public Date ctod(String date) {
        return this.ctot(date);
    }

    public Date ctot(String date, int format) {
        Date result = this.ctotex(date, format);
        if (result != null) {
            return result;
        }
        return CommonUtil.nullDate();
    }

    private static String getSeparator(String date) {
        if (date.indexOf(45) >= 0) {
            return "-";
        }
        if (date.indexOf(47) >= 0) {
            return "/";
        }
        return "";
    }

    private static boolean hasLongYear(String date) {
        int blankPos = date.indexOf(32);
        if (blankPos > 0) {
            return blankPos == 10;
        }
        if (!LocalUtil.getBLANK_EMPTY_DATE() && date.indexOf("    ") != -1) {
            return true;
        }
        return date.length() == 10 || date.length() == 19 || date.length() == 23;
    }

    public Date ctotex(String date, int format) {
        if (PictureFormatter.isDateEmpty(date)) {
            return CommonUtil.nullDate();
        }
        String patternDate = "";
        if (date.indexOf(45) >= 0 || date.indexOf(47) >= 0) {
            String separator = LocalUtil.getSeparator(date);
            if (!separator.isEmpty()) {
                patternDate = LocalUtil.mapCTODFormatToPattern(format, separator, LocalUtil.hasLongYear(date));
            } else {
                return null;
            }
        }
        String patternTime = "";
        if (date.length() > patternDate.length()) {
            if (patternDate.length() > 0) {
                date = date.replace('T', ' ');
                patternTime = " " + this.getDateTimePicture(date.substring(date.indexOf(32) + 1));
                if (patternTime.indexOf(45) >= 0 || patternTime.indexOf(47) >= 0) {
                    patternDate = "";
                }
            } else {
                patternTime = this.getDateTimePicture(date);
            }
        }
        GXSimpleDateFormat df = new GXSimpleDateFormat(patternDate + patternTime);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        try {
            Date dt = df.parse(date);
            if (patternDate.isEmpty()) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(dt);
                calendar.set(1, 1);
                dt = calendar.getTime();
            }
            return this.applyYearLimit(dt, patternDate + patternTime);
        }
        catch (ParseException e) {
            if (!LocalUtil.isNullTimeValue(date.substring(date.indexOf(32) + 1), false)) {
                return null;
            }
            df.setLenient(true);
            try {
                return this.applyYearLimit(df.parse(date), patternDate + patternTime);
            }
            catch (ParseException ex) {
                return null;
            }
        }
    }

    public Date ctot(String date) {
        if (PictureFormatter.isDateEmpty(date)) {
            return CommonUtil.nullDate();
        }
        try {
            if (this.isISO8601(date)) {
                return LocalUtil.getISO8601Date(date);
            }
            if (this.isGXJsonDate(date)) {
                return LocalUtil.getISO8601Date(date);
            }
            String picture = this.getDateTimePicture(date);
            GXSimpleDateFormat df = new GXSimpleDateFormat(picture);
            df.setTimeZone(this.defaultTimeZone);
            df.setLenient(false);
            return this.applyYearLimit(df.parse(date), picture);
        }
        catch (ParseException e) {
            return CommonUtil.nullDate();
        }
    }

    boolean isGXJsonDate(String date) {
        return date.length() == 19 && date.charAt(4) == '/' && date.charAt(7) == '/' && date.charAt(13) == ':' && date.charAt(16) == ':';
    }

    boolean isISO8601(String date) {
        if (date.indexOf("T") != -1) {
            return true;
        }
        return date.length() == 10 && date.charAt(4) == '-' && date.charAt(7) == '-' && date.length() == 10;
    }

    static Date getISO8601Date(String date) {
        if (date.length() > 10) {
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int day = Integer.parseInt(date.substring(8, 10));
            int hour = Integer.parseInt(date.substring(11, 13));
            int minute = Integer.parseInt(date.substring(14, 16));
            int seconds = Integer.parseInt(date.substring(17, 19));
            int milliseconds = 0;
            if (date.length() > 20) {
                milliseconds = Integer.parseInt(date.substring(20, 23));
                return CommonUtil.ymdhmsToT_noYL(year, month, day, hour, minute, seconds, milliseconds);
            }
            return CommonUtil.ymdhmsToT_noYL(year, month, day, hour, minute, seconds);
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        return CommonUtil.ymdhmsToT_noYL(year, month, day, 0, 0, 0);
    }

    public String yearTo4Digits(String date, String[] picture, Date dateSet, int type) {
        if (type == GXTypeConstants.DATETIME) {
            if (!PictureFormatter.isDateInPicture(picture[0])) {
                return date;
            }
            if (picture[0].length() > 8 && picture[0].charAt(8) == '9') {
                return date;
            }
        } else if (picture[0].length() > 8) {
            return date;
        }
        String year = "00";
        if (this.startsYearDate) {
            if (date.length() >= 2) {
                year = date.substring(0, 2);
            }
        } else if (date.length() >= 8) {
            year = date.substring(6, 8);
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(dateSet);
        year = calendar.get(1) % 100 == (int)CommonUtil.val(year) ? CommonUtil.str(1900 + calendar.get(1), 4, 0) : this.getYear(year);
        String newDate = "";
        if (this.startsYearDate) {
            newDate = year + date.substring(2);
            picture[0] = "99" + picture[0];
        } else {
            newDate = (date.length() > 6 ? date.substring(0, 6) : "") + year + (date.length() > 8 ? date.substring(8) : "");
            picture[0] = (picture[0].length() > 8 ? picture[0].substring(0, 8) : picture[0]) + "99" + (picture[0].length() > 8 ? picture[0].substring(8) : "");
        }
        return newDate;
    }

    public Date dateOk1(String date, String picture) {
        Date ret = null;
        if (PictureFormatter.isTimeInPicture(picture) && picture.substring(picture.length() - 2, picture.length()).equals("AM") && !date.substring(date.length() - 2, date.length()).equals("AM") & !date.substring(date.length() - 2, date.length()).equals("PM")) {
            return null;
        }
        String sDateFmt = this.pictureToDateFormat(picture);
        GXSimpleDateFormat df = new GXSimpleDateFormat(sDateFmt);
        df.setTimeZone(this.defaultTimeZone);
        df.setLenient(false);
        try {
            String dateIn = sDateFmt.indexOf("yyyy") >= 0 ? this.getDate(date) : date;
            ret = df.parse(dateIn);
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public String pictureToDateFormat(String picture) {
        boolean isAMPM = false;
        if (picture.length() > 1 && picture.substring(picture.length() - 2).equals("AM")) {
            isAMPM = true;
            picture = picture.substring(0, picture.length() - 3);
        }
        StringBuffer output = new StringBuffer(picture.length());
        if (PictureFormatter.isDateInPicture(picture)) {
            if (picture.indexOf("9999") >= 0) {
                if (this.startsYearDate) {
                    output.append("yy");
                    output.append(this.dateFormat);
                } else {
                    output.append(this.dateFormat);
                    output.append("yy");
                }
            } else {
                output.append(this.dateFormat);
            }
        }
        if (PictureFormatter.isTimeInPicture(picture)) {
            if (output.length() > 0) {
                output.append(" ");
            }
            output.append(this.timeFormat.substring(0, 2));
            int timeStart = picture.indexOf(32);
            int n = timeStart = timeStart < 0 ? 0 : timeStart;
            if (picture.length() - timeStart > 3) {
                output.append(":mm");
            }
            if (picture.length() - timeStart > 6) {
                output.append(":ss");
            }
            if (picture.length() - timeStart > 9) {
                output.append(".SSS");
            }
            if (isAMPM || this.timeFormat.substring(this.timeFormat.length() - 1).equals("a")) {
                output.append(" a");
            }
        }
        return output.toString();
    }

    String alignAndPad(String text, char pad, String picture, boolean floating, NumberFormat numberFormat, String originalPicture) {
        int posSep;
        String signPrefix = "";
        if (text.startsWith("-") && picture.startsWith("?")) {
            signPrefix = "-";
            text = text.substring(1);
        }
        DecimalFormat df = (DecimalFormat)numberFormat;
        char decimalSeparator = df.getDecimalFormatSymbols().getDecimalSeparator();
        if ((text = text.trim()).equals("")) {
            text = "0";
        }
        if ((posSep = picture.indexOf(46)) == -1) {
            if (floating) {
                return text;
            }
            if (text.length() < picture.length()) {
                return LocalUtil.alignRight(text, picture.length());
            }
            return text;
        }
        int posText = text.indexOf(decimalSeparator);
        StringBuffer sText = new StringBuffer(text);
        if (!CommonUtil.in(text, decimalSeparator)) {
            if (picture.charAt(posSep + 1) != '#' && picture.charAt(posSep + 1) != '?') {
                sText.append(decimalSeparator);
            }
            posText = sText.length() - 1;
        }
        while (posText++ < posSep) {
            sText.insert(0, ' ');
        }
        int offset = 0;
        while (sText.length() + offset < picture.length()) {
            char charAt = picture.charAt(sText.length());
            if (charAt == '?') {
                sText.append(' ');
                continue;
            }
            if (charAt != '#') {
                sText.append(pad);
                continue;
            }
            ++offset;
        }
        if (floating || originalPicture.startsWith("$")) {
            return CommonUtil.ltrim(sText.toString());
        }
        return signPrefix + sText.toString();
    }

    private boolean isAllZ(String picture) {
        if (!picture.trim().equals("@Z")) {
            int len = picture.length();
            for (int i = 0; i < len; ++i) {
                if (picture.charAt(i) != '9') continue;
                return false;
            }
        }
        return true;
    }

    public String format(long value, String picture) {
        return this.format(value, picture, NumberFormat.getInstance(this.getLocale()));
    }

    String format(long value, String picture, NumberFormat numberFormat) {
        String preffix;
        int newPictLength;
        String formatted = "";
        String originalPicture = picture;
        int originalPictLength = picture.length();
        boolean hasSymbol = originalPictLength > (newPictLength = (picture = this.takeSymbolsFromPicture(picture)).length());
        int j = 0;
        String valueStr = String.valueOf(value);
        int valueStrLength = valueStr.length();
        boolean continua = true;
        if (picture.indexOf(46) == -1 && picture.indexOf(44) == -1 && picture.indexOf(90) == -1) {
            block3: for (int i = 0; i < picture.length(); ++i) {
                char a = picture.charAt(i);
                switch (a) {
                    case '9': {
                        if (value == 0L) {
                            formatted = formatted + " ";
                            continue block3;
                        }
                        if (j < valueStrLength) {
                            formatted = formatted + valueStr.charAt(j);
                        }
                        ++j;
                        continue block3;
                    }
                    default: {
                        formatted = formatted + a;
                        continua = false;
                    }
                }
            }
        }
        if ((preffix = this.picturePreffix(picture)).startsWith("(")) {
            if (value < 0L) {
                value = -value;
            } else {
                picture = picture.replace('(', 'Z').substring(0, picture.length() - 1);
                preffix = "";
            }
        }
        boolean floating = preffix.trim().length() > 1 && preffix.replace(preffix.charAt(0), new String(" ").charAt(0)).trim().equals("");
        String withoutSuffixPicture = this.removePictureSuffix("%", this.removePicturePreffix(preffix, picture));
        if ((!this.isAllZ(picture) || value != 0L) && continua) {
            DecimalFormat df = (DecimalFormat)numberFormat;
            df.applyPattern(this.pictureToNumberFormat(withoutSuffixPicture));
            formatted = CommonUtil.in(picture, '.') || CommonUtil.in(picture, ',') ? this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture) : df.format(value);
        }
        if (originalPictLength > newPictLength && !floating) {
            formatted = this.addSymbolsToText(formatted, originalPicture, hasSymbol);
        }
        int negativeSign = 0;
        if (preffix.startsWith("(")) {
            negativeSign = -1;
        } else if (value < 0L) {
            negativeSign = 1;
        }
        if (floating) {
            return LocalUtil.alignRight(preffix.substring(preffix.length() - 1) + this.addPictureSuffix("%", originalPicture, this.addPicturePreffix(preffix, originalPicture, formatted)), originalPictLength + negativeSign);
        }
        return this.addPictureSuffix("%", originalPicture, this.addPicturePreffix(preffix, originalPicture, LocalUtil.alignRight(formatted, originalPictLength + negativeSign)));
    }

    private String takeSymbolsFromPicture(String picture) {
        StringBuffer pictureWithoutSymbols = new StringBuffer();
        boolean dotRemove = this.dotAsLiteral(picture);
        for (int i = 0; i < picture.length(); ++i) {
            char a = picture.charAt(i);
            if (a == '?' || a == '#' || a == 'Z' || a == '9' || a == ',' || a == '%' || a == ')' || a == '(' || a == ' ') {
                pictureWithoutSymbols.append(a);
                continue;
            }
            if (a == '.' && !dotRemove) {
                pictureWithoutSymbols.append(a);
                continue;
            }
            if (a != '\\') continue;
            int n = ++i;
            --i;
            if (picture.charAt(n) != '\"') continue;
            pictureWithoutSymbols.append('\"');
        }
        return pictureWithoutSymbols.toString();
    }

    private boolean dotAsLiteral(String originalPicture) {
        if (originalPicture.indexOf(45) != -1 || originalPicture.indexOf(47) != -1) {
            return true;
        }
        return originalPicture.lastIndexOf(46) != originalPicture.indexOf(46);
    }

    private String addSymbolsToText(String text, String originalPicture, boolean hasSymbol) {
        String formattedString;
        StringBuffer formattedText = new StringBuffer();
        int textIdx = text.length() - 1;
        boolean dotAsLiteral = this.dotAsLiteral(originalPicture);
        boolean isNegative = false;
        int i = originalPicture.length() - 1;
        while (i >= 0) {
            char textChar;
            char a = originalPicture.charAt(i--);
            while (a != 'Z' && a != '9' && a != ',' && (a != '.' || a == '.' && dotAsLiteral) && a != '%' && a != ')' && a != '(') {
                if (a != '+' || !text.startsWith("-")) {
                    formattedText.append(a);
                }
                if (a == ' ') {
                    --textIdx;
                }
                if (i < 0) break;
                a = originalPicture.charAt(i--);
            }
            if (textIdx < 0) continue;
            if ((textChar = text.charAt(textIdx--)) != '-' || !hasSymbol || textIdx < 0) {
                formattedText.append(textChar);
                continue;
            }
            formattedText.append(' ');
            isNegative = true;
        }
        while (textIdx >= 0) {
            formattedText.append(text.charAt(textIdx--));
        }
        if (isNegative) {
            formattedText.append('-');
        }
        if ((formattedString = formattedText.reverse().toString()).endsWith("DB")) {
            formattedString = formattedString.startsWith("-") ? formattedString.substring(1) : formattedString.replaceAll("DB", "CR");
        }
        return formattedString;
    }

    public String format(BigDecimal value, String picture) {
        if (CommonUtil.in(picture, '.') || CommonUtil.in(picture, ',')) {
            int decimalIndex = picture.indexOf(46);
            if (decimalIndex == -1) {
                decimalIndex = picture.indexOf(44);
            }
            return this.formatBigDecimal(CommonUtil.roundDecimal(value, picture.substring(decimalIndex).length() - 1), picture);
        }
        return this.formatBigDecimal(value, picture);
    }

    public String formatBigDecimal(BigDecimal value, String picture) {
        return this.formatBigDecimal(value, picture, NumberFormat.getInstance(this.getLocale()));
    }

    private String formatBigDecimal(BigDecimal value, String picture, NumberFormat numberFormat) {
        int newPictLength;
        String formatted = "";
        String originalPicture = picture;
        int originalPictLength = picture.length();
        boolean hasSymbol = originalPictLength > (newPictLength = (picture = this.takeSymbolsFromPicture(picture)).length());
        int j = 0;
        String valueStr = String.valueOf(value);
        int valueStrLength = valueStr.length();
        boolean continua = true;
        if (picture.indexOf(46) == -1 && picture.indexOf(44) == -1 && picture.indexOf(90) == -1 && picture.indexOf(40) == -1) {
            block3: for (int i = 0; i < picture.length(); ++i) {
                char a = picture.charAt(i);
                switch (a) {
                    case '9': {
                        if (value.compareTo(BigDecimal.ZERO) == 0) {
                            formatted = formatted + " ";
                            continue block3;
                        }
                        if (j < valueStrLength) {
                            formatted = formatted + valueStr.charAt(j);
                        }
                        ++j;
                        continue block3;
                    }
                    default: {
                        formatted = formatted + a;
                        continua = false;
                    }
                }
            }
        }
        String preffix = this.picturePreffix(picture);
        String suffix = this.pictureSuffix(picture);
        if (preffix.startsWith("(")) {
            if (value.compareTo(BigDecimal.ZERO) == -1) {
                value = value.negate();
            } else {
                picture = picture.replace('(', 'Z').substring(0, picture.length() - 1);
                preffix = "";
                suffix = "";
            }
        }
        boolean floating = preffix.trim().length() > 1 && preffix.replace(preffix.charAt(0), new String(" ").charAt(0)).trim().equals("");
        String withoutSuffixPicture = this.removePictureSuffix(suffix, this.removePicturePreffix(preffix, picture));
        if ((!this.isAllZ(picture) || value.compareTo(BigDecimal.ZERO) != 0) && continua) {
            DecimalFormat df = (DecimalFormat)numberFormat;
            df.applyPattern(this.pictureToNumberFormat(withoutSuffixPicture));
            formatted = CommonUtil.in(picture, '.') || CommonUtil.in(picture, ',') ? this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture) : df.format(value);
        }
        if (originalPictLength > newPictLength && !floating && !originalPicture.startsWith("\\")) {
            formatted = this.addSymbolsToText(formatted, originalPicture, hasSymbol);
        }
        int negativeSign = 0;
        if (preffix.startsWith("(")) {
            negativeSign = -2;
        } else if (value.signum() == -1 && !originalPicture.startsWith("+")) {
            negativeSign = 1;
        }
        if (floating) {
            return LocalUtil.alignRight(preffix.substring(preffix.length() - 1) + this.addPictureSuffix(suffix, originalPicture, this.addPicturePreffix(preffix, originalPicture, formatted)), originalPictLength + negativeSign);
        }
        if (preffix.equals("(") && originalPicture.charAt(1) == '#') {
            return LocalUtil.alignRight(this.addPictureSuffix(suffix, originalPicture, this.addPicturePreffix(preffix, originalPicture, CommonUtil.ltrim(formatted))), originalPictLength);
        }
        if (originalPicture.startsWith("\\")) {
            negativeSign = -2;
            if (preffix.equals("\"") && originalPicture.startsWith("\\\\")) {
                --negativeSign;
            }
            return originalPicture.charAt(1) + this.addPictureSuffix(suffix, originalPicture, this.addPicturePreffix(preffix, originalPicture, LocalUtil.alignRight(formatted, originalPictLength + negativeSign)));
        }
        return this.addPictureSuffix(suffix, originalPicture, this.addPicturePreffix(preffix, originalPicture, LocalUtil.alignRight(formatted, originalPictLength + negativeSign)));
    }

    public String format(double value, String picture) {
        return this.format(value, picture, NumberFormat.getInstance(this.getLocale()));
    }

    private String format(double value, String picture, NumberFormat numberFormat) {
        String formatted = "";
        String originalPicture = picture;
        if (picture.startsWith("\\")) {
            picture = picture.substring(2);
        }
        String preffix = this.picturePreffix(picture);
        String suffix = this.pictureSuffix(picture);
        if (preffix.startsWith("(")) {
            if (value < 0.0) {
                value = -value;
            } else {
                picture = picture.replace('(', 'Z').replace(')', '?');
                preffix = "";
                suffix = "";
            }
        }
        boolean floating = preffix.trim().length() > 1 && preffix.replace(preffix.charAt(0), new String(" ").charAt(0)).trim().equals("");
        String withoutSuffixPicture = this.removePictureSuffix(suffix, this.removePicturePreffix(preffix, picture));
        int negativeSign = 0;
        if (preffix.startsWith("(")) {
            negativeSign = -2;
        } else if (value < 0.0) {
            negativeSign = 1;
        }
        if (!this.isAllZ(picture) || value != 0.0) {
            DecimalFormat df = (DecimalFormat)numberFormat;
            df.applyPattern(this.pictureToNumberFormat(withoutSuffixPicture));
            if (CommonUtil.in(picture, '.') || CommonUtil.in(picture, ',')) {
                if (floating) {
                    return LocalUtil.alignRight(preffix.substring(preffix.length() - 1) + this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture))), picture.length() + negativeSign);
                }
                if (preffix.equals("(") && picture.charAt(1) == '#') {
                    return LocalUtil.alignRight(this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, CommonUtil.ltrim(this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture)))), picture.length());
                }
                if (originalPicture.startsWith("\\")) {
                    return originalPicture.charAt(1) + this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, LocalUtil.alignRight(this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture), picture.length() + negativeSign)));
                }
                return this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, LocalUtil.alignRight(this.alignAndPad(df.format(value), '0', withoutSuffixPicture, floating, numberFormat, originalPicture), picture.length() + negativeSign)));
            }
            formatted = df.format(value);
        }
        if (floating) {
            return LocalUtil.alignRight(preffix.substring(preffix.length() - 1) + this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, formatted)), picture.length() + negativeSign);
        }
        return this.addPictureSuffix(suffix, picture, this.addPicturePreffix(preffix, picture, LocalUtil.alignRight(formatted, picture.length() + negativeSign)));
    }

    private String removePictureSuffix(String suffix, String picture) {
        if (picture.endsWith(suffix)) {
            return picture.substring(0, picture.length() - suffix.length());
        }
        return picture;
    }

    private String addPictureSuffix(String suffix, String originalPicture, String value) {
        if (originalPicture.endsWith(suffix)) {
            return value + suffix;
        }
        return value;
    }

    private String picturePreffix(String picture) {
        int len = picture.length();
        String preffix = "";
        for (int i = 0; i < len; ++i) {
            if (!GXPicture.isSeparator(picture.charAt(i)) || picture.charAt(i) == ' ' || picture.charAt(i) == '\\') {
                return preffix;
            }
            preffix = preffix + picture.charAt(i);
        }
        return preffix;
    }

    private String pictureSuffix(String picture) {
        int len = 0;
        String preffix = "";
        for (int i = picture.length() - 1; i > len; --i) {
            if (!GXPicture.isSeparator(picture.charAt(i)) || picture.charAt(i) == ' ') {
                return preffix;
            }
            preffix = preffix + picture.charAt(i);
        }
        return preffix;
    }

    private String removePicturePreffix(String suffix, String picture) {
        if (picture.startsWith(suffix)) {
            return picture.substring(suffix.length(), picture.length());
        }
        return picture;
    }

    private String addPicturePreffix(String suffix, String originalPicture, String value) {
        if (originalPicture.startsWith(suffix) || suffix.equals("\"") && originalPicture.startsWith("\\\\")) {
            return suffix + value;
        }
        return value;
    }

    private String pictureToNumberFormat(String withoutSuffixPicture) {
        return PictureFormatter.pictureToNumberFormat(withoutSuffixPicture.replace('9', '0').replace('Z', '#'));
    }

    public long ctol(String value) {
        if (value == null) {
            return 0L;
        }
        return this.tryParseLong(value.trim());
    }

    public long ctol(String value, String decSep, String thousandsSep) {
        return this.ctol(LocalUtil.normalize(value, decSep.charAt(0), thousandsSep.charAt(0)));
    }

    public BigDecimal ctond(String value) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(this.getLocale());
        return DecimalUtil.stringToDec(LocalUtil.normalize(value, df.getDecimalFormatSymbols().getDecimalSeparator(), df.getDecimalFormatSymbols().getGroupingSeparator()));
    }

    public double cton(String value, String decSep, String thousandsSep) {
        return CommonUtil.val(LocalUtil.normalize(value, decSep.charAt(0), thousandsSep.charAt(0)));
    }

    private static String normalize(String value, char decSepChar, char thousandsSepChar) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        boolean dotAsLiteral = decSepChar == '.' && value.lastIndexOf(46) != value.indexOf(46);
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == decSepChar) {
                if (dotAsLiteral) continue;
                buffer.append('.');
                first = false;
                continue;
            }
            if (value.charAt(i) == '-' && first) {
                buffer.append(value.charAt(i));
                first = false;
                continue;
            }
            if (value.charAt(i) < '0' || value.charAt(i) > '9') continue;
            buffer.append(value.charAt(i));
            first = false;
        }
        return buffer.toString();
    }

    public String ntoc(long value, int digits, int decimals, String decSep, String thousandsSep) {
        String picture = this.getPicture(digits, decimals, thousandsSep);
        String result = this.format(value, picture, NumberFormat.getInstance(Locale.ENGLISH));
        if (decimals == 0 && thousandsSep.length() == 0) {
            return result;
        }
        return this.replaceSeparators(result, decSep, thousandsSep);
    }

    public String ntoc(double value, int digits, int decimals, String decSep, String thousandsSep) {
        String picture = this.getPicture(digits, decimals, thousandsSep);
        String result = this.format(value, picture, NumberFormat.getInstance(Locale.ENGLISH));
        if (decimals == 0 && thousandsSep.length() == 0) {
            return result;
        }
        return this.replaceSeparators(result, decSep, thousandsSep);
    }

    public String ntoc(BigDecimal value, int digits, int decimals, String decSep, String thousandsSep) {
        String picture = this.getPicture(digits, decimals, thousandsSep);
        String result = this.formatBigDecimal(value, picture, NumberFormat.getInstance(Locale.ENGLISH));
        if (decimals == 0 && thousandsSep.length() == 0) {
            return result;
        }
        return this.replaceSeparators(result, decSep, thousandsSep);
    }

    private String replaceSeparators(String number, String decSep, String thousandsSep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '.') {
                sb.append(decSep);
                continue;
            }
            if (c == ',') {
                sb.append(thousandsSep);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String getPicture(int digits, int decimals, String thousandsSep) {
        String out;
        if (thousandsSep.equals("")) {
            out = CommonUtil.replicate("Z", digits - 1) + "9";
        } else {
            StringBuffer integerThousands = new StringBuffer();
            for (int i = 0; i < digits; ++i) {
                integerThousands.append("Z");
                if ((i + 1) % 3 != 0) continue;
                integerThousands.append(",");
            }
            int lastZ = integerThousands.toString().indexOf(90);
            if (lastZ != -1) {
                integerThousands.setCharAt(lastZ, '9');
            }
            out = integerThousands.reverse().toString();
        }
        if (decimals > 0) {
            out = out + "." + CommonUtil.replicate("9", decimals);
        }
        return out;
    }

    static String alignRight(String text, int length) {
        return CommonUtil.padl(text, length, " ");
    }

    public String format(String value, String picture) {
        return PictureFormatter.format(value, picture);
    }

    public String format(Date value, String picture) {
        if (CommonUtil.nullDate().equals(value)) {
            if (PictureFormatter.isTimeInPicture(picture)) {
                String timePicture = PictureFormatter.getTimePictureInPicture(picture);
                String datePicture = picture.substring(0, picture.length() - timePicture.length());
                if (this.timeFormat.endsWith("a")) {
                    timePicture = timePicture + " AM";
                }
                if (CommonUtil.nullDate().equals(value) && LocalUtil.getBLANK_EMPTY_DATE()) {
                    return "        ";
                }
                GXSimpleDateFormat dateFormatter = new GXSimpleDateFormat(this.pictureToDateFormat(timePicture));
                dateFormatter.setTimeZone(CommonUtil.defaultTimeZone);
                dateFormatter.setLenient(false);
                return PictureFormatter.getNullMask(datePicture) + dateFormatter.gxFormat(value);
            }
            return PictureFormatter.getNullMask(picture);
        }
        GXSimpleDateFormat dateFormatter = new GXSimpleDateFormat(this.pictureToDateFormat(picture));
        dateFormatter.setTimeZone(CommonUtil.defaultTimeZone);
        dateFormatter.setLenient(false);
        return dateFormatter.gxFormat(value);
    }

    public Date applyYearLimit(Date dateTime, String picture) {
        if (picture.indexOf("yyyy") >= 0) {
            return dateTime;
        }
        int posYear = picture.indexOf("yy");
        if (posYear < 0) {
            return dateTime;
        }
        Calendar currentCalendar = GregorianCalendar.getInstance();
        currentCalendar.setTime(new Date());
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(dateTime);
        if (calendar.get(1) % 100 < this.firstYear2K) {
            if (calendar.get(1) - 100 < 1900) {
                calendar.set(1, calendar.get(1) + 100);
            }
        } else if (calendar.get(1) > currentCalendar.get(1)) {
            calendar.set(1, calendar.get(1) - 100);
        }
        return calendar.getTime();
    }

    public String getDateTimePicture(String dateTime) {
        String picture;
        String AMPM = "";
        dateTime = CommonUtil.rtrim(dateTime);
        if ((dateTime = LocalUtil.fixUnparseableEmptyTime(dateTime)).endsWith("M") || dateTime.endsWith("m")) {
            if (dateTime.charAt(dateTime.length() - 3) == ' ') {
                dateTime = dateTime.substring(0, dateTime.length() - 3);
                AMPM = " a";
            } else {
                dateTime = dateTime.substring(0, dateTime.length() - 2);
                AMPM = "a";
            }
        }
        String hour = AMPM.equals("") ? "HH" : "hh";
        if ((dateTime = LocalUtil.fixTimeExpresion(dateTime)).indexOf(32) < 0) {
            switch (dateTime.length()) {
                case 2: {
                    picture = hour;
                    break;
                }
                case 5: {
                    picture = hour + ":mm";
                    break;
                }
                case 8: {
                    if (dateTime.indexOf(58) < 0) {
                        picture = this.dateFormat;
                        break;
                    }
                    picture = hour + ":mm:ss";
                    break;
                }
                case 12: {
                    picture = hour + ":mm:ss.SSS";
                    break;
                }
                default: {
                    picture = LocalUtil.addYearToPicture(this.dateFormat);
                    break;
                }
            }
        } else {
            switch (dateTime.length()) {
                case 11: {
                    picture = this.dateFormat + " " + hour;
                    break;
                }
                case 13: {
                    picture = LocalUtil.addYearToPicture(this.dateFormat) + " " + hour;
                    break;
                }
                case 14: {
                    picture = this.dateFormat + " " + hour + ":mm";
                    break;
                }
                case 16: {
                    picture = LocalUtil.addYearToPicture(this.dateFormat) + " " + hour + ":mm";
                    break;
                }
                case 17: {
                    picture = this.dateFormat + " " + hour + ":mm:ss";
                    break;
                }
                case 21: {
                    picture = this.dateFormat + " " + hour + ":mm:ss.SSS";
                    break;
                }
                case 23: {
                    picture = LocalUtil.addYearToPicture(this.dateFormat) + " " + hour + ":mm:ss.SSS";
                    break;
                }
                default: {
                    picture = LocalUtil.addYearToPicture(this.dateFormat) + " " + hour + ":mm:ss";
                }
            }
        }
        return picture + AMPM;
    }

    private static String fixTimeExpresion(String dateTime) {
        int spaceIdx = dateTime.indexOf(32);
        String fixedStr = "";
        String timeStr = "";
        if (spaceIdx > 0) {
            fixedStr = dateTime.substring(0, spaceIdx + 1);
            timeStr = dateTime.substring(spaceIdx + 1);
        } else {
            timeStr = dateTime;
        }
        int firstDotsIdx = timeStr.indexOf(":");
        int secondDotsIdx = timeStr.lastIndexOf(":");
        if (firstDotsIdx != -1) {
            if (firstDotsIdx < 2) {
                fixedStr = fixedStr + 0;
            }
            fixedStr = fixedStr + timeStr.substring(0, firstDotsIdx + 1);
            if (secondDotsIdx != -1 && secondDotsIdx != firstDotsIdx) {
                if (secondDotsIdx - firstDotsIdx <= 2) {
                    fixedStr = fixedStr + 0;
                }
                fixedStr = fixedStr + timeStr.substring(firstDotsIdx + 1, secondDotsIdx + 1);
                if (timeStr.length() - secondDotsIdx <= 2) {
                    fixedStr = fixedStr + 0;
                }
                fixedStr = fixedStr + timeStr.substring(secondDotsIdx + 1);
            } else {
                if (timeStr.length() - firstDotsIdx <= 2) {
                    fixedStr = fixedStr + 0;
                }
                fixedStr = fixedStr + timeStr.substring(firstDotsIdx + 1);
            }
        } else {
            if (timeStr.length() < 2) {
                fixedStr = fixedStr + 0;
            }
            fixedStr = fixedStr + timeStr;
        }
        return fixedStr;
    }

    private static String addYearToPicture(String picture) {
        int index = picture.indexOf(121);
        if (index == -1) {
            return picture + "yy";
        }
        return picture.substring(0, index) + "yy" + picture.substring(index);
    }

    public long tryParseLong(String string) {
        int digit;
        int index;
        int radix = 10;
        if (string.isEmpty()) {
            return 0L;
        }
        boolean negative = string.charAt(0) == '-';
        int n = index = negative ? 1 : 0;
        if (index == string.length()) {
            return 0L;
        }
        if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix) {
            return 0L;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index < string.length()) {
            if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix || accum < cap) {
                return 0L;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return 0L;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return 0L;
        }
        return -accum;
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c) {
            return c < '\u0080' ? asciiDigits[c] : -1;
        }

        static {
            int i;
            byte[] result = new byte[128];
            Arrays.fill(result, (byte)-1);
            for (i = 0; i <= 9; ++i) {
                result[48 + i] = (byte)i;
            }
            for (i = 0; i <= 26; ++i) {
                result[65 + i] = (byte)(10 + i);
                result[97 + i] = (byte)(10 + i);
            }
            asciiDigits = result;
        }
    }
}

