/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.LocalUtil;
import com.genexus.common.interfaces.SpecificImplementation;

public class PictureFormatter {
    public static String format(String value, String picture) {
        return SpecificImplementation.PictureFormatter.format(value, picture);
    }

    public static String getNullMask(String picture) {
        if (LocalUtil.getBLANK_EMPTY_DATE()) {
            picture = picture.replace('/', ' ').replace(':', ' ');
        }
        return picture.replace('9', ' ').replace('X', ' ').replace('!', ' ').replace('Z', ' ').replace('A', ' ').replace('M', ' ');
    }

    public static boolean isDateEmpty(String date) {
        for (int i = date.length() - 1; i >= 0; --i) {
            char car = date.charAt(i);
            if (car == ' ' || car == '/' || car == '-' || car == ':' || car == '0' || car == 'T' || car == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isDateInPicture(String picture) {
        return picture.length() > 7 && (picture.indexOf(47) > 0 || picture.indexOf(45) > 0);
    }

    public static boolean isTimeInPicture(String picture) {
        return picture.equals("99") || picture.indexOf(58) > 0 || picture.toUpperCase().endsWith("M") || picture.endsWith(" 99");
    }

    public static String getTimePictureInPicture(String picture) {
        int pos = picture.indexOf("99:");
        if (pos >= 0) {
            return picture.substring(pos);
        }
        pos = picture.indexOf(" 9");
        if (pos >= 0) {
            return picture.substring(pos + 1);
        }
        if (picture.equals("99")) {
            return picture;
        }
        return "";
    }

    public static String pictureToNumberFormat(String picture) {
        boolean hasDollar = false;
        StringBuffer newPicture = new StringBuffer(picture.length());
        block8: for (int i = 0; i < picture.length(); ++i) {
            char car = picture.charAt(i);
            switch (car) {
                case '\\': {
                    newPicture.append('\'');
                    newPicture.append(picture.charAt(i + 1));
                    newPicture.append('\'');
                    newPicture.append(picture.charAt(i + 1));
                    ++i;
                    continue block8;
                }
                case '?': {
                    newPicture.append('#');
                    continue block8;
                }
                case '9': {
                    newPicture.append('#');
                    continue block8;
                }
                case 'Z': {
                    newPicture.append('#');
                    continue block8;
                }
                case '.': {
                    if (i > 0 && picture.charAt(i - 1) != '?') {
                        newPicture.setCharAt(newPicture.length() - 1, '0');
                    }
                    newPicture.append(car);
                    if (i + 1 < picture.length() && picture.indexOf(48, i + 1) > i + 1) {
                        picture = picture.substring(0, i) + picture.substring(i).replace('0', '#');
                        newPicture.append('0');
                        ++i;
                        continue block8;
                    }
                    if (picture.charAt(i + 1) != '?' || picture.charAt(i - 1) != '?') continue block8;
                    newPicture.append('0');
                    ++i;
                    continue block8;
                }
                case '$': {
                    hasDollar = true;
                    newPicture.append('#');
                    continue block8;
                }
                default: {
                    newPicture.append(car);
                }
            }
        }
        return hasDollar ? "$" + newPicture.toString() : newPicture.toString();
    }
}

