/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.cryptography.Constants;
import com.genexus.cryptography.Utils;
import com.genexus.cryptography.hashing.IGXHashing;
import com.genexus.cryptography.hashing.KeyedHashProvider;
import com.genexus.cryptography.hashing.MessageDigestProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public class GXHashing {
    private int _lastError;
    private String _lastErrorDescription;
    private String _algorithm = Constants.DEFAULT_HASH_ALGORITHM;
    private IGXHashing _hash;
    private boolean isDirty = true;

    public GXHashing() {
        this.initialize();
    }

    private void initialize() {
        if (this.isDirty) {
            this.setError(0);
            try {
                this._hash = this._algorithm.toUpperCase().startsWith("HMAC") ? new KeyedHashProvider(Utils.mapHashAlgorithm(this._algorithm)) : new MessageDigestProvider(Utils.mapHashAlgorithm(this._algorithm));
                this.isDirty = false;
            }
            catch (NoSuchAlgorithmException e) {
                this.setError(2);
            }
        }
    }

    public String compute(String text, String key) {
        block9: {
            this.initialize();
            if (!this.anyError()) {
                boolean keyHashAlgorithm = this._hash instanceof KeyedHashProvider;
                if (keyHashAlgorithm && this.isBlank(key)) {
                    this.setError(4);
                } else if (!keyHashAlgorithm && !this.isBlank(key)) {
                    this.setError(3);
                } else {
                    if (keyHashAlgorithm) {
                        try {
                            return this._hash.computeHashKey(text, key);
                        }
                        catch (SignatureException ex) {
                            this.setError(1);
                            break block9;
                        }
                        catch (InvalidKeyException ex) {
                            this.setError(5);
                            break block9;
                        }
                    }
                    return this._hash.computeHash(text);
                }
            }
        }
        return "";
    }

    private void setError(int errorCode) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                this._lastErrorDescription = "Signature exception";
                break;
            }
            case 2: {
                this._lastErrorDescription = "Algorithm not supported";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Algorithm does not support Hashing with Key. Please use HMAC instead or remove the Key parameter";
                break;
            }
            case 4: {
                this._lastErrorDescription = "Key must be specified";
                break;
            }
            case 5: {
                this._lastErrorDescription = "Invalid key";
                break;
            }
        }
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.isDirty = true;
        this._algorithm = algorithm;
    }

    private boolean anyError() {
        return this._lastError != 0;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }
}

