/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.common.interfaces.SpecificImplementation;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class DynamicExecute {
    private static Class[] intClass = new Class[]{Integer.TYPE};
    private static Class[] constructorClass = new Class[]{Integer.TYPE, SpecificImplementation.Application.getModelContextClass()};
    public static final String METHOD_EXECUTE = "execute";
    protected static final int TYPE_BYTE = 1;
    protected static final int TYPE_CHARACTER = 2;
    protected static final int TYPE_SHORT = 3;
    protected static final int TYPE_INTEGER = 4;
    protected static final int TYPE_LONG = 5;
    protected static final int TYPE_FLOAT = 6;
    protected static final int TYPE_DOUBLE = 7;
    protected static final int TYPE_BOOLEAN = 8;
    protected static final int TYPE_BIG_DECIMAL = 40;
    protected static final int TYPE_NOT_PRIMITIVE = -1;

    public static void dynamicExecute(int handle, String pgmName) {
        DynamicExecute.dynamicExecute(SpecificImplementation.Application.getModelContext(SpecificImplementation.Application.getModelContextClass()), handle, SpecificImplementation.Application.getApplicationClass(), SpecificImplementation.GXutil.getClassName(pgmName.toLowerCase()), new Object[0]);
    }

    public static String dynamicWebExecute(ModelContext context, int handle, Class servlet, String wjLoc, String wjAuxLoc, String sPackage, String sPgmName, Object[] parms) {
        String pgmName = DynamicExecute.getDynamicPgmName(servlet, sPackage, sPgmName);
        ClassLoader cLoader = servlet.getClassLoader();
        Class c = DynamicExecute.tryLoadClass(cLoader, pgmName, false);
        boolean isWebContext = false;
        if (SpecificImplementation.DynamicExecute != null) {
            isWebContext = SpecificImplementation.DynamicExecute.getIsWebContext(context);
        }
        if (isWebContext && c.getSuperclass().getSuperclass().equals(SpecificImplementation.Application.getGXWebObjectStubClass())) {
            int idx = wjAuxLoc.indexOf(63);
            if (idx >= 0) {
                String objetName = wjAuxLoc.substring(0, idx);
                return objetName + wjAuxLoc.substring(idx);
            }
            return wjAuxLoc;
        }
        DynamicExecute.dynamicExecute(context, handle, servlet, pgmName, parms);
        return wjLoc;
    }

    private static String getDynamicPgmName(Class servlet, String sPackage, String sPgmName) {
        ClassLoader cLoader;
        Class c;
        String classPackage = SpecificImplementation.Application.getPACKAGE();
        if (!classPackage.equals("")) {
            classPackage = classPackage + ".";
        }
        String pgmName = CommonUtil.getObjectName(sPackage, sPgmName);
        if (!classPackage.equals(sPackage)) {
            try {
                Class<?> clazz = Class.forName(pgmName);
            }
            catch (ClassNotFoundException e) {
                pgmName = CommonUtil.getObjectName(classPackage, sPgmName);
            }
        }
        if ((c = DynamicExecute.tryLoadClass(cLoader = servlet.getClassLoader(), pgmName, false)) == null && (c = DynamicExecute.tryLoadClass(cLoader, sPgmName, false)) != null) {
            pgmName = sPgmName;
        }
        if (c == null) {
            throw new RuntimeException("ClassNotFoundException Can't execute dynamic call " + pgmName);
        }
        return pgmName;
    }

    public static Class tryLoadClass(ClassLoader cLoader, String className, Boolean throwException) {
        Class<?> c;
        block2: {
            c = null;
            try {
                c = cLoader == null ? Class.forName(className) : cLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (!throwException.booleanValue()) break block2;
                throw new RuntimeException("ClassNotFoundException Can't execute dynamic call " + className + " - " + e.getMessage());
            }
        }
        return c;
    }

    public static boolean dynamicInstaceExecute(Object instance, String method, Object[] parms) {
        Class[] parmTypes = null;
        if (parms != null) {
            parmTypes = new Class[parms.length];
            for (int i = parms.length - 1; i >= 0; --i) {
                parmTypes[i] = parms[i].getClass();
            }
        }
        Class<?> myClass = instance.getClass();
        String pgmName = myClass.getName();
        try {
            myClass.getMethod(method, parmTypes).invoke(instance, parms);
        }
        catch (IllegalAccessException e) {
            SpecificImplementation.Application.printWarning("IllegalAccessException Can't execute dynamic call " + pgmName + " - " + e.getMessage(), e);
            return false;
        }
        catch (NoSuchMethodException e) {
            SpecificImplementation.Application.printWarning("NoSuchMethodException Can't execute dynamic call " + pgmName + " - " + e.getMessage(), e);
            return false;
        }
        catch (InvocationTargetException e) {
            SpecificImplementation.Application.printWarning("java.lang.reflect.InvocationTargetException Can't execute dynamic call " + pgmName + " - " + e.getTargetException().getMessage(), e);
            return false;
        }
        return true;
    }

    private static boolean dynamicExecute2(ModelContext context, int handle, Class caller, String pgmName, Object[] parms) {
        Class<?> myClass;
        Class[] parmTypes = new Class[parms.length];
        for (int i = parms.length - 1; i >= 0; --i) {
            parmTypes[i] = parms[i].getClass();
        }
        try {
            myClass = caller.getClassLoader() == null ? Class.forName(pgmName) : caller.getClassLoader().loadClass(pgmName);
        }
        catch (ClassNotFoundException e) {
            SpecificImplementation.Application.printWarning("ClassNotFoundException Can't execute dynamic call " + pgmName + " - " + e.getMessage(), e);
            return false;
        }
        try {
            myClass.getMethod(METHOD_EXECUTE, parmTypes).invoke(myClass.getConstructor(constructorClass).newInstance(new Integer(handle), context), parms);
        }
        catch (IllegalAccessException e) {
            SpecificImplementation.Application.printWarning("IllegalAccessException Can't execute dynamic call " + pgmName + " - " + e.getMessage(), e);
            return false;
        }
        catch (NoSuchMethodException e) {
            SpecificImplementation.Application.printWarning("NoSuchMethodException Can't execute dynamic call " + pgmName + " - " + e.getMessage(), e);
            return false;
        }
        catch (InvocationTargetException e) {
            SpecificImplementation.Application.printWarning("java.lang.reflect.InvocationTargetException Can't execute dynamic call " + pgmName + " - " + e.getTargetException().getMessage(), e);
            return false;
        }
        catch (InstantiationException e) {
            SpecificImplementation.Application.printWarning("InstantiationException Can't execute dynamic call " + pgmName + e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static boolean dynamicExecute(ModelContext context, int handle, Class caller, String sPackage, String sPgmName, Object[] params) {
        String pgmName = DynamicExecute.getDynamicPgmName(caller, sPackage, sPgmName);
        return DynamicExecute.dynamicExecute(context, handle, caller, pgmName, params);
    }

    public static boolean dynamicExecute(ModelContext context, int handle, Class caller, String className, Object[] params) {
        Object[] callingParams = new Object[params.length];
        boolean[] needToUpdateParams = new boolean[params.length];
        Class myClass = DynamicExecute.tryLoadClass(caller.getClassLoader(), className, true);
        Method[] methods = myClass.getMethods();
        Method methodToExecute = null;
        Class<Serializable> sourceClass = null;
        Class<BigDecimal> destClass = null;
        block36: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameters;
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(METHOD_EXECUTE) || (parameters = method.getParameterTypes()).length != params.length) continue;
            for (int j = 0; j < parameters.length; ++j) {
                int arrayIndex;
                sourceClass = params[j].getClass();
                needToUpdateParams[j] = false;
                if (parameters[j].equals(sourceClass) || parameters[j].isAssignableFrom(sourceClass)) {
                    callingParams[j] = params[j];
                    continue;
                }
                boolean destIsArray = parameters[j].isArray();
                destClass = destIsArray ? parameters[j].getComponentType() : parameters[j];
                boolean sourceIsArray = sourceClass.isArray();
                int sourceArraySize = 1;
                if (sourceIsArray) {
                    sourceClass = sourceClass.getComponentType();
                    sourceArraySize = Array.getLength(params[j]);
                }
                if (destIsArray) {
                    needToUpdateParams[j] = true;
                }
                if (destClass.equals(sourceClass)) {
                    if (destIsArray) {
                        callingParams[j] = Array.newInstance(destClass, sourceArraySize);
                        if (sourceIsArray) {
                            for (arrayIndex = sourceArraySize - 1; arrayIndex >= 0; --arrayIndex) {
                                Array.set(callingParams[j], arrayIndex, ((Object[])params[j])[arrayIndex]);
                            }
                        } else {
                            Array.set(callingParams[j], 0, params[j]);
                        }
                    } else {
                        callingParams[j] = sourceIsArray ? Array.get(params[j], 0) : params[j];
                    }
                } else {
                    if (destIsArray) {
                        switch (DynamicExecute.getPrimitiveType(destClass)) {
                            case 1: {
                                callingParams[j] = new byte[sourceArraySize];
                                break;
                            }
                            case 2: {
                                callingParams[j] = new char[sourceArraySize];
                                break;
                            }
                            case 3: {
                                callingParams[j] = new short[sourceArraySize];
                                break;
                            }
                            case 4: {
                                callingParams[j] = new int[sourceArraySize];
                                break;
                            }
                            case 5: {
                                callingParams[j] = new long[sourceArraySize];
                                break;
                            }
                            case 6: {
                                callingParams[j] = new float[sourceArraySize];
                                break;
                            }
                            case 7: {
                                callingParams[j] = new double[sourceArraySize];
                                break;
                            }
                            case 40: {
                                callingParams[j] = new BigDecimal[sourceArraySize];
                            }
                        }
                    }
                    block39: for (arrayIndex = sourceArraySize - 1; arrayIndex >= 0; --arrayIndex) {
                        boolean destIsBigDecimal = destClass.isAssignableFrom(BigDecimal.class);
                        if (!destClass.isPrimitive() && !destIsBigDecimal) break block36;
                        double arg = -1.0;
                        BigDecimal bigDecimalArg = null;
                        if (sourceClass.isPrimitive()) {
                            if (sourceIsArray) {
                                arg = Array.getDouble(params[j], arrayIndex);
                            }
                        } else if (sourceClass.isAssignableFrom(BigDecimal.class)) {
                            if (sourceIsArray) {
                                if (destIsBigDecimal) {
                                    bigDecimalArg = ((BigDecimal[])params[j])[arrayIndex];
                                } else {
                                    arg = ((BigDecimal[])params[j])[arrayIndex].doubleValue();
                                }
                            } else if (destIsBigDecimal) {
                                bigDecimalArg = (BigDecimal)params[j];
                            } else {
                                arg = ((BigDecimal)params[j]).doubleValue();
                            }
                        } else if (sourceClass.isAssignableFrom(Byte.class) || sourceClass.isAssignableFrom(Character.class) || sourceClass.isAssignableFrom(Short.class) || sourceClass.isAssignableFrom(Integer.class) || sourceClass.isAssignableFrom(Long.class) || sourceClass.isAssignableFrom(Float.class) || sourceClass.isAssignableFrom(Double.class)) {
                            arg = Double.valueOf(params[j].toString());
                        } else {
                            if (!sourceClass.isAssignableFrom(Boolean.class)) break block36;
                            double d = arg = (Boolean)params[j] != false ? 1.0 : 0.0;
                        }
                        if (destIsArray) {
                            switch (DynamicExecute.getPrimitiveType(destClass)) {
                                case 1: {
                                    ((byte[])callingParams[j])[arrayIndex] = (byte)arg;
                                    break;
                                }
                                case 2: {
                                    ((char[])callingParams[j])[arrayIndex] = (char)arg;
                                    break;
                                }
                                case 3: {
                                    ((short[])callingParams[j])[arrayIndex] = (short)arg;
                                    break;
                                }
                                case 4: {
                                    ((int[])callingParams[j])[arrayIndex] = (int)arg;
                                    break;
                                }
                                case 5: {
                                    ((long[])callingParams[j])[arrayIndex] = (long)arg;
                                    break;
                                }
                                case 6: {
                                    ((float[])callingParams[j])[arrayIndex] = (float)arg;
                                    break;
                                }
                                case 7: {
                                    ((double[])callingParams[j])[arrayIndex] = arg;
                                    break;
                                }
                                case 40: {
                                    ((BigDecimal[])callingParams[j])[arrayIndex] = sourceClass.isAssignableFrom(BigDecimal.class) ? bigDecimalArg : new BigDecimal(arg);
                                }
                            }
                            continue;
                        }
                        switch (DynamicExecute.getPrimitiveType(destClass)) {
                            case 1: {
                                callingParams[j] = new Byte((byte)arg);
                                continue block39;
                            }
                            case 2: {
                                callingParams[j] = new Character((char)arg);
                                continue block39;
                            }
                            case 3: {
                                callingParams[j] = new Short((short)arg);
                                continue block39;
                            }
                            case 4: {
                                callingParams[j] = new Integer((int)arg);
                                continue block39;
                            }
                            case 5: {
                                callingParams[j] = new Long((long)arg);
                                continue block39;
                            }
                            case 6: {
                                callingParams[j] = new Float((float)arg);
                                continue block39;
                            }
                            case 7: {
                                callingParams[j] = new Double(arg);
                                continue block39;
                            }
                            case 8: {
                                callingParams[j] = new Boolean(arg != 0.0);
                                continue block39;
                            }
                            case 40: {
                                callingParams[j] = sourceClass.isAssignableFrom(BigDecimal.class) ? bigDecimalArg : new BigDecimal(arg);
                            }
                        }
                    }
                }
                if (!sourceClass.isArray()) continue;
            }
            methodToExecute = method;
            break;
        }
        if (methodToExecute == null) {
            if (sourceClass == null || destClass == null) {
                throw new RuntimeException("NoSuchMethodException Can't execute dynamic call " + className);
            }
            throw new RuntimeException("InvalidArguments: Can't execute dynamic call " + className + " - source argument(" + sourceClass.toString() + ") not compatible with expected function argument (" + destClass.toString() + ")");
        }
        try {
            methodToExecute.invoke(myClass.getConstructor(constructorClass).newInstance(new Integer(handle), context), callingParams);
            DynamicExecute.updateParamsAfterInvoke(params, callingParams, needToUpdateParams);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException Can't execute dynamic call " + className + " - " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("NoSuchMethodException Can't execute dynamic call " + className + " - " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("java.lang.reflect.InvocationTargetException Can't execute dynamic call " + className + " - " + e.getTargetException().getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("InstantiationException Can't execute dynamic call " + className + e.getMessage());
        }
        return true;
    }

    private static void updateParamsAfterInvoke(Object[] params, Object[] callingParams, boolean[] needToUpdateParams) {
        for (int j = 0; j < needToUpdateParams.length; ++j) {
            if (!needToUpdateParams[j]) continue;
            Class<?> paramClass = params[j].getClass();
            Class<Serializable> calledClass = callingParams[j].getClass().getComponentType();
            boolean sourceIsArray = paramClass.isArray();
            int sourceArraySize = 1;
            if (sourceIsArray) {
                sourceArraySize = Array.getLength(params[j]);
                paramClass = paramClass.getComponentType();
            }
            block21: for (int arrayIndex = 0; arrayIndex < sourceArraySize; ++arrayIndex) {
                if (calledClass.equals(paramClass)) {
                    if (sourceIsArray) {
                        Array.set(params[j], arrayIndex, Array.get(callingParams[j], arrayIndex));
                        continue;
                    }
                    params[j] = Array.get(callingParams[j], arrayIndex);
                    continue;
                }
                double arg = -1.0;
                if (calledClass.isPrimitive()) {
                    arg = Array.getDouble(callingParams[j], arrayIndex);
                } else if (calledClass.isAssignableFrom(BigDecimal.class)) {
                    arg = ((BigDecimal[])callingParams[j])[arrayIndex].doubleValue();
                } else if (calledClass.isAssignableFrom(Byte.class) || calledClass.isAssignableFrom(Character.class) || calledClass.isAssignableFrom(Short.class) || calledClass.isAssignableFrom(Integer.class) || calledClass.isAssignableFrom(Long.class) || calledClass.isAssignableFrom(Float.class) || calledClass.isAssignableFrom(Double.class)) {
                    arg = Double.valueOf(Array.get(callingParams[j], arrayIndex).toString());
                } else {
                    System.err.println("updateParamsAfterInvoke error: " + calledClass.toString() + " - " + paramClass.toString());
                }
                if (sourceIsArray) {
                    switch (DynamicExecute.getPrimitiveType(paramClass)) {
                        case 1: {
                            ((byte[])params[j])[arrayIndex] = (byte)arg;
                            break;
                        }
                        case 2: {
                            ((char[])params[j])[arrayIndex] = (char)arg;
                            break;
                        }
                        case 3: {
                            ((short[])params[j])[arrayIndex] = (short)arg;
                            break;
                        }
                        case 4: {
                            ((int[])params[j])[arrayIndex] = (int)arg;
                            break;
                        }
                        case 5: {
                            ((long[])params[j])[arrayIndex] = (long)arg;
                            break;
                        }
                        case 6: {
                            ((float[])params[j])[arrayIndex] = (float)arg;
                            break;
                        }
                        case 7: {
                            ((double[])params[j])[arrayIndex] = arg;
                            break;
                        }
                        case 40: {
                            ((BigDecimal[])params[j])[arrayIndex] = new BigDecimal(arg);
                        }
                    }
                    continue;
                }
                switch (DynamicExecute.getPrimitiveType(paramClass)) {
                    case 1: {
                        params[j] = new Byte((byte)arg);
                        continue block21;
                    }
                    case 2: {
                        params[j] = new Character((char)arg);
                        continue block21;
                    }
                    case 3: {
                        params[j] = new Short((short)arg);
                        continue block21;
                    }
                    case 4: {
                        params[j] = new Integer((int)arg);
                        continue block21;
                    }
                    case 5: {
                        params[j] = new Long((long)arg);
                        continue block21;
                    }
                    case 6: {
                        params[j] = new Float((float)arg);
                        continue block21;
                    }
                    case 7: {
                        params[j] = new Double(arg);
                        continue block21;
                    }
                    case 40: {
                        params[j] = new BigDecimal(arg);
                    }
                }
            }
        }
    }

    protected static int getPrimitiveType(Class<?> clase) {
        if (clase.isAssignableFrom(Byte.class) || clase.isAssignableFrom(Byte.TYPE)) {
            return 1;
        }
        if (clase.isAssignableFrom(Character.class) || clase.isAssignableFrom(Character.TYPE)) {
            return 2;
        }
        if (clase.isAssignableFrom(Short.class) || clase.isAssignableFrom(Short.TYPE)) {
            return 3;
        }
        if (clase.isAssignableFrom(Integer.class) || clase.isAssignableFrom(Integer.TYPE)) {
            return 4;
        }
        if (clase.isAssignableFrom(Long.class) || clase.isAssignableFrom(Long.TYPE)) {
            return 5;
        }
        if (clase.isAssignableFrom(Float.class) || clase.isAssignableFrom(Float.TYPE)) {
            return 6;
        }
        if (clase.isAssignableFrom(Double.class) || clase.isAssignableFrom(Double.TYPE)) {
            return 7;
        }
        if (clase.isAssignableFrom(BigDecimal.class)) {
            return 40;
        }
        if (clase.isAssignableFrom(Boolean.class) || clase.isAssignableFrom(Boolean.TYPE)) {
            return 8;
        }
        return -1;
    }
}

