/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.diagnostics;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;

public class Log {
    private static ILogger getLogger() {
        return Log.getLogger("");
    }

    public static ILogger getMainLogger() {
        return LogManager.getLogger("com.genexus.logging");
    }

    private static ILogger getLogger(String topic) {
        ILogger log = topic != null && topic.length() > 0 ? LogManager.getLogger(topic) : Log.getMainLogger();
        return log;
    }

    public static void write(int logLevel, String message, String topic) {
        Log.write(message, topic, logLevel);
    }

    public static void write(String message, String topic, int logLevel) {
        ILogger log = Log.getLogger(topic);
        switch (logLevel) {
            case 0: {
                break;
            }
            case 1: {
                log.trace(message);
                break;
            }
            case 5: {
                log.debug(message);
                break;
            }
            case 10: {
                log.info(message);
                break;
            }
            case 15: {
                log.warn(message);
                break;
            }
            case 20: {
                log.error(message);
                break;
            }
            case 30: {
                log.fatal(message);
                break;
            }
            default: {
                log.debug(message);
            }
        }
    }

    public static void write(String message) {
        Log.getLogger().debug(message);
    }

    public static void write(String message, String topic) {
        Log.getLogger(topic).debug(message);
    }

    public static void error(String message) {
        Log.getLogger().error(message);
    }

    public static void error(String message, String topic) {
        Log.getLogger(topic).error(message);
    }

    public static void error(String message, String topic, Throwable ex) {
        Log.getLogger(topic).error(message, ex);
    }

    public static void fatal(String message) {
        Log.getLogger().fatal(message);
    }

    public static void fatal(String message, String topic) {
        Log.getLogger(topic).fatal(message);
    }

    public static void fatal(String message, String topic, Throwable ex) {
        Log.getLogger(topic).fatal(message, ex);
    }

    public static void warning(String message) {
        Log.getLogger().warn(message);
    }

    public static void warning(String message, String topic) {
        Log.getLogger(topic).warn(message);
    }

    public static void warning(String message, String topic, Throwable ex) {
        Log.getLogger(topic).warn(message, ex);
    }

    public static void info(String message) {
        Log.getLogger().info(message);
    }

    public static void info(String message, String topic) {
        Log.getLogger(topic).info(message);
    }

    public static void debug(String message) {
        Log.getLogger().debug(message);
    }

    public static void debug(String message, String topic) {
        Log.getLogger(topic).debug(message);
    }

    public static void debug(String message, String topic, Throwable ex) {
        Log.getLogger(topic).debug(message, ex);
    }
}

