/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.diagnostics;

import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;

public class UserLog {
    public static String defaultUserLogNamespace = SpecificImplementation.UserLog.GetLogName();

    private static ILogger getLogger() {
        return UserLog.getLogger("");
    }

    public static ILogger getMainLogger() {
        return LogManager.getLogger(defaultUserLogNamespace);
    }

    private static ILogger getLogger(String topic) {
        ILogger log;
        if (topic != null && topic.length() > 0) {
            String loggerName = topic.startsWith("$") ? topic.substring(1) : String.format("%s.%s", defaultUserLogNamespace, topic.trim());
            log = LogManager.getLogger(loggerName);
        } else {
            log = UserLog.getMainLogger();
        }
        return log;
    }

    public static void write(int logLevel, String message, String topic) {
        ILogger log = UserLog.getLogger(topic);
        switch (logLevel) {
            case 0: {
                break;
            }
            case 1: {
                log.trace(message);
                break;
            }
            case 5: {
                log.debug(message);
                break;
            }
            case 10: {
                log.info(message);
                break;
            }
            case 15: {
                log.warn(message);
                break;
            }
            case 20: {
                log.error(message);
                break;
            }
            case 30: {
                log.fatal(message);
                break;
            }
            default: {
                log.debug(message);
            }
        }
    }

    public static void write(String message) {
        UserLog.getLogger().debug(message);
    }

    public static void write(String message, String topic, int logLevel) {
        UserLog.write(logLevel, message, topic);
    }

    public static void error(String message) {
        UserLog.getLogger().error(message);
    }

    public static void error(String message, String topic) {
        UserLog.getLogger(topic).error(message);
    }

    public static void error(String message, String topic, Throwable ex) {
        UserLog.getLogger(topic).error(message, ex);
    }

    public static void fatal(String message) {
        UserLog.getLogger().fatal(message);
    }

    public static void fatal(String message, String topic) {
        UserLog.getLogger(topic).fatal(message);
    }

    public static void fatal(String message, String topic, Throwable ex) {
        UserLog.getLogger(topic).fatal(message, ex);
    }

    public static void warning(String message) {
        UserLog.getLogger().warn(message);
    }

    public static void warning(String message, String topic) {
        UserLog.getLogger(topic).warn(message);
    }

    public static void warning(String message, String topic, Throwable ex) {
        UserLog.getLogger(topic).warn(message, ex);
    }

    public static void info(String message) {
        UserLog.getLogger().info(message);
    }

    public static void info(String message, String topic) {
        UserLog.getLogger(topic).info(message);
    }

    public static void debug(String message) {
        UserLog.getLogger().debug(message);
    }

    public static void debug(String message, String topic) {
        UserLog.getLogger(topic).debug(message);
    }

    public static void debug(String message, String topic, Throwable ex) {
        UserLog.getLogger(topic).debug(message, ex);
    }
}

